import { useTypedQuery, useTypedSubscription } from '../graphql'
import { GetExerciseLoopStatus } from '../queries'
import { exerciseLoopRunning } from '../subscriptions'

const useExerciseLoopStatusSubscription = (exerciseId?: string) => {
  const query = useTypedQuery({
    query: GetExerciseLoopStatus,
    variables: {
      exerciseId: exerciseId || '',
    },
    pause: !exerciseId,
    requestPolicy: 'network-only',
  })
  useTypedSubscription({
    query: exerciseLoopRunning,
    variables: {
      exerciseId: exerciseId || '',
    },
    pause: !exerciseId,
  })

  return query
}

export default useExerciseLoopStatusSubscription
