import { httpHello } from '@inject/shared/config'
import { useEffect, useState } from 'react'
import { useHost } from '../connection/host'

const useBackendVersion = () => {
  const [data, setData] = useState<string | null>(null)
  const host = useHost()

  useEffect(() => {
    fetch(httpHello(host || '')).then(async e => {
      const version = JSON.parse(await e.text())['version']
      setData(version.startsWith('v') ? version.substring(1) : version)
    })
  }, [setData, host])

  return data
}

export default useBackendVersion
