import { useTypedQuery, useTypedSubscription } from '../graphql'
import { GetAnalyticsMilestones } from '../queries'
import { exerciseMilestones } from '../subscriptions'

const useAnalyticsMilestonesSubscription = (exerciseId: string) => {
  const query = useTypedQuery({
    query: GetAnalyticsMilestones,
    variables: { exerciseId },
  })
  useTypedSubscription({
    query: exerciseMilestones,
    variables: { exerciseId },
  })

  return query
}

export default useAnalyticsMilestonesSubscription
