import { useQuery, useSubscription } from 'urql'
import { GetAnalyticsActionLogs } from '../queries'
import { exerciseActionLogs } from '../subscriptions'

const useAnalyticsActionLogsSubscription = (exerciseId: string) => {
  const query = useQuery({
    query: GetAnalyticsActionLogs,
    variables: { exerciseId, newestFirst: true },
  })
  useSubscription({
    query: exerciseActionLogs,
    variables: {
      exerciseId,
    },
  })

  return query
}

export default useAnalyticsActionLogsSubscription
