import type { Cache } from '@urql/exchange-graphcache'

function getTeamActionLogs(cache: Cache, teamId: string) {
  const exercise = cache.resolve(
    { __typename: 'TeamType', id: teamId },
    'exercise'
  )
  if (typeof exercise === 'string') {
    const exerciseId = exercise.slice('ExerciseType:'.length)
    const reverseActionLogs = cache.resolve('Query', 'analyticsActionLogs', {
      exerciseId,
    })
    if (Array.isArray(reverseActionLogs)) {
      return (reverseActionLogs as string[]).filter(
        x => cache.resolve(x, 'team') === `TeamType:${teamId}`
      )
    }
  }
}

export default getTeamActionLogs
