import { makeExecutableSchema } from '@graphql-tools/schema'
import Keys from '@inject/shared/localstorage/keys'
import emailDraftsQL from '../../schemas/emailDrafts.graphql'
import type { EmailDraftType } from '../cache-typing'
import type { SubschemaConfig } from './typing'

const emailReceiptsSchema: SubschemaConfig = {
  schema: makeExecutableSchema({
    typeDefs: [emailDraftsQL],
    resolvers: {
      Query: {
        getEmailDraft: async (_, { teamId, instructor, emailThreadId }) => {
          const item = localStorage.getItem(
            Keys.getEmailDraftsKey(teamId, instructor)
          )
          const drafts = JSON.parse(item || '[]') as EmailDraftType[]
          const draft = drafts.find(
            draft =>
              (!draft.emailThreadId && !emailThreadId) ||
              draft.emailThreadId === emailThreadId
          )
          return draft
            ? {
                ...draft,
              }
            : null
        },

        async getEmailDrafts(_, { teamId, instructor }) {
          const item = localStorage.getItem(
            Keys.getEmailDraftsKey(teamId, instructor)
          )
          const drafts = JSON.parse(item || '[]') as EmailDraftType[]
          return drafts
        },
      },
      Mutation: {
        async setEmailDraft(_, { emailDraft }) {
          const item = localStorage.getItem(
            Keys.getEmailDraftsKey(emailDraft.teamId, emailDraft.instructor)
          )
          const drafts = JSON.parse(item || '[]') as EmailDraftType[]
          const existingDraftIndex = drafts.findIndex(
            draft =>
              draft.teamId === emailDraft.teamId &&
              ((!draft.emailThreadId && !emailDraft.emailThreadId) ||
                draft.emailThreadId === emailDraft.emailThreadId) &&
              draft.instructor === emailDraft.instructor
          )
          localStorage.setItem(
            Keys.getEmailDraftsKey(emailDraft.teamId, emailDraft.instructor),
            JSON.stringify(
              existingDraftIndex === -1
                ? [...drafts, emailDraft]
                : [
                    ...drafts.slice(0, existingDraftIndex),
                    emailDraft,
                    ...drafts.slice(existingDraftIndex + 1),
                  ]
            )
          )

          return {
            ...emailDraft,
          }
        },
        async deleteEmailDraft(_, { teamId, instructor, emailThreadId }) {
          const item = localStorage.getItem(
            Keys.getEmailDraftsKey(teamId, instructor)
          )
          const drafts = JSON.parse(item || '[]') as EmailDraftType[]
          const existingDraftIndex = drafts.findIndex(
            draft =>
              draft.teamId === teamId &&
              ((!draft.emailThreadId && !emailThreadId) ||
                draft.emailThreadId === emailThreadId) &&
              draft.instructor === instructor
          )
          if (existingDraftIndex === -1) {
            return { operationDone: false }
          }
          localStorage.setItem(
            Keys.getEmailDraftsKey(teamId, instructor),
            JSON.stringify([
              ...drafts.slice(0, existingDraftIndex),
              ...drafts.slice(existingDraftIndex + 1),
            ])
          )
          return { operationDone: true }
        },
      },
    },
  }),
}

export default emailReceiptsSchema
