/* eslint-disable */
import { offlineExchange } from '@urql/exchange-graphcache';
import type { Resolver as GraphCacheResolver, UpdateResolver as GraphCacheUpdateResolver, OptimisticMutationResolver as GraphCacheOptimisticMutationResolver } from '@urql/exchange-graphcache';

export type Maybe<T> = T | null;
export type InputMaybe<T> = Maybe<T>;
export type Exact<T extends { [key: string]: unknown }> = { [K in keyof T]: T[K] };
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]?: Maybe<T[SubKey]> };
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]: Maybe<T[SubKey]> };
export type MakeEmpty<T extends { [key: string]: unknown }, K extends keyof T> = { [_ in K]?: never };
export type Incremental<T> = T | { [P in keyof T]?: P extends ' $fragmentName' | '__typename' ? T[P] : never };
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: { input: string; output: string; }
  String: { input: string; output: string; }
  Boolean: { input: boolean; output: boolean; }
  Int: { input: number; output: number; }
  Float: { input: number; output: number; }
  /**
   * The `DateTime` scalar type represents a DateTime
   * value as specified by
   * [iso8601](https://en.wikipedia.org/wiki/ISO_8601).
   */
  DateTime: { input: string; output: string; }
  /**
   * Leverages the internal Python implmeentation of UUID (uuid.UUID) to provide native UUID objects
   * in fields, resolvers and input.
   */
  UUID: { input: any; output: any; }
};

export type ActionLogDetails = CustomInjectDetailsType | EmailType | InjectDetailsType | QuestionnaireType | ToolDetailsType;

export type ActionLogType = {
  __typename: 'ActionLogType';
  channel: DefinitionChannelType;
  details: ActionLogDetails;
  id: Scalars['ID']['output'];
  readReceipt: Maybe<Scalars['DateTime']['output']>;
  requiresAttention: Scalars['Boolean']['output'];
  team: TeamType;
  teamId: Scalars['ID']['output'];
  timestamp: Scalars['DateTime']['output'];
  todo: Scalars['Boolean']['output'];
  type: LogType;
};

export type ActionLogsSubscription = {
  __typename: 'ActionLogsSubscription';
  actionLog: ActionLogType;
  eventType: EventType;
};

export type AddDefinitionAccessMutation = {
  __typename: 'AddDefinitionAccessMutation';
  operationDone: Scalars['Boolean']['output'];
};

export type AnalyticsActionLogsSubscription = {
  __typename: 'AnalyticsActionLogsSubscription';
  actionLog: ActionLogType;
  eventType: EventType;
};

export type AnalyticsEmailThreadSubscription = {
  __typename: 'AnalyticsEmailThreadSubscription';
  emailThread: EmailThreadType;
};

export type AnalyticsMilestonesSubscription = {
  __typename: 'AnalyticsMilestonesSubscription';
  milestones: Array<MilestoneStateType>;
};

export type AnswerInput = {
  questionId: Scalars['ID']['input'];
  /** Answer to the specific question, in case of `RADIO` type question, it is the string representation of the numeric position of the selected option, 1-based */
  value: Scalars['String']['input'];
};

export type AnswerQuestionnaireMutation = {
  __typename: 'AnswerQuestionnaireMutation';
  operationDone: Scalars['Boolean']['output'];
};

export type AnswerType = {
  __typename: 'AnswerType';
  questionId: Scalars['ID']['output'];
  /** Answer to the specific question, in case of `RADIO` type question, it is the string representation of the numeric position of the selected option, 1-based */
  value: Scalars['String']['output'];
};

export type AssignInstructorsToExercise = {
  __typename: 'AssignInstructorsToExercise';
  operationDone: Scalars['Boolean']['output'];
};

export type AssignUsersByTags = {
  __typename: 'AssignUsersByTags';
  operationDone: Scalars['Boolean']['output'];
};

export type AssignUsersEqually = {
  __typename: 'AssignUsersEqually';
  operationDone: Scalars['Boolean']['output'];
};

export type AssignUsersToTeamMutation = {
  __typename: 'AssignUsersToTeamMutation';
  operationDone: Scalars['Boolean']['output'];
};

/** An enumeration. */
export type AuthGroup =
  | 'ADMIN'
  | 'INSTRUCTOR'
  | 'TRAINEE'
  | '%future added value';

export type ChangeUserDataMutation = {
  __typename: 'ChangeUserDataMutation';
  user: UserType;
};

export type ChangeUserInput = {
  active: InputMaybe<Scalars['Boolean']['input']>;
  group: InputMaybe<AuthGroup>;
  userId: Scalars['UUID']['input'];
};

export type ChangeUserType = {
  __typename: 'ChangeUserType';
  active: Maybe<Scalars['Boolean']['output']>;
  group: Maybe<AuthGroup>;
  userId: Scalars['UUID']['output'];
};

export type ChannelReceipt = {
  __typename: 'ChannelReceipt';
  id: Scalars['ID']['output'];
  isUnread: Maybe<Scalars['Boolean']['output']>;
  teamId: Scalars['ID']['output'];
};

/** An enumeration. */
export type ChannelType =
  /** Email */
  | 'EMAIL'
  /** Form */
  | 'FORM'
  /** Info */
  | 'INFO'
  /** Tool */
  | 'TOOL'
  | '%future added value';

export type ConfigOverrideInput = {
  customEmailSuffix: InputMaybe<Scalars['String']['input']>;
  customTeamNames: InputMaybe<Array<Scalars['String']['input']>>;
  emailBetweenTeams: InputMaybe<Scalars['Boolean']['input']>;
  exerciseDuration: InputMaybe<Scalars['Int']['input']>;
  showExerciseTime: InputMaybe<Scalars['Boolean']['input']>;
};

export type ConfigOverrideType = {
  __typename: 'ConfigOverrideType';
  customEmailSuffix: Maybe<Scalars['String']['output']>;
  customTeamNames: Maybe<Array<Scalars['String']['output']>>;
  emailBetweenTeams: Maybe<Scalars['Boolean']['output']>;
  exerciseDuration: Maybe<Scalars['Int']['output']>;
  showExerciseTime: Maybe<Scalars['Boolean']['output']>;
};

export type ConfirmActionMutation = {
  __typename: 'ConfirmActionMutation';
  actionLog: ActionLogType;
};

export type ConfirmationType = {
  __typename: 'ConfirmationType';
  control: ControlType;
  id: Scalars['ID']['output'];
  text: Scalars['String']['output'];
};

export type ContentType = {
  __typename: 'ContentType';
  fileInfo: Maybe<FileInfoType>;
  id: Scalars['ID']['output'];
  raw: Scalars['String']['output'];
  rendered: Scalars['String']['output'];
};

export type ControlType = {
  __typename: 'ControlType';
  activateMilestone: Scalars['String']['output'];
  deactivateMilestone: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  milestoneCondition: Scalars['String']['output'];
  roles: Scalars['String']['output'];
};

export type ControlsMapType = {
  __typename: 'ControlsMapType';
  choice: Scalars['Int']['output'];
  control: ControlType;
};

export type CopyUsersAssignment = {
  __typename: 'CopyUsersAssignment';
  operationDone: Scalars['Boolean']['output'];
};

export type CreateExerciseInput = {
  configOverride: InputMaybe<ConfigOverrideInput>;
  definitionId: Scalars['ID']['input'];
  name: InputMaybe<Scalars['String']['input']>;
  teamCount: Scalars['Int']['input'];
};

export type CreateExerciseMutation = {
  __typename: 'CreateExerciseMutation';
  exercise: ExerciseType;
};

export type CreateExerciseType = {
  __typename: 'CreateExerciseType';
  configOverride: Maybe<ConfigOverrideType>;
  definitionId: Scalars['ID']['output'];
  name: Maybe<Scalars['String']['output']>;
  teamCount: Scalars['Int']['output'];
};

export type CreateTagMutation = {
  __typename: 'CreateTagMutation';
  newTag: TagType;
};

export type CreateThreadMutation = {
  __typename: 'CreateThreadMutation';
  thread: EmailThreadType;
};

export type CreateUserInput = {
  email: Scalars['String']['input'];
  firstName: InputMaybe<Scalars['String']['input']>;
  group: InputMaybe<AuthGroup>;
  lastName: InputMaybe<Scalars['String']['input']>;
  tags: Array<Scalars['String']['input']>;
};

export type CreateUserMutation = {
  __typename: 'CreateUserMutation';
  newUser: RestrictedUser;
};

export type CreateUserType = {
  __typename: 'CreateUserType';
  email: Scalars['String']['output'];
  firstName: Maybe<Scalars['String']['output']>;
  group: Maybe<AuthGroup>;
  lastName: Maybe<Scalars['String']['output']>;
  tags: Array<Scalars['String']['output']>;
};

export type CustomInjectDetailsType = {
  __typename: 'CustomInjectDetailsType';
  content: ContentType;
  id: Scalars['ID']['output'];
  overlay: Maybe<OverlayType>;
  user: Maybe<RestrictedUser>;
};

export type CustomInjectInput = {
  channelId: Scalars['ID']['input'];
  content: Scalars['String']['input'];
  exerciseId: Scalars['ID']['input'];
  fileId: InputMaybe<Scalars['UUID']['input']>;
  overlay: InputMaybe<OverlayInput>;
  teamIds: Array<InputMaybe<Scalars['ID']['input']>>;
};

export type CustomInjectType = {
  __typename: 'CustomInjectType';
  channelId: Scalars['ID']['output'];
  content: Scalars['String']['output'];
  exerciseId: Scalars['ID']['output'];
  fileId: Maybe<Scalars['UUID']['output']>;
  overlay: Maybe<OverlayType>;
  teamIds: Array<Maybe<Scalars['ID']['output']>>;
};

export type DefinitionChannelType = {
  __typename: 'DefinitionChannelType';
  definition: DefinitionType;
  description: Scalars['String']['output'];
  displayName: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  readReceipt: Array<ChannelReceipt>;
  type: ChannelType;
};

export type DefinitionInjectType = {
  __typename: 'DefinitionInjectType';
  delay: Scalars['Int']['output'];
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  organization: Scalars['String']['output'];
  target: DefinitionChannelType;
  time: Scalars['Int']['output'];
  type: InjectType;
};

export type DefinitionRoleType = {
  __typename: 'DefinitionRoleType';
  definition: DefinitionType;
  description: Scalars['String']['output'];
  displayName: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
};

export type DefinitionType = {
  __typename: 'DefinitionType';
  addresses: Array<EmailAddressType>;
  channels: Array<DefinitionChannelType>;
  description: Scalars['String']['output'];
  exercises: Array<ExerciseType>;
  files: Array<FileInfoType>;
  id: Scalars['ID']['output'];
  injects: Array<DefinitionInjectType>;
  learningObjectives: Array<LearningObjectiveType>;
  maintainers: Array<RestrictedUser>;
  name: Scalars['String']['output'];
  prerequisites: Array<Scalars['String']['output']>;
  questionnaires: Array<QuestionnaireType>;
  roles: Array<DefinitionRoleType>;
  targetAudience: Scalars['String']['output'];
  timestampCreated: Scalars['DateTime']['output'];
  tools: Array<ToolType>;
  uploadedBy: Maybe<RestrictedUser>;
  version: Scalars['String']['output'];
};

export type DeleteDefinitionMutation = {
  __typename: 'DeleteDefinitionMutation';
  definitionId: Scalars['ID']['output'];
  exerciseIds: Array<Scalars['ID']['output']>;
  operationDone: Scalars['Boolean']['output'];
  teamIds: Array<Scalars['ID']['output']>;
};

export type DeleteExerciseMutation = {
  __typename: 'DeleteExerciseMutation';
  exerciseId: Scalars['ID']['output'];
  operationDone: Scalars['Boolean']['output'];
  teamIds: Array<Scalars['ID']['output']>;
};

export type DeleteTagsMutation = {
  __typename: 'DeleteTagsMutation';
  operationDone: Scalars['Boolean']['output'];
  tagIds: Array<Scalars['ID']['output']>;
};

export type DeleteUsersMutation = {
  __typename: 'DeleteUsersMutation';
  operationDone: Scalars['Boolean']['output'];
  userIds: Array<Scalars['ID']['output']>;
};

export type EmailAddressType = {
  __typename: 'EmailAddressType';
  address: Scalars['String']['output'];
  control: ControlType;
  definition: ExerciseDefinitionType;
  description: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  organization: Scalars['String']['output'];
  teamVisible: Scalars['Boolean']['output'];
  templates: Array<EmailTemplateType>;
};

export type EmailDraftInput = {
  activateMilestone: InputMaybe<Scalars['String']['input']>;
  content: InputMaybe<Scalars['String']['input']>;
  deactivateMilestone: InputMaybe<Scalars['String']['input']>;
  emailThreadId: InputMaybe<Scalars['String']['input']>;
  fileId: InputMaybe<Scalars['UUID']['input']>;
  instructor: Scalars['Boolean']['input'];
  selectedContacts: InputMaybe<Array<InputMaybe<Scalars['String']['input']>>>;
  senderAddress: InputMaybe<Scalars['String']['input']>;
  subject: InputMaybe<Scalars['String']['input']>;
  teamId: Scalars['String']['input'];
  templateId: InputMaybe<Scalars['String']['input']>;
};

export type EmailDraftType = {
  __typename: 'EmailDraftType';
  activateMilestone: Maybe<Scalars['String']['output']>;
  content: Maybe<Scalars['String']['output']>;
  deactivateMilestone: Maybe<Scalars['String']['output']>;
  emailThreadId: Maybe<Scalars['String']['output']>;
  fileId: Maybe<Scalars['UUID']['output']>;
  instructor: Scalars['Boolean']['output'];
  selectedContacts: Maybe<Array<Maybe<Scalars['String']['output']>>>;
  senderAddress: Maybe<Scalars['String']['output']>;
  subject: Maybe<Scalars['String']['output']>;
  teamId: Scalars['String']['output'];
  templateId: Maybe<Scalars['String']['output']>;
};

export type EmailParticipantType = {
  __typename: 'EmailParticipantType';
  address: Scalars['String']['output'];
  definitionAddress: Maybe<EmailAddressType>;
  emails: Array<EmailType>;
  exercise: ExerciseType;
  id: Scalars['ID']['output'];
  team: Maybe<TeamType>;
  threads: Array<EmailThreadType>;
};

export type EmailReceipt = {
  __typename: 'EmailReceipt';
  emailId: Scalars['ID']['output'];
  readReceipt: Maybe<Scalars['DateTime']['output']>;
};

export type EmailTemplateType = {
  __typename: 'EmailTemplateType';
  content: ContentType;
  context: Scalars['String']['output'];
  control: ControlType;
  id: Scalars['ID']['output'];
  sender: Scalars['String']['output'];
  subject: Scalars['String']['output'];
};

export type EmailThreadReceipt = {
  __typename: 'EmailThreadReceipt';
  isUnread: Maybe<Scalars['Boolean']['output']>;
  teamId: Scalars['ID']['output'];
  threadId: Scalars['ID']['output'];
};

export type EmailThreadSubscription = {
  __typename: 'EmailThreadSubscription';
  emailThread: EmailThreadType;
};

export type EmailThreadType = {
  __typename: 'EmailThreadType';
  archived: Scalars['Boolean']['output'];
  emails: Array<EmailType>;
  exercise: ExerciseType;
  id: Scalars['ID']['output'];
  lastEmail: Maybe<EmailType>;
  participants: Array<EmailParticipantType>;
  readReceipt: Array<EmailThreadReceipt>;
  subject: Scalars['String']['output'];
  timestamp: Scalars['DateTime']['output'];
};

export type EmailType = {
  __typename: 'EmailType';
  content: ContentType;
  id: Scalars['ID']['output'];
  overlay: Maybe<OverlayType>;
  readReceipt: Maybe<Scalars['DateTime']['output']>;
  sender: EmailParticipantType;
  thread: EmailThreadType;
  timestamp: Scalars['DateTime']['output'];
  todo: Scalars['Boolean']['output'];
  user: Maybe<RestrictedUser>;
};

/** An enumeration. */
export type EventType =
  | 'CREATE'
  | 'DELETE'
  | 'MODIFY'
  | '%future added value';

export type ExerciseDefinitionType = {
  __typename: 'ExerciseDefinitionType';
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
};

export type ExerciseLoopRunningSubscription = {
  __typename: 'ExerciseLoopRunningSubscription';
  exerciseLoopRunning: Scalars['Boolean']['output'];
};

export type ExerciseType = {
  __typename: 'ExerciseType';
  createdBy: Maybe<RestrictedUser>;
  definition: ExerciseDefinitionType;
  elapsedS: Scalars['Int']['output'];
  emailParticipants: Array<EmailParticipantType>;
  exerciseStart: Maybe<Scalars['DateTime']['output']>;
  finished: Scalars['Boolean']['output'];
  id: Scalars['ID']['output'];
  instructors: Array<RestrictedUser>;
  name: Scalars['String']['output'];
  running: Scalars['Boolean']['output'];
  teams: Array<TeamType>;
  threads: Array<EmailThreadType>;
  timestampCreated: Scalars['DateTime']['output'];
  uuid: Scalars['UUID']['output'];
};

export type ExercisesSubscription = {
  __typename: 'ExercisesSubscription';
  eventType: EventType;
  exercise: ExerciseType;
};

export type ExtendedToolType = {
  __typename: 'ExtendedToolType';
  category: Scalars['String']['output'];
  defaultResponse: Scalars['String']['output'];
  definition: Maybe<ExerciseDefinitionType>;
  hint: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  responses: Array<ToolResponseType>;
  roles: Scalars['String']['output'];
  tooltipDescription: Scalars['String']['output'];
};

export type FileInfoType = {
  __typename: 'FileInfoType';
  definition: Maybe<DefinitionType>;
  fileName: Scalars['String']['output'];
  id: Scalars['UUID']['output'];
};

export type FilterUsersInput = {
  active: InputMaybe<Scalars['Boolean']['input']>;
  firstName: InputMaybe<Scalars['String']['input']>;
  groups: InputMaybe<Array<InputMaybe<AuthGroup>>>;
  imported: InputMaybe<Scalars['Boolean']['input']>;
  lastName: InputMaybe<Scalars['String']['input']>;
  limit: InputMaybe<Scalars['Int']['input']>;
  skip: InputMaybe<Scalars['Int']['input']>;
  tags: InputMaybe<Array<InputMaybe<Scalars['String']['input']>>>;
  username: InputMaybe<Scalars['String']['input']>;
};

export type FilterUsersType = {
  __typename: 'FilterUsersType';
  active: Maybe<Scalars['Boolean']['output']>;
  firstName: Maybe<Scalars['String']['output']>;
  groups: Maybe<Array<Maybe<AuthGroup>>>;
  imported: Maybe<Scalars['Boolean']['output']>;
  lastName: Maybe<Scalars['String']['output']>;
  limit: Maybe<Scalars['Int']['output']>;
  skip: Maybe<Scalars['Int']['output']>;
  tags: Maybe<Array<Maybe<Scalars['String']['output']>>>;
  username: Maybe<Scalars['String']['output']>;
};

export type FreeFormQuestionDetailsType = {
  __typename: 'FreeFormQuestionDetailsType';
  definition: ExerciseDefinitionType;
  id: Scalars['ID']['output'];
  multiline: Scalars['Boolean']['output'];
  relatedMilestones: Array<MilestoneType>;
};

export type GrapheneConfig = {
  __typename: 'GrapheneConfig';
  customEmailSuffix: Maybe<Scalars['String']['output']>;
  emailBetweenTeams: Maybe<Scalars['Boolean']['output']>;
  enableRoles: Maybe<Scalars['Boolean']['output']>;
  exerciseDuration: Maybe<Scalars['Int']['output']>;
  showExerciseTime: Maybe<Scalars['Boolean']['output']>;
};

export type InjectDetailsType = {
  __typename: 'InjectDetailsType';
  confirmation: Maybe<ConfirmationType>;
  confirmed: Maybe<Scalars['Boolean']['output']>;
  confirmedBy: Maybe<RestrictedUser>;
  content: ContentType;
  id: Scalars['ID']['output'];
  inject: DefinitionInjectType;
  overlay: Maybe<OverlayType>;
  timestampConfirmed: Maybe<Scalars['DateTime']['output']>;
};

/** An enumeration. */
export type InjectType =
  /** Email */
  | 'EMAIL'
  /** Form */
  | 'FORM'
  /** Info */
  | 'INFO'
  /** Tool */
  | 'TOOL'
  | '%future added value';

export type LearningActivityType = {
  __typename: 'LearningActivityType';
  description: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  milestones: Array<MilestoneType>;
  name: Scalars['String']['output'];
  objective: LearningObjectiveType;
  tags: Scalars['String']['output'];
};

export type LearningObjectiveType = {
  __typename: 'LearningObjectiveType';
  activities: Array<LearningActivityType>;
  definition: DefinitionType;
  description: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  order: Scalars['Int']['output'];
  tags: Scalars['String']['output'];
};

/** An enumeration. */
export type LogType =
  | 'CUSTOM_INJECT'
  | 'EMAIL'
  | 'FORM'
  | 'INJECT'
  | 'TOOL'
  | '%future added value';

export type MilestoneStateHistoryType = {
  __typename: 'MilestoneStateHistoryType';
  id: Scalars['ID']['output'];
  reached: Scalars['Boolean']['output'];
  timestampFrom: Scalars['DateTime']['output'];
};

export type MilestoneStateType = {
  __typename: 'MilestoneStateType';
  activity: Maybe<TeamLearningActivityType>;
  history: Array<MilestoneStateHistoryType>;
  id: Scalars['ID']['output'];
  milestone: MilestoneType;
  reached: Scalars['Boolean']['output'];
  teamIds: Array<Scalars['ID']['output']>;
  timestampReached: Maybe<Scalars['DateTime']['output']>;
};

export type MilestoneType = {
  __typename: 'MilestoneType';
  activity: Maybe<LearningActivityType>;
  description: Scalars['String']['output'];
  displayName: Scalars['String']['output'];
  fileNames: Scalars['String']['output'];
  final: Scalars['Boolean']['output'];
  id: Scalars['ID']['output'];
  initialState: Scalars['Boolean']['output'];
  name: Scalars['String']['output'];
  roles: Scalars['String']['output'];
  tags: Array<Scalars['String']['output']>;
  teamVisible: Scalars['Boolean']['output'];
};

export type MilestonesSubscription = {
  __typename: 'MilestonesSubscription';
  milestones: Array<MilestoneStateType>;
};

export type ModifyMilestoneMutation = {
  __typename: 'ModifyMilestoneMutation';
  operationDone: Scalars['Boolean']['output'];
};

export type MoveExerciseTimeMutation = {
  __typename: 'MoveExerciseTimeMutation';
  exercise: ExerciseType;
};

export type Mutation = {
  __typename: 'Mutation';
  /** Mutation for granting access to the specific definition */
  addDefinitionAccess: Maybe<AddDefinitionAccessMutation>;
  /** Mutation for answering questionnaires */
  answerQuestionnaire: Maybe<AnswerQuestionnaireMutation>;
  /** Mutation for assigning instructors (users) to the exercise */
  assignInstructorsToExercise: Maybe<AssignInstructorsToExercise>;
  /** Mutation for assigning users to the teams by tags */
  assignUsersByTags: Maybe<AssignUsersByTags>;
  /** Mutation for assigning users to the exercise equally if possible */
  assignUsersEqually: Maybe<AssignUsersEqually>;
  /** Mutation for assigning users to the specific team of the exercise */
  assignUsersToTeam: Maybe<AssignUsersToTeamMutation>;
  /** Mutation for changing user data */
  changeUserData: Maybe<ChangeUserDataMutation>;
  /** Mutation for confirming actions */
  confirmAction: Maybe<ConfirmActionMutation>;
  /** Mutation for copying users assignments from one exercise to another */
  copyUsersAssignment: Maybe<CopyUsersAssignment>;
  /** Mutation that creates a new exercise with given definition by its id */
  createExercise: Maybe<CreateExerciseMutation>;
  /** Mutation for creating a tag */
  createTag: Maybe<CreateTagMutation>;
  /** Mutation for creating a new thread */
  createThread: Maybe<CreateThreadMutation>;
  /** Mutation for creating a user */
  createUser: Maybe<CreateUserMutation>;
  /** Mutation that deletes a definition of given id */
  deleteDefinition: Maybe<DeleteDefinitionMutation>;
  deleteEmailDraft: Maybe<MutationResult>;
  /** Mutation that deletes an exercise of given id */
  deleteExercise: Maybe<DeleteExerciseMutation>;
  /** Mutation for deleting a tag */
  deleteTags: Maybe<DeleteTagsMutation>;
  /** Mutation for deleting users */
  deleteUsers: Maybe<DeleteUsersMutation>;
  /** Mutation for instructors to modify a team's milestone state */
  modifyMilestone: Maybe<ModifyMilestoneMutation>;
  /** Mutation for moving the in-exercise time by the specified amount of minutes */
  moveTime: Maybe<MoveExerciseTimeMutation>;
  /** Mutation for changing a user's password */
  passwordChange: Maybe<PasswordChange>;
  /** Mutation for re-generating credentials for users */
  regenerateCredentials: Maybe<RegenerateCredentialsMutation>;
  reloadDefinitions: Maybe<MutationResult>;
  reloadExercises: Maybe<MutationResult>;
  reloadTable: Maybe<MutationResult>;
  /** Mutation for removing access of instructors (users) to the definition */
  removeDefinitionAccess: Maybe<RemoveDefinitionAccessMutation>;
  /** Mutation for removing instructors (users) from the exercise */
  removeInstructorsFromExercise: Maybe<RemoveInstructorsFromExerciseMutation>;
  /** Mutation for removing users from the specific team of the exercise */
  removeUsersFromTeam: Maybe<RemoveUsersFromTeamMutation>;
  /** Mutation for reviewing questionnaires */
  reviewQuestionnaire: Maybe<ReviewQuestionnaireMutation>;
  /** Mutation for sending custom injects */
  sendCustomInject: Maybe<SendCustomInjectMutation>;
  /** Mutation for sending an email */
  sendEmail: Maybe<SendEmailMutation>;
  setArchiveEmail: Maybe<MutationResult>;
  setEmailDraft: Maybe<EmailDraftType>;
  setEmailTodo: Maybe<MutationResult>;
  setIsUnreadChannel: Maybe<MutationResult>;
  setIsUnreadEmailThread: Maybe<MutationResult>;
  setTeamQuestionnaireTodo: Maybe<MutationResult>;
  /** @deprecated Field no longer supported */
  setTodoActionLog: Maybe<MutationResult>;
  /** Mutation for starting the specified exercise */
  startExercise: Maybe<StartExerciseMutation>;
  /** Mutation that stops an exercise of given id */
  stopExercise: Maybe<StopExerciseMutation>;
  /** Mutation for updating a tag */
  updateTag: Maybe<UpdateTagMutation>;
  /** Mutation for changing tag assignments */
  updateTagAssignments: Maybe<UpdateTagAssignmentsMutation>;
  /** Mutation for performing a tool action */
  useTool: Maybe<UseToolMutation>;
  writeReadReceipt: Maybe<ReadReceiptType>;
  writeReadReceiptEmail: Maybe<EmailReceipt>;
};


export type MutationAddDefinitionAccessArgs = {
  definitionId: Scalars['ID']['input'];
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationAnswerQuestionnaireArgs = {
  questInput: QuestionnaireInput;
};


export type MutationAssignInstructorsToExerciseArgs = {
  exerciseId: Scalars['ID']['input'];
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationAssignUsersByTagsArgs = {
  exerciseId: Scalars['ID']['input'];
  tagPrefix: Scalars['String']['input'];
  userIds: Array<Scalars['ID']['input']>;
};


export type MutationAssignUsersEquallyArgs = {
  exerciseId: Scalars['ID']['input'];
  userIds: Array<Scalars['ID']['input']>;
};


export type MutationAssignUsersToTeamArgs = {
  teamId: Scalars['ID']['input'];
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationChangeUserDataArgs = {
  changeUserInput: ChangeUserInput;
};


export type MutationConfirmActionArgs = {
  logId: Scalars['ID']['input'];
  teamId: Scalars['ID']['input'];
};


export type MutationCopyUsersAssignmentArgs = {
  fromExerciseId: Scalars['ID']['input'];
  toExerciseId: Scalars['ID']['input'];
};


export type MutationCreateExerciseArgs = {
  createExerciseInput: CreateExerciseInput;
};


export type MutationCreateTagArgs = {
  name: Scalars['String']['input'];
};


export type MutationCreateThreadArgs = {
  exerciseId: Scalars['ID']['input'];
  participantAddresses: Array<InputMaybe<Scalars['String']['input']>>;
  subject: Scalars['String']['input'];
};


export type MutationCreateUserArgs = {
  createUserInput: CreateUserInput;
};


export type MutationDeleteDefinitionArgs = {
  definitionId: Scalars['ID']['input'];
};


export type MutationDeleteEmailDraftArgs = {
  emailThreadId: InputMaybe<Scalars['ID']['input']>;
  instructor: Scalars['Boolean']['input'];
  teamId: Scalars['ID']['input'];
};


export type MutationDeleteExerciseArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type MutationDeleteTagsArgs = {
  force?: InputMaybe<Scalars['Boolean']['input']>;
  tagIds: Array<Scalars['ID']['input']>;
};


export type MutationDeleteUsersArgs = {
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationModifyMilestoneArgs = {
  activate?: InputMaybe<Scalars['Boolean']['input']>;
  milestone: Scalars['String']['input'];
  teamId: Scalars['ID']['input'];
};


export type MutationMoveTimeArgs = {
  exerciseId: Scalars['ID']['input'];
  timeDiff: Scalars['Int']['input'];
};


export type MutationPasswordChangeArgs = {
  newPassword: Scalars['String']['input'];
  newPasswordRepeat: Scalars['String']['input'];
  oldPassword: Scalars['String']['input'];
};


export type MutationRegenerateCredentialsArgs = {
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationRemoveDefinitionAccessArgs = {
  definitionId: Scalars['ID']['input'];
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationRemoveInstructorsFromExerciseArgs = {
  exerciseId: Scalars['ID']['input'];
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationRemoveUsersFromTeamArgs = {
  teamId: Scalars['ID']['input'];
  userIds: Array<InputMaybe<Scalars['ID']['input']>>;
};


export type MutationReviewQuestionnaireArgs = {
  reviewInput: QuestionnaireReviewInput;
};


export type MutationSendCustomInjectArgs = {
  customInjectInput: CustomInjectInput;
};


export type MutationSendEmailArgs = {
  sendEmailInput: SendEmailInput;
};


export type MutationSetArchiveEmailArgs = {
  emailThreadId: Scalars['ID']['input'];
  state: Scalars['Boolean']['input'];
};


export type MutationSetEmailDraftArgs = {
  emailDraft: EmailDraftInput;
};


export type MutationSetEmailTodoArgs = {
  emailId: Scalars['ID']['input'];
  state: Scalars['Boolean']['input'];
};


export type MutationSetIsUnreadChannelArgs = {
  channelId: Scalars['ID']['input'];
  isUnread: Scalars['Boolean']['input'];
  teamId: Scalars['ID']['input'];
};


export type MutationSetIsUnreadEmailThreadArgs = {
  isUnread: Scalars['Boolean']['input'];
  teamId: Scalars['ID']['input'];
  threadId: Scalars['ID']['input'];
};


export type MutationSetTeamQuestionnaireTodoArgs = {
  questionnaireId: Scalars['ID']['input'];
  state: Scalars['Boolean']['input'];
  teamId: Scalars['ID']['input'];
};


export type MutationSetTodoActionLogArgs = {
  actionLogId: Scalars['ID']['input'];
  state: Scalars['Boolean']['input'];
};


export type MutationStartExerciseArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type MutationStopExerciseArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type MutationUpdateTagArgs = {
  newName: Scalars['String']['input'];
  tagId: Scalars['ID']['input'];
};


export type MutationUpdateTagAssignmentsArgs = {
  updateTagAssignmentsInput: UpdateTagAssignmentsInput;
};


export type MutationUseToolArgs = {
  useToolInput: UseToolInput;
};


export type MutationWriteReadReceiptArgs = {
  actionLogId: Scalars['ID']['input'];
};


export type MutationWriteReadReceiptEmailArgs = {
  emailId: Scalars['ID']['input'];
};

export type MutationResult = {
  __typename: 'MutationResult';
  operationDone: Maybe<Scalars['Boolean']['output']>;
};

export type OverlayInput = {
  duration: Scalars['Int']['input'];
};

export type OverlayType = {
  __typename: 'OverlayType';
  duration: Scalars['Int']['output'];
  id: Scalars['ID']['output'];
};

export type PasswordChange = {
  __typename: 'PasswordChange';
  passwordChanged: Scalars['Boolean']['output'];
};

export type Query = {
  __typename: 'Query';
  /** Retrieve action log with given id */
  actionLog: ActionLogType;
  /** Retrieve all action logs for the specific exercise with optional ordering. Useful for analytics. */
  analyticsActionLogs: Array<ActionLogType>;
  /** Retrieve all email threads for the specific exercise. Useful for analytics. */
  analyticsEmailThreads: Array<EmailThreadType>;
  /** Retrieve all milestones for the specific exercise. Useful for analytics. */
  analyticsMilestones: Array<MilestoneStateType>;
  /** Retrieve a specific channel */
  channel: DefinitionChannelType;
  /** Retrieve a specific definition */
  definition: DefinitionType;
  /** Retrieve all definitions */
  definitions: Array<DefinitionType>;
  /** Retrieve the instructor email addresses from the specified email thread */
  emailAddresses: Array<Scalars['String']['output']>;
  /** Retrieve the specific email participant */
  emailContact: EmailParticipantType;
  /** Retrieve all email contacts for the running exercise */
  emailContacts: Array<EmailParticipantType>;
  /** Retrieve all email templates for the specified exercise and email addresses */
  emailTemplates: Array<EmailTemplateType>;
  /** Retrieve the specific email thread */
  emailThread: EmailThreadType;
  /** Retrieve all email threads for the specific team */
  emailThreads: Array<EmailThreadType>;
  /** Retrieve all channels for an exercise */
  exerciseChannels: Array<DefinitionChannelType>;
  /** Retrieve the config for the current running exercise */
  exerciseConfig: GrapheneConfig;
  /** Retrieve an exercise with matching id */
  exerciseId: ExerciseType;
  /** Retrieve the state of the exercise loop for the specific exercise */
  exerciseLoopRunning: Scalars['Boolean']['output'];
  /** Retrieve all questionnaire states for this exercise */
  exerciseQuestionnaires: Array<TeamQuestionnaireStateType>;
  /** Retrieve the amount of time left in the running exercise in seconds */
  exerciseTimeLeft: Scalars['Int']['output'];
  /** Retrieve all tools for the specific exercise. Useful for analytics. */
  exerciseTools: Array<ToolType>;
  /** Retrieve all exercises with optional parameters */
  exercises: Array<ExerciseType>;
  /** Retrieve all tools available to the specific team including all possible responses */
  extendedTeamTools: Array<ExtendedToolType>;
  /** Retrieve a specific file info */
  fileInfo: FileInfoType;
  getEmailDraft: Maybe<EmailDraftType>;
  getEmailDrafts: Maybe<Array<Maybe<EmailDraftType>>>;
  /** Retrieve all automatic injects */
  injects: Array<DefinitionInjectType>;
  /** Retrieve all learning objectives for an exercise */
  learningObjectives: Array<LearningObjectiveType>;
  /** Retrieve all milestones */
  milestones: Array<MilestoneType>;
  noopReceipt: Maybe<MutationResult>;
  noopReload: Maybe<MutationResult>;
  noopTodo: Maybe<MutationResult>;
  /** Retrieve the specific questionnaire state for this team */
  questionnaireState: TeamQuestionnaireStateType;
  /** Retrieve all questionnaires for an exercise */
  questionnaires: Array<QuestionnaireType>;
  /** Retrieve all tags (for filtering) */
  tags: Array<TagType>;
  /** Retrieve a specific team */
  team: TeamType;
  /** Retrieve all action logs for the specific team ordered ascending by timestamp */
  teamActionLogs: Array<ActionLogType>;
  /** Retrieve all team action logs for the specific channel ordered ascending by timestamp */
  teamChannelLogs: Array<ActionLogType>;
  /** Retrieve the email participant that belongs to the specified team */
  teamEmailParticipant: EmailParticipantType;
  /** Retrieve the learning objectives for the specific team */
  teamLearningObjectives: Array<TeamLearningObjectiveType>;
  /** Retrieve a specific milestone state */
  teamMilestone: MilestoneStateType;
  /** Retrieve all milestones for the specific team filtered by team visibility */
  teamMilestones: Array<MilestoneStateType>;
  /** Retrieve all questionnaire states for this team */
  teamQuestionnaires: Array<TeamQuestionnaireStateType>;
  /** Retrieve all team roles for the running exercise */
  teamRoles: Array<Scalars['String']['output']>;
  /** Retrieve all tools available to the specific team */
  teamTools: Array<ToolType>;
  /** Retrieve all files uploaded by/to the specified team */
  teamUploadedFiles: Array<FileInfoType>;
  /** Retrieve the specific email template */
  threadTemplate: EmailTemplateType;
  /** Retrieve all email templates for the specific thread */
  threadTemplates: Array<EmailTemplateType>;
  user: UserType;
  /** Retrieve all users with filtering options */
  users: Array<UserType>;
  /** Validates if the email address is valid for the specified exercise */
  validateEmailAddress: Scalars['Boolean']['output'];
  /** Retrieve data of the currently logged-in user of the request */
  whoAmI: Maybe<UserType>;
};


export type QueryActionLogArgs = {
  logId: Scalars['ID']['input'];
};


export type QueryAnalyticsActionLogsArgs = {
  exerciseId: Scalars['ID']['input'];
  newestFirst?: InputMaybe<Scalars['Boolean']['input']>;
};


export type QueryAnalyticsEmailThreadsArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryAnalyticsMilestonesArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryChannelArgs = {
  channelId: Scalars['ID']['input'];
};


export type QueryDefinitionArgs = {
  definitionId: Scalars['ID']['input'];
};


export type QueryEmailAddressesArgs = {
  threadId: Scalars['ID']['input'];
};


export type QueryEmailContactArgs = {
  participantId: Scalars['ID']['input'];
};


export type QueryEmailContactsArgs = {
  visibleOnly: InputMaybe<Scalars['Boolean']['input']>;
};


export type QueryEmailTemplatesArgs = {
  emailAddresses: Array<InputMaybe<Scalars['String']['input']>>;
  exerciseId: Scalars['ID']['input'];
};


export type QueryEmailThreadArgs = {
  threadId: Scalars['ID']['input'];
};


export type QueryEmailThreadsArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryExerciseChannelsArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryExerciseConfigArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryExerciseIdArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryExerciseLoopRunningArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryExerciseQuestionnairesArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryExerciseToolsArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryExercisesArgs = {
  finished: InputMaybe<Scalars['Boolean']['input']>;
  limit: InputMaybe<Scalars['Int']['input']>;
  running: InputMaybe<Scalars['Boolean']['input']>;
  skip: InputMaybe<Scalars['Int']['input']>;
};


export type QueryExtendedTeamToolsArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryFileInfoArgs = {
  fileInfoId: Scalars['UUID']['input'];
};


export type QueryGetEmailDraftArgs = {
  emailThreadId: InputMaybe<Scalars['ID']['input']>;
  instructor: Scalars['Boolean']['input'];
  teamId: Scalars['ID']['input'];
};


export type QueryGetEmailDraftsArgs = {
  instructor: Scalars['Boolean']['input'];
  teamId: Scalars['ID']['input'];
};


export type QueryInjectsArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryLearningObjectivesArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryMilestonesArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryQuestionnaireStateArgs = {
  questionnaireId: Scalars['ID']['input'];
  teamId: Scalars['ID']['input'];
};


export type QueryQuestionnairesArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type QueryTeamArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryTeamActionLogsArgs = {
  exerciseId: InputMaybe<Scalars['ID']['input']>;
  teamId: Scalars['ID']['input'];
};


export type QueryTeamChannelLogsArgs = {
  channelId: Scalars['ID']['input'];
  exerciseId: InputMaybe<Scalars['ID']['input']>;
  teamId: Scalars['ID']['input'];
};


export type QueryTeamEmailParticipantArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryTeamLearningObjectivesArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryTeamMilestoneArgs = {
  milestoneStateId: Scalars['ID']['input'];
};


export type QueryTeamMilestonesArgs = {
  exerciseId: InputMaybe<Scalars['ID']['input']>;
  teamId: Scalars['ID']['input'];
  visibleOnly: InputMaybe<Scalars['Boolean']['input']>;
};


export type QueryTeamQuestionnairesArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryTeamToolsArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryTeamUploadedFilesArgs = {
  teamId: Scalars['ID']['input'];
};


export type QueryThreadTemplateArgs = {
  templateId: Scalars['ID']['input'];
};


export type QueryThreadTemplatesArgs = {
  threadId: Scalars['ID']['input'];
};


export type QueryUserArgs = {
  userId: Scalars['UUID']['input'];
};


export type QueryUsersArgs = {
  filterUsersInput: InputMaybe<FilterUsersInput>;
};


export type QueryValidateEmailAddressArgs = {
  address: Scalars['String']['input'];
  exerciseId: Scalars['ID']['input'];
};

export type QuestionDetails = FreeFormQuestionDetailsType | RadioQuestionDetailsType;

export type QuestionRelatedMilestonesType = {
  __typename: 'QuestionRelatedMilestonesType';
  milestones: Array<MilestoneStateType>;
  questionId: Scalars['ID']['output'];
};

export type QuestionType = {
  __typename: 'QuestionType';
  content: ContentType;
  details: QuestionDetails;
  id: Scalars['ID']['output'];
  questionnaire: QuestionnaireType;
  type: QuestionTypes;
};

/** An enumeration. */
export type QuestionTypes =
  | 'FREE_FORM'
  | 'RADIO'
  | '%future added value';

export type QuestionnaireAnswerType = {
  __typename: 'QuestionnaireAnswerType';
  answer: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  isCorrect: Maybe<Scalars['Boolean']['output']>;
  question: QuestionType;
  teamQuestionnaireState: TeamQuestionnaireStateType;
};

export type QuestionnaireInput = {
  answers: Array<AnswerInput>;
  questionnaireId: Scalars['ID']['input'];
  teamId: Scalars['ID']['input'];
};

export type QuestionnaireInputType = {
  __typename: 'QuestionnaireInputType';
  answers: Array<AnswerType>;
  questionnaireId: Scalars['ID']['output'];
  teamId: Scalars['ID']['output'];
};

export type QuestionnaireReviewInput = {
  activateMilestones: Array<Scalars['String']['input']>;
  deactivateMilestones: Array<Scalars['String']['input']>;
  questionnaireId: Scalars['ID']['input'];
  teamId: Scalars['ID']['input'];
};

export type QuestionnaireReviewInputType = {
  __typename: 'QuestionnaireReviewInputType';
  activateMilestones: Array<Scalars['String']['output']>;
  deactivateMilestones: Array<Scalars['String']['output']>;
  questionnaireId: Scalars['ID']['output'];
  teamId: Scalars['ID']['output'];
};

export type QuestionnaireType = {
  __typename: 'QuestionnaireType';
  content: ContentType;
  control: ControlType;
  definition: DefinitionType;
  id: Scalars['ID']['output'];
  overlay: Maybe<OverlayType>;
  questions: Array<QuestionType>;
  teamQuestionnaireStates: Array<TeamQuestionnaireStateType>;
  time: Scalars['Int']['output'];
  title: Scalars['String']['output'];
};

export type RadioQuestionDetailsType = {
  __typename: 'RadioQuestionDetailsType';
  controls: Array<ControlsMapType>;
  correct: Scalars['Int']['output'];
  definition: ExerciseDefinitionType;
  id: Scalars['ID']['output'];
  labels: Scalars['String']['output'];
  max: Scalars['Int']['output'];
};

export type ReadReceiptType = {
  __typename: 'ReadReceiptType';
  actionLogId: Scalars['ID']['output'];
  readReceipt: Maybe<Scalars['DateTime']['output']>;
};

export type RegenerateCredentialsMutation = {
  __typename: 'RegenerateCredentialsMutation';
  operationDone: Scalars['Boolean']['output'];
};

export type RemoveDefinitionAccessMutation = {
  __typename: 'RemoveDefinitionAccessMutation';
  operationDone: Scalars['Boolean']['output'];
};

export type RemoveInstructorsFromExerciseMutation = {
  __typename: 'RemoveInstructorsFromExerciseMutation';
  operationDone: Scalars['Boolean']['output'];
};

export type RemoveUsersFromTeamMutation = {
  __typename: 'RemoveUsersFromTeamMutation';
  operationDone: Scalars['Boolean']['output'];
};

export type RestrictedExercise = {
  __typename: 'RestrictedExercise';
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  uuid: Scalars['UUID']['output'];
};

export type RestrictedTeam = {
  __typename: 'RestrictedTeam';
  emailAddress: Maybe<EmailParticipantType>;
  exercise: ExerciseType;
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  role: Scalars['String']['output'];
};

export type RestrictedUser = {
  __typename: 'RestrictedUser';
  dateJoined: Scalars['DateTime']['output'];
  firstName: Maybe<Scalars['String']['output']>;
  group: Maybe<AuthGroup>;
  id: Scalars['UUID']['output'];
  isActive: Scalars['Boolean']['output'];
  isImported: Scalars['Boolean']['output'];
  lastLogin: Maybe<Scalars['DateTime']['output']>;
  lastName: Maybe<Scalars['String']['output']>;
  tags: Array<TagType>;
  username: Scalars['String']['output'];
};

export type ReviewQuestionnaireMutation = {
  __typename: 'ReviewQuestionnaireMutation';
  updatedState: TeamQuestionnaireStateType;
};

export type SendCustomInjectMutation = {
  __typename: 'SendCustomInjectMutation';
  operationDone: Scalars['Boolean']['output'];
};

export type SendEmailInput = {
  activateMilestone: InputMaybe<Scalars['String']['input']>;
  content: InputMaybe<Scalars['String']['input']>;
  deactivateMilestone: InputMaybe<Scalars['String']['input']>;
  fileId: InputMaybe<Scalars['UUID']['input']>;
  senderAddress: Scalars['String']['input'];
  threadId: Scalars['ID']['input'];
};

export type SendEmailMutation = {
  __typename: 'SendEmailMutation';
  email: EmailType;
  operationDone: Scalars['Boolean']['output'];
};

export type SendEmailType = {
  __typename: 'SendEmailType';
  activateMilestone: Maybe<Scalars['String']['output']>;
  content: Maybe<Scalars['String']['output']>;
  deactivateMilestone: Maybe<Scalars['String']['output']>;
  fileId: Maybe<Scalars['UUID']['output']>;
  senderAddress: Scalars['String']['output'];
  threadId: Scalars['ID']['output'];
};

export type StartExerciseMutation = {
  __typename: 'StartExerciseMutation';
  exercise: ExerciseType;
};

/** An enumeration. */
export type Status =
  | 'ANSWERED'
  | 'REVIEWED'
  | 'SENT'
  | 'UNSENT'
  | '%future added value';

export type StopExerciseMutation = {
  __typename: 'StopExerciseMutation';
  exercise: ExerciseType;
};

export type Subscription = {
  __typename: 'Subscription';
  /** Subscription notifies about new action logs for the specific team */
  actionLogs: Maybe<ActionLogsSubscription>;
  /** Subscription notifies about new action logs for the specific exercise */
  analyticsActionLogsSubscription: Maybe<AnalyticsActionLogsSubscription>;
  /** Subscription notifies about new email threads and new emails for the specific exercise */
  analyticsEmailThreadSubscription: Maybe<AnalyticsEmailThreadSubscription>;
  /** Subscription notifies about changes in milestone states */
  analyticsMilestonesSubscription: Maybe<AnalyticsMilestonesSubscription>;
  /** Subscription notifies about new threads and new emails for the specific team */
  emailThreads: Maybe<EmailThreadSubscription>;
  /** Subscription notifies about the state of the exercise loop */
  exerciseLoopRunning: Maybe<ExerciseLoopRunningSubscription>;
  /** Subscription that notifies when exercises were modified */
  exercisesSubscription: Maybe<ExercisesSubscription>;
  /** Subscription notifies about changes in milestone states */
  milestones: Maybe<MilestonesSubscription>;
  /** Subscription notifies about changes to the state of a teams questionnaires */
  teamQuestionnaireStateSubscription: Maybe<TeamQuestionnaireStateSubscription>;
};


export type SubscriptionActionLogsArgs = {
  teamId: Scalars['ID']['input'];
};


export type SubscriptionAnalyticsActionLogsSubscriptionArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type SubscriptionAnalyticsEmailThreadSubscriptionArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type SubscriptionAnalyticsMilestonesSubscriptionArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type SubscriptionEmailThreadsArgs = {
  teamId: Scalars['ID']['input'];
};


export type SubscriptionExerciseLoopRunningArgs = {
  exerciseId: Scalars['ID']['input'];
};


export type SubscriptionMilestonesArgs = {
  teamId: Scalars['ID']['input'];
  visibleOnly: InputMaybe<Scalars['Boolean']['input']>;
};


export type SubscriptionTeamQuestionnaireStateSubscriptionArgs = {
  teamId: Scalars['ID']['input'];
};

export type TagType = {
  __typename: 'TagType';
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
};

export type TeamLearningActivityType = {
  __typename: 'TeamLearningActivityType';
  activity: LearningActivityType;
  id: Scalars['ID']['output'];
  milestoneStates: Array<MilestoneStateType>;
  reached: Maybe<Scalars['Boolean']['output']>;
  teamObjective: TeamLearningObjectiveType;
};

export type TeamLearningObjectiveType = {
  __typename: 'TeamLearningObjectiveType';
  activities: Array<TeamLearningActivityType>;
  id: Scalars['ID']['output'];
  objective: LearningObjectiveType;
  reached: Maybe<Scalars['Boolean']['output']>;
};

export type TeamQuestionnaireStateSubscription = {
  __typename: 'TeamQuestionnaireStateSubscription';
  teamQuestionnaireState: TeamQuestionnaireStateType;
};

export type TeamQuestionnaireStateType = {
  __typename: 'TeamQuestionnaireStateType';
  answers: Array<QuestionnaireAnswerType>;
  id: Scalars['ID']['output'];
  questionnaire: QuestionnaireType;
  relatedMilestones: Array<QuestionRelatedMilestonesType>;
  reviewedBy: Maybe<RestrictedUser>;
  status: Status;
  team: TeamType;
  timestampAnswered: Maybe<Scalars['DateTime']['output']>;
  timestampReviewed: Maybe<Scalars['DateTime']['output']>;
  timestampSent: Maybe<Scalars['DateTime']['output']>;
  todo: Scalars['Boolean']['output'];
};

export type TeamType = {
  __typename: 'TeamType';
  emailAddress: Maybe<EmailParticipantType>;
  exercise: ExerciseType;
  finishTime: Maybe<Scalars['DateTime']['output']>;
  id: Scalars['ID']['output'];
  logs: Array<ActionLogType>;
  name: Scalars['String']['output'];
  role: Scalars['String']['output'];
  teamQuestionnaireStates: Array<TeamQuestionnaireStateType>;
  users: Array<RestrictedUser>;
};

export type ToolDetailsType = {
  __typename: 'ToolDetailsType';
  argument: Scalars['String']['output'];
  content: ContentType;
  id: Scalars['ID']['output'];
  tool: ToolType;
  user: Maybe<RestrictedUser>;
};

export type ToolResponseType = {
  __typename: 'ToolResponseType';
  content: ContentType;
  control: ControlType;
  id: Scalars['ID']['output'];
  param: Scalars['String']['output'];
  regex: Scalars['Boolean']['output'];
  time: Scalars['Int']['output'];
  tool: ExtendedToolType;
};

export type ToolType = {
  __typename: 'ToolType';
  category: Scalars['String']['output'];
  defaultResponse: Scalars['String']['output'];
  definition: ExerciseDefinitionType;
  hint: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  roles: Scalars['String']['output'];
  tooltipDescription: Scalars['String']['output'];
};

export type UpdateTagAssignmentsInput = {
  addTags: Array<Scalars['ID']['input']>;
  removeTags: Array<Scalars['ID']['input']>;
  userIds: Array<Scalars['ID']['input']>;
};

export type UpdateTagAssignmentsMutation = {
  __typename: 'UpdateTagAssignmentsMutation';
  operationDone: Scalars['Boolean']['output'];
};

export type UpdateTagAssignmentsType = {
  __typename: 'UpdateTagAssignmentsType';
  addTags: Array<Scalars['ID']['output']>;
  removeTags: Array<Scalars['ID']['output']>;
  userIds: Array<Scalars['ID']['output']>;
};

export type UpdateTagMutation = {
  __typename: 'UpdateTagMutation';
  updatedTag: TagType;
};

export type UseToolInput = {
  teamId: Scalars['ID']['input'];
  /** Parameter provided by the trainee. */
  toolArgument: Scalars['String']['input'];
  toolId: Scalars['ID']['input'];
};

export type UseToolMutation = {
  __typename: 'UseToolMutation';
  actionLog: ActionLogType;
  operationDone: Scalars['Boolean']['output'];
};

export type UseToolType = {
  __typename: 'UseToolType';
  teamId: Scalars['ID']['output'];
  /** Parameter provided by the trainee. */
  toolArgument: Scalars['String']['output'];
  toolId: Scalars['ID']['output'];
};

export type UserType = {
  __typename: 'UserType';
  createdExercises: Array<RestrictedExercise>;
  dateJoined: Scalars['DateTime']['output'];
  definitions: Array<ExerciseDefinitionType>;
  exercises: Array<RestrictedExercise>;
  firstName: Maybe<Scalars['String']['output']>;
  group: AuthGroup;
  id: Scalars['UUID']['output'];
  isActive: Scalars['Boolean']['output'];
  isImported: Scalars['Boolean']['output'];
  lastLogin: Maybe<Scalars['DateTime']['output']>;
  lastName: Maybe<Scalars['String']['output']>;
  tags: Array<TagType>;
  teams: Array<RestrictedTeam>;
  uploadedDefinitions: Array<ExerciseDefinitionType>;
  username: Scalars['String']['output'];
};

export type WithTypename<T extends { __typename?: any }> = Partial<T> & { __typename: NonNullable<T['__typename']> };

export type GraphCacheKeysConfig = {
  ActionLogType?: (data: WithTypename<ActionLogType>) => null | string,
  ActionLogsSubscription?: (data: WithTypename<ActionLogsSubscription>) => null | string,
  AddDefinitionAccessMutation?: (data: WithTypename<AddDefinitionAccessMutation>) => null | string,
  AnalyticsActionLogsSubscription?: (data: WithTypename<AnalyticsActionLogsSubscription>) => null | string,
  AnalyticsEmailThreadSubscription?: (data: WithTypename<AnalyticsEmailThreadSubscription>) => null | string,
  AnalyticsMilestonesSubscription?: (data: WithTypename<AnalyticsMilestonesSubscription>) => null | string,
  AnswerQuestionnaireMutation?: (data: WithTypename<AnswerQuestionnaireMutation>) => null | string,
  AnswerType?: (data: WithTypename<AnswerType>) => null | string,
  AssignInstructorsToExercise?: (data: WithTypename<AssignInstructorsToExercise>) => null | string,
  AssignUsersByTags?: (data: WithTypename<AssignUsersByTags>) => null | string,
  AssignUsersEqually?: (data: WithTypename<AssignUsersEqually>) => null | string,
  AssignUsersToTeamMutation?: (data: WithTypename<AssignUsersToTeamMutation>) => null | string,
  ChangeUserDataMutation?: (data: WithTypename<ChangeUserDataMutation>) => null | string,
  ChangeUserType?: (data: WithTypename<ChangeUserType>) => null | string,
  ChannelReceipt?: (data: WithTypename<ChannelReceipt>) => null | string,
  ConfigOverrideType?: (data: WithTypename<ConfigOverrideType>) => null | string,
  ConfirmActionMutation?: (data: WithTypename<ConfirmActionMutation>) => null | string,
  ConfirmationType?: (data: WithTypename<ConfirmationType>) => null | string,
  ContentType?: (data: WithTypename<ContentType>) => null | string,
  ControlType?: (data: WithTypename<ControlType>) => null | string,
  ControlsMapType?: (data: WithTypename<ControlsMapType>) => null | string,
  CopyUsersAssignment?: (data: WithTypename<CopyUsersAssignment>) => null | string,
  CreateExerciseMutation?: (data: WithTypename<CreateExerciseMutation>) => null | string,
  CreateExerciseType?: (data: WithTypename<CreateExerciseType>) => null | string,
  CreateTagMutation?: (data: WithTypename<CreateTagMutation>) => null | string,
  CreateThreadMutation?: (data: WithTypename<CreateThreadMutation>) => null | string,
  CreateUserMutation?: (data: WithTypename<CreateUserMutation>) => null | string,
  CreateUserType?: (data: WithTypename<CreateUserType>) => null | string,
  CustomInjectDetailsType?: (data: WithTypename<CustomInjectDetailsType>) => null | string,
  CustomInjectType?: (data: WithTypename<CustomInjectType>) => null | string,
  DefinitionChannelType?: (data: WithTypename<DefinitionChannelType>) => null | string,
  DefinitionInjectType?: (data: WithTypename<DefinitionInjectType>) => null | string,
  DefinitionRoleType?: (data: WithTypename<DefinitionRoleType>) => null | string,
  DefinitionType?: (data: WithTypename<DefinitionType>) => null | string,
  DeleteDefinitionMutation?: (data: WithTypename<DeleteDefinitionMutation>) => null | string,
  DeleteExerciseMutation?: (data: WithTypename<DeleteExerciseMutation>) => null | string,
  DeleteTagsMutation?: (data: WithTypename<DeleteTagsMutation>) => null | string,
  DeleteUsersMutation?: (data: WithTypename<DeleteUsersMutation>) => null | string,
  EmailAddressType?: (data: WithTypename<EmailAddressType>) => null | string,
  EmailDraftType?: (data: WithTypename<EmailDraftType>) => null | string,
  EmailParticipantType?: (data: WithTypename<EmailParticipantType>) => null | string,
  EmailReceipt?: (data: WithTypename<EmailReceipt>) => null | string,
  EmailTemplateType?: (data: WithTypename<EmailTemplateType>) => null | string,
  EmailThreadReceipt?: (data: WithTypename<EmailThreadReceipt>) => null | string,
  EmailThreadSubscription?: (data: WithTypename<EmailThreadSubscription>) => null | string,
  EmailThreadType?: (data: WithTypename<EmailThreadType>) => null | string,
  EmailType?: (data: WithTypename<EmailType>) => null | string,
  ExerciseDefinitionType?: (data: WithTypename<ExerciseDefinitionType>) => null | string,
  ExerciseLoopRunningSubscription?: (data: WithTypename<ExerciseLoopRunningSubscription>) => null | string,
  ExerciseType?: (data: WithTypename<ExerciseType>) => null | string,
  ExercisesSubscription?: (data: WithTypename<ExercisesSubscription>) => null | string,
  ExtendedToolType?: (data: WithTypename<ExtendedToolType>) => null | string,
  FileInfoType?: (data: WithTypename<FileInfoType>) => null | string,
  FilterUsersType?: (data: WithTypename<FilterUsersType>) => null | string,
  FreeFormQuestionDetailsType?: (data: WithTypename<FreeFormQuestionDetailsType>) => null | string,
  GrapheneConfig?: (data: WithTypename<GrapheneConfig>) => null | string,
  InjectDetailsType?: (data: WithTypename<InjectDetailsType>) => null | string,
  LearningActivityType?: (data: WithTypename<LearningActivityType>) => null | string,
  LearningObjectiveType?: (data: WithTypename<LearningObjectiveType>) => null | string,
  MilestoneStateHistoryType?: (data: WithTypename<MilestoneStateHistoryType>) => null | string,
  MilestoneStateType?: (data: WithTypename<MilestoneStateType>) => null | string,
  MilestoneType?: (data: WithTypename<MilestoneType>) => null | string,
  MilestonesSubscription?: (data: WithTypename<MilestonesSubscription>) => null | string,
  ModifyMilestoneMutation?: (data: WithTypename<ModifyMilestoneMutation>) => null | string,
  MoveExerciseTimeMutation?: (data: WithTypename<MoveExerciseTimeMutation>) => null | string,
  MutationResult?: (data: WithTypename<MutationResult>) => null | string,
  OverlayType?: (data: WithTypename<OverlayType>) => null | string,
  PasswordChange?: (data: WithTypename<PasswordChange>) => null | string,
  QuestionRelatedMilestonesType?: (data: WithTypename<QuestionRelatedMilestonesType>) => null | string,
  QuestionType?: (data: WithTypename<QuestionType>) => null | string,
  QuestionnaireAnswerType?: (data: WithTypename<QuestionnaireAnswerType>) => null | string,
  QuestionnaireInputType?: (data: WithTypename<QuestionnaireInputType>) => null | string,
  QuestionnaireReviewInputType?: (data: WithTypename<QuestionnaireReviewInputType>) => null | string,
  QuestionnaireType?: (data: WithTypename<QuestionnaireType>) => null | string,
  RadioQuestionDetailsType?: (data: WithTypename<RadioQuestionDetailsType>) => null | string,
  ReadReceiptType?: (data: WithTypename<ReadReceiptType>) => null | string,
  RegenerateCredentialsMutation?: (data: WithTypename<RegenerateCredentialsMutation>) => null | string,
  RemoveDefinitionAccessMutation?: (data: WithTypename<RemoveDefinitionAccessMutation>) => null | string,
  RemoveInstructorsFromExerciseMutation?: (data: WithTypename<RemoveInstructorsFromExerciseMutation>) => null | string,
  RemoveUsersFromTeamMutation?: (data: WithTypename<RemoveUsersFromTeamMutation>) => null | string,
  RestrictedExercise?: (data: WithTypename<RestrictedExercise>) => null | string,
  RestrictedTeam?: (data: WithTypename<RestrictedTeam>) => null | string,
  RestrictedUser?: (data: WithTypename<RestrictedUser>) => null | string,
  ReviewQuestionnaireMutation?: (data: WithTypename<ReviewQuestionnaireMutation>) => null | string,
  SendCustomInjectMutation?: (data: WithTypename<SendCustomInjectMutation>) => null | string,
  SendEmailMutation?: (data: WithTypename<SendEmailMutation>) => null | string,
  SendEmailType?: (data: WithTypename<SendEmailType>) => null | string,
  StartExerciseMutation?: (data: WithTypename<StartExerciseMutation>) => null | string,
  StopExerciseMutation?: (data: WithTypename<StopExerciseMutation>) => null | string,
  TagType?: (data: WithTypename<TagType>) => null | string,
  TeamLearningActivityType?: (data: WithTypename<TeamLearningActivityType>) => null | string,
  TeamLearningObjectiveType?: (data: WithTypename<TeamLearningObjectiveType>) => null | string,
  TeamQuestionnaireStateSubscription?: (data: WithTypename<TeamQuestionnaireStateSubscription>) => null | string,
  TeamQuestionnaireStateType?: (data: WithTypename<TeamQuestionnaireStateType>) => null | string,
  TeamType?: (data: WithTypename<TeamType>) => null | string,
  ToolDetailsType?: (data: WithTypename<ToolDetailsType>) => null | string,
  ToolResponseType?: (data: WithTypename<ToolResponseType>) => null | string,
  ToolType?: (data: WithTypename<ToolType>) => null | string,
  UpdateTagAssignmentsMutation?: (data: WithTypename<UpdateTagAssignmentsMutation>) => null | string,
  UpdateTagAssignmentsType?: (data: WithTypename<UpdateTagAssignmentsType>) => null | string,
  UpdateTagMutation?: (data: WithTypename<UpdateTagMutation>) => null | string,
  UseToolMutation?: (data: WithTypename<UseToolMutation>) => null | string,
  UseToolType?: (data: WithTypename<UseToolType>) => null | string,
  UserType?: (data: WithTypename<UserType>) => null | string
}

export type GraphCacheResolvers = {
  Query?: {
    actionLog?: GraphCacheResolver<WithTypename<Query>, QueryActionLogArgs, WithTypename<ActionLogType> | string>,
    analyticsActionLogs?: GraphCacheResolver<WithTypename<Query>, QueryAnalyticsActionLogsArgs, Array<WithTypename<ActionLogType> | string>>,
    analyticsEmailThreads?: GraphCacheResolver<WithTypename<Query>, QueryAnalyticsEmailThreadsArgs, Array<WithTypename<EmailThreadType> | string>>,
    analyticsMilestones?: GraphCacheResolver<WithTypename<Query>, QueryAnalyticsMilestonesArgs, Array<WithTypename<MilestoneStateType> | string>>,
    channel?: GraphCacheResolver<WithTypename<Query>, QueryChannelArgs, WithTypename<DefinitionChannelType> | string>,
    definition?: GraphCacheResolver<WithTypename<Query>, QueryDefinitionArgs, WithTypename<DefinitionType> | string>,
    definitions?: GraphCacheResolver<WithTypename<Query>, Record<string, never>, Array<WithTypename<DefinitionType> | string>>,
    emailAddresses?: GraphCacheResolver<WithTypename<Query>, QueryEmailAddressesArgs, Array<Scalars['String'] | string>>,
    emailContact?: GraphCacheResolver<WithTypename<Query>, QueryEmailContactArgs, WithTypename<EmailParticipantType> | string>,
    emailContacts?: GraphCacheResolver<WithTypename<Query>, QueryEmailContactsArgs, Array<WithTypename<EmailParticipantType> | string>>,
    emailTemplates?: GraphCacheResolver<WithTypename<Query>, QueryEmailTemplatesArgs, Array<WithTypename<EmailTemplateType> | string>>,
    emailThread?: GraphCacheResolver<WithTypename<Query>, QueryEmailThreadArgs, WithTypename<EmailThreadType> | string>,
    emailThreads?: GraphCacheResolver<WithTypename<Query>, QueryEmailThreadsArgs, Array<WithTypename<EmailThreadType> | string>>,
    exerciseChannels?: GraphCacheResolver<WithTypename<Query>, QueryExerciseChannelsArgs, Array<WithTypename<DefinitionChannelType> | string>>,
    exerciseConfig?: GraphCacheResolver<WithTypename<Query>, QueryExerciseConfigArgs, WithTypename<GrapheneConfig> | string>,
    exerciseId?: GraphCacheResolver<WithTypename<Query>, QueryExerciseIdArgs, WithTypename<ExerciseType> | string>,
    exerciseLoopRunning?: GraphCacheResolver<WithTypename<Query>, QueryExerciseLoopRunningArgs, Scalars['Boolean'] | string>,
    exerciseQuestionnaires?: GraphCacheResolver<WithTypename<Query>, QueryExerciseQuestionnairesArgs, Array<WithTypename<TeamQuestionnaireStateType> | string>>,
    exerciseTimeLeft?: GraphCacheResolver<WithTypename<Query>, Record<string, never>, Scalars['Int'] | string>,
    exerciseTools?: GraphCacheResolver<WithTypename<Query>, QueryExerciseToolsArgs, Array<WithTypename<ToolType> | string>>,
    exercises?: GraphCacheResolver<WithTypename<Query>, QueryExercisesArgs, Array<WithTypename<ExerciseType> | string>>,
    extendedTeamTools?: GraphCacheResolver<WithTypename<Query>, QueryExtendedTeamToolsArgs, Array<WithTypename<ExtendedToolType> | string>>,
    fileInfo?: GraphCacheResolver<WithTypename<Query>, QueryFileInfoArgs, WithTypename<FileInfoType> | string>,
    getEmailDraft?: GraphCacheResolver<WithTypename<Query>, QueryGetEmailDraftArgs, WithTypename<EmailDraftType> | string>,
    getEmailDrafts?: GraphCacheResolver<WithTypename<Query>, QueryGetEmailDraftsArgs, Array<WithTypename<EmailDraftType> | string>>,
    injects?: GraphCacheResolver<WithTypename<Query>, QueryInjectsArgs, Array<WithTypename<DefinitionInjectType> | string>>,
    learningObjectives?: GraphCacheResolver<WithTypename<Query>, QueryLearningObjectivesArgs, Array<WithTypename<LearningObjectiveType> | string>>,
    milestones?: GraphCacheResolver<WithTypename<Query>, QueryMilestonesArgs, Array<WithTypename<MilestoneType> | string>>,
    noopReceipt?: GraphCacheResolver<WithTypename<Query>, Record<string, never>, WithTypename<MutationResult> | string>,
    noopReload?: GraphCacheResolver<WithTypename<Query>, Record<string, never>, WithTypename<MutationResult> | string>,
    noopTodo?: GraphCacheResolver<WithTypename<Query>, Record<string, never>, WithTypename<MutationResult> | string>,
    questionnaireState?: GraphCacheResolver<WithTypename<Query>, QueryQuestionnaireStateArgs, WithTypename<TeamQuestionnaireStateType> | string>,
    questionnaires?: GraphCacheResolver<WithTypename<Query>, QueryQuestionnairesArgs, Array<WithTypename<QuestionnaireType> | string>>,
    tags?: GraphCacheResolver<WithTypename<Query>, Record<string, never>, Array<WithTypename<TagType> | string>>,
    team?: GraphCacheResolver<WithTypename<Query>, QueryTeamArgs, WithTypename<TeamType> | string>,
    teamActionLogs?: GraphCacheResolver<WithTypename<Query>, QueryTeamActionLogsArgs, Array<WithTypename<ActionLogType> | string>>,
    teamChannelLogs?: GraphCacheResolver<WithTypename<Query>, QueryTeamChannelLogsArgs, Array<WithTypename<ActionLogType> | string>>,
    teamEmailParticipant?: GraphCacheResolver<WithTypename<Query>, QueryTeamEmailParticipantArgs, WithTypename<EmailParticipantType> | string>,
    teamLearningObjectives?: GraphCacheResolver<WithTypename<Query>, QueryTeamLearningObjectivesArgs, Array<WithTypename<TeamLearningObjectiveType> | string>>,
    teamMilestone?: GraphCacheResolver<WithTypename<Query>, QueryTeamMilestoneArgs, WithTypename<MilestoneStateType> | string>,
    teamMilestones?: GraphCacheResolver<WithTypename<Query>, QueryTeamMilestonesArgs, Array<WithTypename<MilestoneStateType> | string>>,
    teamQuestionnaires?: GraphCacheResolver<WithTypename<Query>, QueryTeamQuestionnairesArgs, Array<WithTypename<TeamQuestionnaireStateType> | string>>,
    teamRoles?: GraphCacheResolver<WithTypename<Query>, Record<string, never>, Array<Scalars['String'] | string>>,
    teamTools?: GraphCacheResolver<WithTypename<Query>, QueryTeamToolsArgs, Array<WithTypename<ToolType> | string>>,
    teamUploadedFiles?: GraphCacheResolver<WithTypename<Query>, QueryTeamUploadedFilesArgs, Array<WithTypename<FileInfoType> | string>>,
    threadTemplate?: GraphCacheResolver<WithTypename<Query>, QueryThreadTemplateArgs, WithTypename<EmailTemplateType> | string>,
    threadTemplates?: GraphCacheResolver<WithTypename<Query>, QueryThreadTemplatesArgs, Array<WithTypename<EmailTemplateType> | string>>,
    user?: GraphCacheResolver<WithTypename<Query>, QueryUserArgs, WithTypename<UserType> | string>,
    users?: GraphCacheResolver<WithTypename<Query>, QueryUsersArgs, Array<WithTypename<UserType> | string>>,
    validateEmailAddress?: GraphCacheResolver<WithTypename<Query>, QueryValidateEmailAddressArgs, Scalars['Boolean'] | string>,
    whoAmI?: GraphCacheResolver<WithTypename<Query>, Record<string, never>, WithTypename<UserType> | string>
  },
  ActionLogType?: {
    channel?: GraphCacheResolver<WithTypename<ActionLogType>, Record<string, never>, WithTypename<DefinitionChannelType> | string>,
    details?: GraphCacheResolver<WithTypename<ActionLogType>, Record<string, never>, WithTypename<ActionLogDetails> | string>,
    id?: GraphCacheResolver<WithTypename<ActionLogType>, Record<string, never>, Scalars['ID'] | string>,
    readReceipt?: GraphCacheResolver<WithTypename<ActionLogType>, Record<string, never>, Scalars['DateTime'] | string>,
    requiresAttention?: GraphCacheResolver<WithTypename<ActionLogType>, Record<string, never>, Scalars['Boolean'] | string>,
    team?: GraphCacheResolver<WithTypename<ActionLogType>, Record<string, never>, WithTypename<TeamType> | string>,
    teamId?: GraphCacheResolver<WithTypename<ActionLogType>, Record<string, never>, Scalars['ID'] | string>,
    timestamp?: GraphCacheResolver<WithTypename<ActionLogType>, Record<string, never>, Scalars['DateTime'] | string>,
    todo?: GraphCacheResolver<WithTypename<ActionLogType>, Record<string, never>, Scalars['Boolean'] | string>,
    type?: GraphCacheResolver<WithTypename<ActionLogType>, Record<string, never>, LogType | string>
  },
  ActionLogsSubscription?: {
    actionLog?: GraphCacheResolver<WithTypename<ActionLogsSubscription>, Record<string, never>, WithTypename<ActionLogType> | string>,
    eventType?: GraphCacheResolver<WithTypename<ActionLogsSubscription>, Record<string, never>, EventType | string>
  },
  AddDefinitionAccessMutation?: {
    operationDone?: GraphCacheResolver<WithTypename<AddDefinitionAccessMutation>, Record<string, never>, Scalars['Boolean'] | string>
  },
  AnalyticsActionLogsSubscription?: {
    actionLog?: GraphCacheResolver<WithTypename<AnalyticsActionLogsSubscription>, Record<string, never>, WithTypename<ActionLogType> | string>,
    eventType?: GraphCacheResolver<WithTypename<AnalyticsActionLogsSubscription>, Record<string, never>, EventType | string>
  },
  AnalyticsEmailThreadSubscription?: {
    emailThread?: GraphCacheResolver<WithTypename<AnalyticsEmailThreadSubscription>, Record<string, never>, WithTypename<EmailThreadType> | string>
  },
  AnalyticsMilestonesSubscription?: {
    milestones?: GraphCacheResolver<WithTypename<AnalyticsMilestonesSubscription>, Record<string, never>, Array<WithTypename<MilestoneStateType> | string>>
  },
  AnswerQuestionnaireMutation?: {
    operationDone?: GraphCacheResolver<WithTypename<AnswerQuestionnaireMutation>, Record<string, never>, Scalars['Boolean'] | string>
  },
  AnswerType?: {
    questionId?: GraphCacheResolver<WithTypename<AnswerType>, Record<string, never>, Scalars['ID'] | string>,
    value?: GraphCacheResolver<WithTypename<AnswerType>, Record<string, never>, Scalars['String'] | string>
  },
  AssignInstructorsToExercise?: {
    operationDone?: GraphCacheResolver<WithTypename<AssignInstructorsToExercise>, Record<string, never>, Scalars['Boolean'] | string>
  },
  AssignUsersByTags?: {
    operationDone?: GraphCacheResolver<WithTypename<AssignUsersByTags>, Record<string, never>, Scalars['Boolean'] | string>
  },
  AssignUsersEqually?: {
    operationDone?: GraphCacheResolver<WithTypename<AssignUsersEqually>, Record<string, never>, Scalars['Boolean'] | string>
  },
  AssignUsersToTeamMutation?: {
    operationDone?: GraphCacheResolver<WithTypename<AssignUsersToTeamMutation>, Record<string, never>, Scalars['Boolean'] | string>
  },
  ChangeUserDataMutation?: {
    user?: GraphCacheResolver<WithTypename<ChangeUserDataMutation>, Record<string, never>, WithTypename<UserType> | string>
  },
  ChangeUserType?: {
    active?: GraphCacheResolver<WithTypename<ChangeUserType>, Record<string, never>, Scalars['Boolean'] | string>,
    group?: GraphCacheResolver<WithTypename<ChangeUserType>, Record<string, never>, AuthGroup | string>,
    userId?: GraphCacheResolver<WithTypename<ChangeUserType>, Record<string, never>, Scalars['UUID'] | string>
  },
  ChannelReceipt?: {
    id?: GraphCacheResolver<WithTypename<ChannelReceipt>, Record<string, never>, Scalars['ID'] | string>,
    isUnread?: GraphCacheResolver<WithTypename<ChannelReceipt>, Record<string, never>, Scalars['Boolean'] | string>,
    teamId?: GraphCacheResolver<WithTypename<ChannelReceipt>, Record<string, never>, Scalars['ID'] | string>
  },
  ConfigOverrideType?: {
    customEmailSuffix?: GraphCacheResolver<WithTypename<ConfigOverrideType>, Record<string, never>, Scalars['String'] | string>,
    customTeamNames?: GraphCacheResolver<WithTypename<ConfigOverrideType>, Record<string, never>, Array<Scalars['String'] | string>>,
    emailBetweenTeams?: GraphCacheResolver<WithTypename<ConfigOverrideType>, Record<string, never>, Scalars['Boolean'] | string>,
    exerciseDuration?: GraphCacheResolver<WithTypename<ConfigOverrideType>, Record<string, never>, Scalars['Int'] | string>,
    showExerciseTime?: GraphCacheResolver<WithTypename<ConfigOverrideType>, Record<string, never>, Scalars['Boolean'] | string>
  },
  ConfirmActionMutation?: {
    actionLog?: GraphCacheResolver<WithTypename<ConfirmActionMutation>, Record<string, never>, WithTypename<ActionLogType> | string>
  },
  ConfirmationType?: {
    control?: GraphCacheResolver<WithTypename<ConfirmationType>, Record<string, never>, WithTypename<ControlType> | string>,
    id?: GraphCacheResolver<WithTypename<ConfirmationType>, Record<string, never>, Scalars['ID'] | string>,
    text?: GraphCacheResolver<WithTypename<ConfirmationType>, Record<string, never>, Scalars['String'] | string>
  },
  ContentType?: {
    fileInfo?: GraphCacheResolver<WithTypename<ContentType>, Record<string, never>, WithTypename<FileInfoType> | string>,
    id?: GraphCacheResolver<WithTypename<ContentType>, Record<string, never>, Scalars['ID'] | string>,
    raw?: GraphCacheResolver<WithTypename<ContentType>, Record<string, never>, Scalars['String'] | string>,
    rendered?: GraphCacheResolver<WithTypename<ContentType>, Record<string, never>, Scalars['String'] | string>
  },
  ControlType?: {
    activateMilestone?: GraphCacheResolver<WithTypename<ControlType>, Record<string, never>, Scalars['String'] | string>,
    deactivateMilestone?: GraphCacheResolver<WithTypename<ControlType>, Record<string, never>, Scalars['String'] | string>,
    id?: GraphCacheResolver<WithTypename<ControlType>, Record<string, never>, Scalars['ID'] | string>,
    milestoneCondition?: GraphCacheResolver<WithTypename<ControlType>, Record<string, never>, Scalars['String'] | string>,
    roles?: GraphCacheResolver<WithTypename<ControlType>, Record<string, never>, Scalars['String'] | string>
  },
  ControlsMapType?: {
    choice?: GraphCacheResolver<WithTypename<ControlsMapType>, Record<string, never>, Scalars['Int'] | string>,
    control?: GraphCacheResolver<WithTypename<ControlsMapType>, Record<string, never>, WithTypename<ControlType> | string>
  },
  CopyUsersAssignment?: {
    operationDone?: GraphCacheResolver<WithTypename<CopyUsersAssignment>, Record<string, never>, Scalars['Boolean'] | string>
  },
  CreateExerciseMutation?: {
    exercise?: GraphCacheResolver<WithTypename<CreateExerciseMutation>, Record<string, never>, WithTypename<ExerciseType> | string>
  },
  CreateExerciseType?: {
    configOverride?: GraphCacheResolver<WithTypename<CreateExerciseType>, Record<string, never>, WithTypename<ConfigOverrideType> | string>,
    definitionId?: GraphCacheResolver<WithTypename<CreateExerciseType>, Record<string, never>, Scalars['ID'] | string>,
    name?: GraphCacheResolver<WithTypename<CreateExerciseType>, Record<string, never>, Scalars['String'] | string>,
    teamCount?: GraphCacheResolver<WithTypename<CreateExerciseType>, Record<string, never>, Scalars['Int'] | string>
  },
  CreateTagMutation?: {
    newTag?: GraphCacheResolver<WithTypename<CreateTagMutation>, Record<string, never>, WithTypename<TagType> | string>
  },
  CreateThreadMutation?: {
    thread?: GraphCacheResolver<WithTypename<CreateThreadMutation>, Record<string, never>, WithTypename<EmailThreadType> | string>
  },
  CreateUserMutation?: {
    newUser?: GraphCacheResolver<WithTypename<CreateUserMutation>, Record<string, never>, WithTypename<RestrictedUser> | string>
  },
  CreateUserType?: {
    email?: GraphCacheResolver<WithTypename<CreateUserType>, Record<string, never>, Scalars['String'] | string>,
    firstName?: GraphCacheResolver<WithTypename<CreateUserType>, Record<string, never>, Scalars['String'] | string>,
    group?: GraphCacheResolver<WithTypename<CreateUserType>, Record<string, never>, AuthGroup | string>,
    lastName?: GraphCacheResolver<WithTypename<CreateUserType>, Record<string, never>, Scalars['String'] | string>,
    tags?: GraphCacheResolver<WithTypename<CreateUserType>, Record<string, never>, Array<Scalars['String'] | string>>
  },
  CustomInjectDetailsType?: {
    content?: GraphCacheResolver<WithTypename<CustomInjectDetailsType>, Record<string, never>, WithTypename<ContentType> | string>,
    id?: GraphCacheResolver<WithTypename<CustomInjectDetailsType>, Record<string, never>, Scalars['ID'] | string>,
    overlay?: GraphCacheResolver<WithTypename<CustomInjectDetailsType>, Record<string, never>, WithTypename<OverlayType> | string>,
    user?: GraphCacheResolver<WithTypename<CustomInjectDetailsType>, Record<string, never>, WithTypename<RestrictedUser> | string>
  },
  CustomInjectType?: {
    channelId?: GraphCacheResolver<WithTypename<CustomInjectType>, Record<string, never>, Scalars['ID'] | string>,
    content?: GraphCacheResolver<WithTypename<CustomInjectType>, Record<string, never>, Scalars['String'] | string>,
    exerciseId?: GraphCacheResolver<WithTypename<CustomInjectType>, Record<string, never>, Scalars['ID'] | string>,
    fileId?: GraphCacheResolver<WithTypename<CustomInjectType>, Record<string, never>, Scalars['UUID'] | string>,
    overlay?: GraphCacheResolver<WithTypename<CustomInjectType>, Record<string, never>, WithTypename<OverlayType> | string>,
    teamIds?: GraphCacheResolver<WithTypename<CustomInjectType>, Record<string, never>, Array<Scalars['ID'] | string>>
  },
  DefinitionChannelType?: {
    definition?: GraphCacheResolver<WithTypename<DefinitionChannelType>, Record<string, never>, WithTypename<DefinitionType> | string>,
    description?: GraphCacheResolver<WithTypename<DefinitionChannelType>, Record<string, never>, Scalars['String'] | string>,
    displayName?: GraphCacheResolver<WithTypename<DefinitionChannelType>, Record<string, never>, Scalars['String'] | string>,
    id?: GraphCacheResolver<WithTypename<DefinitionChannelType>, Record<string, never>, Scalars['ID'] | string>,
    name?: GraphCacheResolver<WithTypename<DefinitionChannelType>, Record<string, never>, Scalars['String'] | string>,
    readReceipt?: GraphCacheResolver<WithTypename<DefinitionChannelType>, Record<string, never>, Array<WithTypename<ChannelReceipt> | string>>,
    type?: GraphCacheResolver<WithTypename<DefinitionChannelType>, Record<string, never>, ChannelType | string>
  },
  DefinitionInjectType?: {
    delay?: GraphCacheResolver<WithTypename<DefinitionInjectType>, Record<string, never>, Scalars['Int'] | string>,
    id?: GraphCacheResolver<WithTypename<DefinitionInjectType>, Record<string, never>, Scalars['ID'] | string>,
    name?: GraphCacheResolver<WithTypename<DefinitionInjectType>, Record<string, never>, Scalars['String'] | string>,
    organization?: GraphCacheResolver<WithTypename<DefinitionInjectType>, Record<string, never>, Scalars['String'] | string>,
    target?: GraphCacheResolver<WithTypename<DefinitionInjectType>, Record<string, never>, WithTypename<DefinitionChannelType> | string>,
    time?: GraphCacheResolver<WithTypename<DefinitionInjectType>, Record<string, never>, Scalars['Int'] | string>,
    type?: GraphCacheResolver<WithTypename<DefinitionInjectType>, Record<string, never>, InjectType | string>
  },
  DefinitionRoleType?: {
    definition?: GraphCacheResolver<WithTypename<DefinitionRoleType>, Record<string, never>, WithTypename<DefinitionType> | string>,
    description?: GraphCacheResolver<WithTypename<DefinitionRoleType>, Record<string, never>, Scalars['String'] | string>,
    displayName?: GraphCacheResolver<WithTypename<DefinitionRoleType>, Record<string, never>, Scalars['String'] | string>,
    id?: GraphCacheResolver<WithTypename<DefinitionRoleType>, Record<string, never>, Scalars['ID'] | string>,
    name?: GraphCacheResolver<WithTypename<DefinitionRoleType>, Record<string, never>, Scalars['String'] | string>
  },
  DefinitionType?: {
    addresses?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Array<WithTypename<EmailAddressType> | string>>,
    channels?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Array<WithTypename<DefinitionChannelType> | string>>,
    description?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Scalars['String'] | string>,
    exercises?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Array<WithTypename<ExerciseType> | string>>,
    files?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Array<WithTypename<FileInfoType> | string>>,
    id?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Scalars['ID'] | string>,
    injects?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Array<WithTypename<DefinitionInjectType> | string>>,
    learningObjectives?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Array<WithTypename<LearningObjectiveType> | string>>,
    maintainers?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Array<WithTypename<RestrictedUser> | string>>,
    name?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Scalars['String'] | string>,
    prerequisites?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Array<Scalars['String'] | string>>,
    questionnaires?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Array<WithTypename<QuestionnaireType> | string>>,
    roles?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Array<WithTypename<DefinitionRoleType> | string>>,
    targetAudience?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Scalars['String'] | string>,
    timestampCreated?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Scalars['DateTime'] | string>,
    tools?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Array<WithTypename<ToolType> | string>>,
    uploadedBy?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, WithTypename<RestrictedUser> | string>,
    version?: GraphCacheResolver<WithTypename<DefinitionType>, Record<string, never>, Scalars['String'] | string>
  },
  DeleteDefinitionMutation?: {
    definitionId?: GraphCacheResolver<WithTypename<DeleteDefinitionMutation>, Record<string, never>, Scalars['ID'] | string>,
    exerciseIds?: GraphCacheResolver<WithTypename<DeleteDefinitionMutation>, Record<string, never>, Array<Scalars['ID'] | string>>,
    operationDone?: GraphCacheResolver<WithTypename<DeleteDefinitionMutation>, Record<string, never>, Scalars['Boolean'] | string>,
    teamIds?: GraphCacheResolver<WithTypename<DeleteDefinitionMutation>, Record<string, never>, Array<Scalars['ID'] | string>>
  },
  DeleteExerciseMutation?: {
    exerciseId?: GraphCacheResolver<WithTypename<DeleteExerciseMutation>, Record<string, never>, Scalars['ID'] | string>,
    operationDone?: GraphCacheResolver<WithTypename<DeleteExerciseMutation>, Record<string, never>, Scalars['Boolean'] | string>,
    teamIds?: GraphCacheResolver<WithTypename<DeleteExerciseMutation>, Record<string, never>, Array<Scalars['ID'] | string>>
  },
  DeleteTagsMutation?: {
    operationDone?: GraphCacheResolver<WithTypename<DeleteTagsMutation>, Record<string, never>, Scalars['Boolean'] | string>,
    tagIds?: GraphCacheResolver<WithTypename<DeleteTagsMutation>, Record<string, never>, Array<Scalars['ID'] | string>>
  },
  DeleteUsersMutation?: {
    operationDone?: GraphCacheResolver<WithTypename<DeleteUsersMutation>, Record<string, never>, Scalars['Boolean'] | string>,
    userIds?: GraphCacheResolver<WithTypename<DeleteUsersMutation>, Record<string, never>, Array<Scalars['ID'] | string>>
  },
  EmailAddressType?: {
    address?: GraphCacheResolver<WithTypename<EmailAddressType>, Record<string, never>, Scalars['String'] | string>,
    control?: GraphCacheResolver<WithTypename<EmailAddressType>, Record<string, never>, WithTypename<ControlType> | string>,
    definition?: GraphCacheResolver<WithTypename<EmailAddressType>, Record<string, never>, WithTypename<ExerciseDefinitionType> | string>,
    description?: GraphCacheResolver<WithTypename<EmailAddressType>, Record<string, never>, Scalars['String'] | string>,
    id?: GraphCacheResolver<WithTypename<EmailAddressType>, Record<string, never>, Scalars['ID'] | string>,
    organization?: GraphCacheResolver<WithTypename<EmailAddressType>, Record<string, never>, Scalars['String'] | string>,
    teamVisible?: GraphCacheResolver<WithTypename<EmailAddressType>, Record<string, never>, Scalars['Boolean'] | string>,
    templates?: GraphCacheResolver<WithTypename<EmailAddressType>, Record<string, never>, Array<WithTypename<EmailTemplateType> | string>>
  },
  EmailDraftType?: {
    activateMilestone?: GraphCacheResolver<WithTypename<EmailDraftType>, Record<string, never>, Scalars['String'] | string>,
    content?: GraphCacheResolver<WithTypename<EmailDraftType>, Record<string, never>, Scalars['String'] | string>,
    deactivateMilestone?: GraphCacheResolver<WithTypename<EmailDraftType>, Record<string, never>, Scalars['String'] | string>,
    emailThreadId?: GraphCacheResolver<WithTypename<EmailDraftType>, Record<string, never>, Scalars['String'] | string>,
    fileId?: GraphCacheResolver<WithTypename<EmailDraftType>, Record<string, never>, Scalars['UUID'] | string>,
    instructor?: GraphCacheResolver<WithTypename<EmailDraftType>, Record<string, never>, Scalars['Boolean'] | string>,
    selectedContacts?: GraphCacheResolver<WithTypename<EmailDraftType>, Record<string, never>, Array<Scalars['String'] | string>>,
    senderAddress?: GraphCacheResolver<WithTypename<EmailDraftType>, Record<string, never>, Scalars['String'] | string>,
    subject?: GraphCacheResolver<WithTypename<EmailDraftType>, Record<string, never>, Scalars['String'] | string>,
    teamId?: GraphCacheResolver<WithTypename<EmailDraftType>, Record<string, never>, Scalars['String'] | string>,
    templateId?: GraphCacheResolver<WithTypename<EmailDraftType>, Record<string, never>, Scalars['String'] | string>
  },
  EmailParticipantType?: {
    address?: GraphCacheResolver<WithTypename<EmailParticipantType>, Record<string, never>, Scalars['String'] | string>,
    definitionAddress?: GraphCacheResolver<WithTypename<EmailParticipantType>, Record<string, never>, WithTypename<EmailAddressType> | string>,
    emails?: GraphCacheResolver<WithTypename<EmailParticipantType>, Record<string, never>, Array<WithTypename<EmailType> | string>>,
    exercise?: GraphCacheResolver<WithTypename<EmailParticipantType>, Record<string, never>, WithTypename<ExerciseType> | string>,
    id?: GraphCacheResolver<WithTypename<EmailParticipantType>, Record<string, never>, Scalars['ID'] | string>,
    team?: GraphCacheResolver<WithTypename<EmailParticipantType>, Record<string, never>, WithTypename<TeamType> | string>,
    threads?: GraphCacheResolver<WithTypename<EmailParticipantType>, Record<string, never>, Array<WithTypename<EmailThreadType> | string>>
  },
  EmailReceipt?: {
    emailId?: GraphCacheResolver<WithTypename<EmailReceipt>, Record<string, never>, Scalars['ID'] | string>,
    readReceipt?: GraphCacheResolver<WithTypename<EmailReceipt>, Record<string, never>, Scalars['DateTime'] | string>
  },
  EmailTemplateType?: {
    content?: GraphCacheResolver<WithTypename<EmailTemplateType>, Record<string, never>, WithTypename<ContentType> | string>,
    context?: GraphCacheResolver<WithTypename<EmailTemplateType>, Record<string, never>, Scalars['String'] | string>,
    control?: GraphCacheResolver<WithTypename<EmailTemplateType>, Record<string, never>, WithTypename<ControlType> | string>,
    id?: GraphCacheResolver<WithTypename<EmailTemplateType>, Record<string, never>, Scalars['ID'] | string>,
    sender?: GraphCacheResolver<WithTypename<EmailTemplateType>, Record<string, never>, Scalars['String'] | string>,
    subject?: GraphCacheResolver<WithTypename<EmailTemplateType>, Record<string, never>, Scalars['String'] | string>
  },
  EmailThreadReceipt?: {
    isUnread?: GraphCacheResolver<WithTypename<EmailThreadReceipt>, Record<string, never>, Scalars['Boolean'] | string>,
    teamId?: GraphCacheResolver<WithTypename<EmailThreadReceipt>, Record<string, never>, Scalars['ID'] | string>,
    threadId?: GraphCacheResolver<WithTypename<EmailThreadReceipt>, Record<string, never>, Scalars['ID'] | string>
  },
  EmailThreadSubscription?: {
    emailThread?: GraphCacheResolver<WithTypename<EmailThreadSubscription>, Record<string, never>, WithTypename<EmailThreadType> | string>
  },
  EmailThreadType?: {
    archived?: GraphCacheResolver<WithTypename<EmailThreadType>, Record<string, never>, Scalars['Boolean'] | string>,
    emails?: GraphCacheResolver<WithTypename<EmailThreadType>, Record<string, never>, Array<WithTypename<EmailType> | string>>,
    exercise?: GraphCacheResolver<WithTypename<EmailThreadType>, Record<string, never>, WithTypename<ExerciseType> | string>,
    id?: GraphCacheResolver<WithTypename<EmailThreadType>, Record<string, never>, Scalars['ID'] | string>,
    lastEmail?: GraphCacheResolver<WithTypename<EmailThreadType>, Record<string, never>, WithTypename<EmailType> | string>,
    participants?: GraphCacheResolver<WithTypename<EmailThreadType>, Record<string, never>, Array<WithTypename<EmailParticipantType> | string>>,
    readReceipt?: GraphCacheResolver<WithTypename<EmailThreadType>, Record<string, never>, Array<WithTypename<EmailThreadReceipt> | string>>,
    subject?: GraphCacheResolver<WithTypename<EmailThreadType>, Record<string, never>, Scalars['String'] | string>,
    timestamp?: GraphCacheResolver<WithTypename<EmailThreadType>, Record<string, never>, Scalars['DateTime'] | string>
  },
  EmailType?: {
    content?: GraphCacheResolver<WithTypename<EmailType>, Record<string, never>, WithTypename<ContentType> | string>,
    id?: GraphCacheResolver<WithTypename<EmailType>, Record<string, never>, Scalars['ID'] | string>,
    overlay?: GraphCacheResolver<WithTypename<EmailType>, Record<string, never>, WithTypename<OverlayType> | string>,
    readReceipt?: GraphCacheResolver<WithTypename<EmailType>, Record<string, never>, Scalars['DateTime'] | string>,
    sender?: GraphCacheResolver<WithTypename<EmailType>, Record<string, never>, WithTypename<EmailParticipantType> | string>,
    thread?: GraphCacheResolver<WithTypename<EmailType>, Record<string, never>, WithTypename<EmailThreadType> | string>,
    timestamp?: GraphCacheResolver<WithTypename<EmailType>, Record<string, never>, Scalars['DateTime'] | string>,
    todo?: GraphCacheResolver<WithTypename<EmailType>, Record<string, never>, Scalars['Boolean'] | string>,
    user?: GraphCacheResolver<WithTypename<EmailType>, Record<string, never>, WithTypename<RestrictedUser> | string>
  },
  ExerciseDefinitionType?: {
    id?: GraphCacheResolver<WithTypename<ExerciseDefinitionType>, Record<string, never>, Scalars['ID'] | string>,
    name?: GraphCacheResolver<WithTypename<ExerciseDefinitionType>, Record<string, never>, Scalars['String'] | string>
  },
  ExerciseLoopRunningSubscription?: {
    exerciseLoopRunning?: GraphCacheResolver<WithTypename<ExerciseLoopRunningSubscription>, Record<string, never>, Scalars['Boolean'] | string>
  },
  ExerciseType?: {
    createdBy?: GraphCacheResolver<WithTypename<ExerciseType>, Record<string, never>, WithTypename<RestrictedUser> | string>,
    definition?: GraphCacheResolver<WithTypename<ExerciseType>, Record<string, never>, WithTypename<ExerciseDefinitionType> | string>,
    elapsedS?: GraphCacheResolver<WithTypename<ExerciseType>, Record<string, never>, Scalars['Int'] | string>,
    emailParticipants?: GraphCacheResolver<WithTypename<ExerciseType>, Record<string, never>, Array<WithTypename<EmailParticipantType> | string>>,
    exerciseStart?: GraphCacheResolver<WithTypename<ExerciseType>, Record<string, never>, Scalars['DateTime'] | string>,
    finished?: GraphCacheResolver<WithTypename<ExerciseType>, Record<string, never>, Scalars['Boolean'] | string>,
    id?: GraphCacheResolver<WithTypename<ExerciseType>, Record<string, never>, Scalars['ID'] | string>,
    instructors?: GraphCacheResolver<WithTypename<ExerciseType>, Record<string, never>, Array<WithTypename<RestrictedUser> | string>>,
    name?: GraphCacheResolver<WithTypename<ExerciseType>, Record<string, never>, Scalars['String'] | string>,
    running?: GraphCacheResolver<WithTypename<ExerciseType>, Record<string, never>, Scalars['Boolean'] | string>,
    teams?: GraphCacheResolver<WithTypename<ExerciseType>, Record<string, never>, Array<WithTypename<TeamType> | string>>,
    threads?: GraphCacheResolver<WithTypename<ExerciseType>, Record<string, never>, Array<WithTypename<EmailThreadType> | string>>,
    timestampCreated?: GraphCacheResolver<WithTypename<ExerciseType>, Record<string, never>, Scalars['DateTime'] | string>,
    uuid?: GraphCacheResolver<WithTypename<ExerciseType>, Record<string, never>, Scalars['UUID'] | string>
  },
  ExercisesSubscription?: {
    eventType?: GraphCacheResolver<WithTypename<ExercisesSubscription>, Record<string, never>, EventType | string>,
    exercise?: GraphCacheResolver<WithTypename<ExercisesSubscription>, Record<string, never>, WithTypename<ExerciseType> | string>
  },
  ExtendedToolType?: {
    category?: GraphCacheResolver<WithTypename<ExtendedToolType>, Record<string, never>, Scalars['String'] | string>,
    defaultResponse?: GraphCacheResolver<WithTypename<ExtendedToolType>, Record<string, never>, Scalars['String'] | string>,
    definition?: GraphCacheResolver<WithTypename<ExtendedToolType>, Record<string, never>, WithTypename<ExerciseDefinitionType> | string>,
    hint?: GraphCacheResolver<WithTypename<ExtendedToolType>, Record<string, never>, Scalars['String'] | string>,
    id?: GraphCacheResolver<WithTypename<ExtendedToolType>, Record<string, never>, Scalars['ID'] | string>,
    name?: GraphCacheResolver<WithTypename<ExtendedToolType>, Record<string, never>, Scalars['String'] | string>,
    responses?: GraphCacheResolver<WithTypename<ExtendedToolType>, Record<string, never>, Array<WithTypename<ToolResponseType> | string>>,
    roles?: GraphCacheResolver<WithTypename<ExtendedToolType>, Record<string, never>, Scalars['String'] | string>,
    tooltipDescription?: GraphCacheResolver<WithTypename<ExtendedToolType>, Record<string, never>, Scalars['String'] | string>
  },
  FileInfoType?: {
    definition?: GraphCacheResolver<WithTypename<FileInfoType>, Record<string, never>, WithTypename<DefinitionType> | string>,
    fileName?: GraphCacheResolver<WithTypename<FileInfoType>, Record<string, never>, Scalars['String'] | string>,
    id?: GraphCacheResolver<WithTypename<FileInfoType>, Record<string, never>, Scalars['UUID'] | string>
  },
  FilterUsersType?: {
    active?: GraphCacheResolver<WithTypename<FilterUsersType>, Record<string, never>, Scalars['Boolean'] | string>,
    firstName?: GraphCacheResolver<WithTypename<FilterUsersType>, Record<string, never>, Scalars['String'] | string>,
    groups?: GraphCacheResolver<WithTypename<FilterUsersType>, Record<string, never>, Array<AuthGroup | string>>,
    imported?: GraphCacheResolver<WithTypename<FilterUsersType>, Record<string, never>, Scalars['Boolean'] | string>,
    lastName?: GraphCacheResolver<WithTypename<FilterUsersType>, Record<string, never>, Scalars['String'] | string>,
    limit?: GraphCacheResolver<WithTypename<FilterUsersType>, Record<string, never>, Scalars['Int'] | string>,
    skip?: GraphCacheResolver<WithTypename<FilterUsersType>, Record<string, never>, Scalars['Int'] | string>,
    tags?: GraphCacheResolver<WithTypename<FilterUsersType>, Record<string, never>, Array<Scalars['String'] | string>>,
    username?: GraphCacheResolver<WithTypename<FilterUsersType>, Record<string, never>, Scalars['String'] | string>
  },
  FreeFormQuestionDetailsType?: {
    definition?: GraphCacheResolver<WithTypename<FreeFormQuestionDetailsType>, Record<string, never>, WithTypename<ExerciseDefinitionType> | string>,
    id?: GraphCacheResolver<WithTypename<FreeFormQuestionDetailsType>, Record<string, never>, Scalars['ID'] | string>,
    multiline?: GraphCacheResolver<WithTypename<FreeFormQuestionDetailsType>, Record<string, never>, Scalars['Boolean'] | string>,
    relatedMilestones?: GraphCacheResolver<WithTypename<FreeFormQuestionDetailsType>, Record<string, never>, Array<WithTypename<MilestoneType> | string>>
  },
  GrapheneConfig?: {
    customEmailSuffix?: GraphCacheResolver<WithTypename<GrapheneConfig>, Record<string, never>, Scalars['String'] | string>,
    emailBetweenTeams?: GraphCacheResolver<WithTypename<GrapheneConfig>, Record<string, never>, Scalars['Boolean'] | string>,
    enableRoles?: GraphCacheResolver<WithTypename<GrapheneConfig>, Record<string, never>, Scalars['Boolean'] | string>,
    exerciseDuration?: GraphCacheResolver<WithTypename<GrapheneConfig>, Record<string, never>, Scalars['Int'] | string>,
    showExerciseTime?: GraphCacheResolver<WithTypename<GrapheneConfig>, Record<string, never>, Scalars['Boolean'] | string>
  },
  InjectDetailsType?: {
    confirmation?: GraphCacheResolver<WithTypename<InjectDetailsType>, Record<string, never>, WithTypename<ConfirmationType> | string>,
    confirmed?: GraphCacheResolver<WithTypename<InjectDetailsType>, Record<string, never>, Scalars['Boolean'] | string>,
    confirmedBy?: GraphCacheResolver<WithTypename<InjectDetailsType>, Record<string, never>, WithTypename<RestrictedUser> | string>,
    content?: GraphCacheResolver<WithTypename<InjectDetailsType>, Record<string, never>, WithTypename<ContentType> | string>,
    id?: GraphCacheResolver<WithTypename<InjectDetailsType>, Record<string, never>, Scalars['ID'] | string>,
    inject?: GraphCacheResolver<WithTypename<InjectDetailsType>, Record<string, never>, WithTypename<DefinitionInjectType> | string>,
    overlay?: GraphCacheResolver<WithTypename<InjectDetailsType>, Record<string, never>, WithTypename<OverlayType> | string>,
    timestampConfirmed?: GraphCacheResolver<WithTypename<InjectDetailsType>, Record<string, never>, Scalars['DateTime'] | string>
  },
  LearningActivityType?: {
    description?: GraphCacheResolver<WithTypename<LearningActivityType>, Record<string, never>, Scalars['String'] | string>,
    id?: GraphCacheResolver<WithTypename<LearningActivityType>, Record<string, never>, Scalars['ID'] | string>,
    milestones?: GraphCacheResolver<WithTypename<LearningActivityType>, Record<string, never>, Array<WithTypename<MilestoneType> | string>>,
    name?: GraphCacheResolver<WithTypename<LearningActivityType>, Record<string, never>, Scalars['String'] | string>,
    objective?: GraphCacheResolver<WithTypename<LearningActivityType>, Record<string, never>, WithTypename<LearningObjectiveType> | string>,
    tags?: GraphCacheResolver<WithTypename<LearningActivityType>, Record<string, never>, Scalars['String'] | string>
  },
  LearningObjectiveType?: {
    activities?: GraphCacheResolver<WithTypename<LearningObjectiveType>, Record<string, never>, Array<WithTypename<LearningActivityType> | string>>,
    definition?: GraphCacheResolver<WithTypename<LearningObjectiveType>, Record<string, never>, WithTypename<DefinitionType> | string>,
    description?: GraphCacheResolver<WithTypename<LearningObjectiveType>, Record<string, never>, Scalars['String'] | string>,
    id?: GraphCacheResolver<WithTypename<LearningObjectiveType>, Record<string, never>, Scalars['ID'] | string>,
    name?: GraphCacheResolver<WithTypename<LearningObjectiveType>, Record<string, never>, Scalars['String'] | string>,
    order?: GraphCacheResolver<WithTypename<LearningObjectiveType>, Record<string, never>, Scalars['Int'] | string>,
    tags?: GraphCacheResolver<WithTypename<LearningObjectiveType>, Record<string, never>, Scalars['String'] | string>
  },
  MilestoneStateHistoryType?: {
    id?: GraphCacheResolver<WithTypename<MilestoneStateHistoryType>, Record<string, never>, Scalars['ID'] | string>,
    reached?: GraphCacheResolver<WithTypename<MilestoneStateHistoryType>, Record<string, never>, Scalars['Boolean'] | string>,
    timestampFrom?: GraphCacheResolver<WithTypename<MilestoneStateHistoryType>, Record<string, never>, Scalars['DateTime'] | string>
  },
  MilestoneStateType?: {
    activity?: GraphCacheResolver<WithTypename<MilestoneStateType>, Record<string, never>, WithTypename<TeamLearningActivityType> | string>,
    history?: GraphCacheResolver<WithTypename<MilestoneStateType>, Record<string, never>, Array<WithTypename<MilestoneStateHistoryType> | string>>,
    id?: GraphCacheResolver<WithTypename<MilestoneStateType>, Record<string, never>, Scalars['ID'] | string>,
    milestone?: GraphCacheResolver<WithTypename<MilestoneStateType>, Record<string, never>, WithTypename<MilestoneType> | string>,
    reached?: GraphCacheResolver<WithTypename<MilestoneStateType>, Record<string, never>, Scalars['Boolean'] | string>,
    teamIds?: GraphCacheResolver<WithTypename<MilestoneStateType>, Record<string, never>, Array<Scalars['ID'] | string>>,
    timestampReached?: GraphCacheResolver<WithTypename<MilestoneStateType>, Record<string, never>, Scalars['DateTime'] | string>
  },
  MilestoneType?: {
    activity?: GraphCacheResolver<WithTypename<MilestoneType>, Record<string, never>, WithTypename<LearningActivityType> | string>,
    description?: GraphCacheResolver<WithTypename<MilestoneType>, Record<string, never>, Scalars['String'] | string>,
    displayName?: GraphCacheResolver<WithTypename<MilestoneType>, Record<string, never>, Scalars['String'] | string>,
    fileNames?: GraphCacheResolver<WithTypename<MilestoneType>, Record<string, never>, Scalars['String'] | string>,
    final?: GraphCacheResolver<WithTypename<MilestoneType>, Record<string, never>, Scalars['Boolean'] | string>,
    id?: GraphCacheResolver<WithTypename<MilestoneType>, Record<string, never>, Scalars['ID'] | string>,
    initialState?: GraphCacheResolver<WithTypename<MilestoneType>, Record<string, never>, Scalars['Boolean'] | string>,
    name?: GraphCacheResolver<WithTypename<MilestoneType>, Record<string, never>, Scalars['String'] | string>,
    roles?: GraphCacheResolver<WithTypename<MilestoneType>, Record<string, never>, Scalars['String'] | string>,
    tags?: GraphCacheResolver<WithTypename<MilestoneType>, Record<string, never>, Array<Scalars['String'] | string>>,
    teamVisible?: GraphCacheResolver<WithTypename<MilestoneType>, Record<string, never>, Scalars['Boolean'] | string>
  },
  MilestonesSubscription?: {
    milestones?: GraphCacheResolver<WithTypename<MilestonesSubscription>, Record<string, never>, Array<WithTypename<MilestoneStateType> | string>>
  },
  ModifyMilestoneMutation?: {
    operationDone?: GraphCacheResolver<WithTypename<ModifyMilestoneMutation>, Record<string, never>, Scalars['Boolean'] | string>
  },
  MoveExerciseTimeMutation?: {
    exercise?: GraphCacheResolver<WithTypename<MoveExerciseTimeMutation>, Record<string, never>, WithTypename<ExerciseType> | string>
  },
  MutationResult?: {
    operationDone?: GraphCacheResolver<WithTypename<MutationResult>, Record<string, never>, Scalars['Boolean'] | string>
  },
  OverlayType?: {
    duration?: GraphCacheResolver<WithTypename<OverlayType>, Record<string, never>, Scalars['Int'] | string>,
    id?: GraphCacheResolver<WithTypename<OverlayType>, Record<string, never>, Scalars['ID'] | string>
  },
  PasswordChange?: {
    passwordChanged?: GraphCacheResolver<WithTypename<PasswordChange>, Record<string, never>, Scalars['Boolean'] | string>
  },
  QuestionRelatedMilestonesType?: {
    milestones?: GraphCacheResolver<WithTypename<QuestionRelatedMilestonesType>, Record<string, never>, Array<WithTypename<MilestoneStateType> | string>>,
    questionId?: GraphCacheResolver<WithTypename<QuestionRelatedMilestonesType>, Record<string, never>, Scalars['ID'] | string>
  },
  QuestionType?: {
    content?: GraphCacheResolver<WithTypename<QuestionType>, Record<string, never>, WithTypename<ContentType> | string>,
    details?: GraphCacheResolver<WithTypename<QuestionType>, Record<string, never>, WithTypename<QuestionDetails> | string>,
    id?: GraphCacheResolver<WithTypename<QuestionType>, Record<string, never>, Scalars['ID'] | string>,
    questionnaire?: GraphCacheResolver<WithTypename<QuestionType>, Record<string, never>, WithTypename<QuestionnaireType> | string>,
    type?: GraphCacheResolver<WithTypename<QuestionType>, Record<string, never>, QuestionTypes | string>
  },
  QuestionnaireAnswerType?: {
    answer?: GraphCacheResolver<WithTypename<QuestionnaireAnswerType>, Record<string, never>, Scalars['String'] | string>,
    id?: GraphCacheResolver<WithTypename<QuestionnaireAnswerType>, Record<string, never>, Scalars['ID'] | string>,
    isCorrect?: GraphCacheResolver<WithTypename<QuestionnaireAnswerType>, Record<string, never>, Scalars['Boolean'] | string>,
    question?: GraphCacheResolver<WithTypename<QuestionnaireAnswerType>, Record<string, never>, WithTypename<QuestionType> | string>,
    teamQuestionnaireState?: GraphCacheResolver<WithTypename<QuestionnaireAnswerType>, Record<string, never>, WithTypename<TeamQuestionnaireStateType> | string>
  },
  QuestionnaireInputType?: {
    answers?: GraphCacheResolver<WithTypename<QuestionnaireInputType>, Record<string, never>, Array<WithTypename<AnswerType> | string>>,
    questionnaireId?: GraphCacheResolver<WithTypename<QuestionnaireInputType>, Record<string, never>, Scalars['ID'] | string>,
    teamId?: GraphCacheResolver<WithTypename<QuestionnaireInputType>, Record<string, never>, Scalars['ID'] | string>
  },
  QuestionnaireReviewInputType?: {
    activateMilestones?: GraphCacheResolver<WithTypename<QuestionnaireReviewInputType>, Record<string, never>, Array<Scalars['String'] | string>>,
    deactivateMilestones?: GraphCacheResolver<WithTypename<QuestionnaireReviewInputType>, Record<string, never>, Array<Scalars['String'] | string>>,
    questionnaireId?: GraphCacheResolver<WithTypename<QuestionnaireReviewInputType>, Record<string, never>, Scalars['ID'] | string>,
    teamId?: GraphCacheResolver<WithTypename<QuestionnaireReviewInputType>, Record<string, never>, Scalars['ID'] | string>
  },
  QuestionnaireType?: {
    content?: GraphCacheResolver<WithTypename<QuestionnaireType>, Record<string, never>, WithTypename<ContentType> | string>,
    control?: GraphCacheResolver<WithTypename<QuestionnaireType>, Record<string, never>, WithTypename<ControlType> | string>,
    definition?: GraphCacheResolver<WithTypename<QuestionnaireType>, Record<string, never>, WithTypename<DefinitionType> | string>,
    id?: GraphCacheResolver<WithTypename<QuestionnaireType>, Record<string, never>, Scalars['ID'] | string>,
    overlay?: GraphCacheResolver<WithTypename<QuestionnaireType>, Record<string, never>, WithTypename<OverlayType> | string>,
    questions?: GraphCacheResolver<WithTypename<QuestionnaireType>, Record<string, never>, Array<WithTypename<QuestionType> | string>>,
    teamQuestionnaireStates?: GraphCacheResolver<WithTypename<QuestionnaireType>, Record<string, never>, Array<WithTypename<TeamQuestionnaireStateType> | string>>,
    time?: GraphCacheResolver<WithTypename<QuestionnaireType>, Record<string, never>, Scalars['Int'] | string>,
    title?: GraphCacheResolver<WithTypename<QuestionnaireType>, Record<string, never>, Scalars['String'] | string>
  },
  RadioQuestionDetailsType?: {
    controls?: GraphCacheResolver<WithTypename<RadioQuestionDetailsType>, Record<string, never>, Array<WithTypename<ControlsMapType> | string>>,
    correct?: GraphCacheResolver<WithTypename<RadioQuestionDetailsType>, Record<string, never>, Scalars['Int'] | string>,
    definition?: GraphCacheResolver<WithTypename<RadioQuestionDetailsType>, Record<string, never>, WithTypename<ExerciseDefinitionType> | string>,
    id?: GraphCacheResolver<WithTypename<RadioQuestionDetailsType>, Record<string, never>, Scalars['ID'] | string>,
    labels?: GraphCacheResolver<WithTypename<RadioQuestionDetailsType>, Record<string, never>, Scalars['String'] | string>,
    max?: GraphCacheResolver<WithTypename<RadioQuestionDetailsType>, Record<string, never>, Scalars['Int'] | string>
  },
  ReadReceiptType?: {
    actionLogId?: GraphCacheResolver<WithTypename<ReadReceiptType>, Record<string, never>, Scalars['ID'] | string>,
    readReceipt?: GraphCacheResolver<WithTypename<ReadReceiptType>, Record<string, never>, Scalars['DateTime'] | string>
  },
  RegenerateCredentialsMutation?: {
    operationDone?: GraphCacheResolver<WithTypename<RegenerateCredentialsMutation>, Record<string, never>, Scalars['Boolean'] | string>
  },
  RemoveDefinitionAccessMutation?: {
    operationDone?: GraphCacheResolver<WithTypename<RemoveDefinitionAccessMutation>, Record<string, never>, Scalars['Boolean'] | string>
  },
  RemoveInstructorsFromExerciseMutation?: {
    operationDone?: GraphCacheResolver<WithTypename<RemoveInstructorsFromExerciseMutation>, Record<string, never>, Scalars['Boolean'] | string>
  },
  RemoveUsersFromTeamMutation?: {
    operationDone?: GraphCacheResolver<WithTypename<RemoveUsersFromTeamMutation>, Record<string, never>, Scalars['Boolean'] | string>
  },
  RestrictedExercise?: {
    id?: GraphCacheResolver<WithTypename<RestrictedExercise>, Record<string, never>, Scalars['ID'] | string>,
    name?: GraphCacheResolver<WithTypename<RestrictedExercise>, Record<string, never>, Scalars['String'] | string>,
    uuid?: GraphCacheResolver<WithTypename<RestrictedExercise>, Record<string, never>, Scalars['UUID'] | string>
  },
  RestrictedTeam?: {
    emailAddress?: GraphCacheResolver<WithTypename<RestrictedTeam>, Record<string, never>, WithTypename<EmailParticipantType> | string>,
    exercise?: GraphCacheResolver<WithTypename<RestrictedTeam>, Record<string, never>, WithTypename<ExerciseType> | string>,
    id?: GraphCacheResolver<WithTypename<RestrictedTeam>, Record<string, never>, Scalars['ID'] | string>,
    name?: GraphCacheResolver<WithTypename<RestrictedTeam>, Record<string, never>, Scalars['String'] | string>,
    role?: GraphCacheResolver<WithTypename<RestrictedTeam>, Record<string, never>, Scalars['String'] | string>
  },
  RestrictedUser?: {
    dateJoined?: GraphCacheResolver<WithTypename<RestrictedUser>, Record<string, never>, Scalars['DateTime'] | string>,
    firstName?: GraphCacheResolver<WithTypename<RestrictedUser>, Record<string, never>, Scalars['String'] | string>,
    group?: GraphCacheResolver<WithTypename<RestrictedUser>, Record<string, never>, AuthGroup | string>,
    id?: GraphCacheResolver<WithTypename<RestrictedUser>, Record<string, never>, Scalars['UUID'] | string>,
    isActive?: GraphCacheResolver<WithTypename<RestrictedUser>, Record<string, never>, Scalars['Boolean'] | string>,
    isImported?: GraphCacheResolver<WithTypename<RestrictedUser>, Record<string, never>, Scalars['Boolean'] | string>,
    lastLogin?: GraphCacheResolver<WithTypename<RestrictedUser>, Record<string, never>, Scalars['DateTime'] | string>,
    lastName?: GraphCacheResolver<WithTypename<RestrictedUser>, Record<string, never>, Scalars['String'] | string>,
    tags?: GraphCacheResolver<WithTypename<RestrictedUser>, Record<string, never>, Array<WithTypename<TagType> | string>>,
    username?: GraphCacheResolver<WithTypename<RestrictedUser>, Record<string, never>, Scalars['String'] | string>
  },
  ReviewQuestionnaireMutation?: {
    updatedState?: GraphCacheResolver<WithTypename<ReviewQuestionnaireMutation>, Record<string, never>, WithTypename<TeamQuestionnaireStateType> | string>
  },
  SendCustomInjectMutation?: {
    operationDone?: GraphCacheResolver<WithTypename<SendCustomInjectMutation>, Record<string, never>, Scalars['Boolean'] | string>
  },
  SendEmailMutation?: {
    email?: GraphCacheResolver<WithTypename<SendEmailMutation>, Record<string, never>, WithTypename<EmailType> | string>,
    operationDone?: GraphCacheResolver<WithTypename<SendEmailMutation>, Record<string, never>, Scalars['Boolean'] | string>
  },
  SendEmailType?: {
    activateMilestone?: GraphCacheResolver<WithTypename<SendEmailType>, Record<string, never>, Scalars['String'] | string>,
    content?: GraphCacheResolver<WithTypename<SendEmailType>, Record<string, never>, Scalars['String'] | string>,
    deactivateMilestone?: GraphCacheResolver<WithTypename<SendEmailType>, Record<string, never>, Scalars['String'] | string>,
    fileId?: GraphCacheResolver<WithTypename<SendEmailType>, Record<string, never>, Scalars['UUID'] | string>,
    senderAddress?: GraphCacheResolver<WithTypename<SendEmailType>, Record<string, never>, Scalars['String'] | string>,
    threadId?: GraphCacheResolver<WithTypename<SendEmailType>, Record<string, never>, Scalars['ID'] | string>
  },
  StartExerciseMutation?: {
    exercise?: GraphCacheResolver<WithTypename<StartExerciseMutation>, Record<string, never>, WithTypename<ExerciseType> | string>
  },
  StopExerciseMutation?: {
    exercise?: GraphCacheResolver<WithTypename<StopExerciseMutation>, Record<string, never>, WithTypename<ExerciseType> | string>
  },
  TagType?: {
    id?: GraphCacheResolver<WithTypename<TagType>, Record<string, never>, Scalars['ID'] | string>,
    name?: GraphCacheResolver<WithTypename<TagType>, Record<string, never>, Scalars['String'] | string>
  },
  TeamLearningActivityType?: {
    activity?: GraphCacheResolver<WithTypename<TeamLearningActivityType>, Record<string, never>, WithTypename<LearningActivityType> | string>,
    id?: GraphCacheResolver<WithTypename<TeamLearningActivityType>, Record<string, never>, Scalars['ID'] | string>,
    milestoneStates?: GraphCacheResolver<WithTypename<TeamLearningActivityType>, Record<string, never>, Array<WithTypename<MilestoneStateType> | string>>,
    reached?: GraphCacheResolver<WithTypename<TeamLearningActivityType>, Record<string, never>, Scalars['Boolean'] | string>,
    teamObjective?: GraphCacheResolver<WithTypename<TeamLearningActivityType>, Record<string, never>, WithTypename<TeamLearningObjectiveType> | string>
  },
  TeamLearningObjectiveType?: {
    activities?: GraphCacheResolver<WithTypename<TeamLearningObjectiveType>, Record<string, never>, Array<WithTypename<TeamLearningActivityType> | string>>,
    id?: GraphCacheResolver<WithTypename<TeamLearningObjectiveType>, Record<string, never>, Scalars['ID'] | string>,
    objective?: GraphCacheResolver<WithTypename<TeamLearningObjectiveType>, Record<string, never>, WithTypename<LearningObjectiveType> | string>,
    reached?: GraphCacheResolver<WithTypename<TeamLearningObjectiveType>, Record<string, never>, Scalars['Boolean'] | string>
  },
  TeamQuestionnaireStateSubscription?: {
    teamQuestionnaireState?: GraphCacheResolver<WithTypename<TeamQuestionnaireStateSubscription>, Record<string, never>, WithTypename<TeamQuestionnaireStateType> | string>
  },
  TeamQuestionnaireStateType?: {
    answers?: GraphCacheResolver<WithTypename<TeamQuestionnaireStateType>, Record<string, never>, Array<WithTypename<QuestionnaireAnswerType> | string>>,
    id?: GraphCacheResolver<WithTypename<TeamQuestionnaireStateType>, Record<string, never>, Scalars['ID'] | string>,
    questionnaire?: GraphCacheResolver<WithTypename<TeamQuestionnaireStateType>, Record<string, never>, WithTypename<QuestionnaireType> | string>,
    relatedMilestones?: GraphCacheResolver<WithTypename<TeamQuestionnaireStateType>, Record<string, never>, Array<WithTypename<QuestionRelatedMilestonesType> | string>>,
    reviewedBy?: GraphCacheResolver<WithTypename<TeamQuestionnaireStateType>, Record<string, never>, WithTypename<RestrictedUser> | string>,
    status?: GraphCacheResolver<WithTypename<TeamQuestionnaireStateType>, Record<string, never>, Status | string>,
    team?: GraphCacheResolver<WithTypename<TeamQuestionnaireStateType>, Record<string, never>, WithTypename<TeamType> | string>,
    timestampAnswered?: GraphCacheResolver<WithTypename<TeamQuestionnaireStateType>, Record<string, never>, Scalars['DateTime'] | string>,
    timestampReviewed?: GraphCacheResolver<WithTypename<TeamQuestionnaireStateType>, Record<string, never>, Scalars['DateTime'] | string>,
    timestampSent?: GraphCacheResolver<WithTypename<TeamQuestionnaireStateType>, Record<string, never>, Scalars['DateTime'] | string>,
    todo?: GraphCacheResolver<WithTypename<TeamQuestionnaireStateType>, Record<string, never>, Scalars['Boolean'] | string>
  },
  TeamType?: {
    emailAddress?: GraphCacheResolver<WithTypename<TeamType>, Record<string, never>, WithTypename<EmailParticipantType> | string>,
    exercise?: GraphCacheResolver<WithTypename<TeamType>, Record<string, never>, WithTypename<ExerciseType> | string>,
    finishTime?: GraphCacheResolver<WithTypename<TeamType>, Record<string, never>, Scalars['DateTime'] | string>,
    id?: GraphCacheResolver<WithTypename<TeamType>, Record<string, never>, Scalars['ID'] | string>,
    logs?: GraphCacheResolver<WithTypename<TeamType>, Record<string, never>, Array<WithTypename<ActionLogType> | string>>,
    name?: GraphCacheResolver<WithTypename<TeamType>, Record<string, never>, Scalars['String'] | string>,
    role?: GraphCacheResolver<WithTypename<TeamType>, Record<string, never>, Scalars['String'] | string>,
    teamQuestionnaireStates?: GraphCacheResolver<WithTypename<TeamType>, Record<string, never>, Array<WithTypename<TeamQuestionnaireStateType> | string>>,
    users?: GraphCacheResolver<WithTypename<TeamType>, Record<string, never>, Array<WithTypename<RestrictedUser> | string>>
  },
  ToolDetailsType?: {
    argument?: GraphCacheResolver<WithTypename<ToolDetailsType>, Record<string, never>, Scalars['String'] | string>,
    content?: GraphCacheResolver<WithTypename<ToolDetailsType>, Record<string, never>, WithTypename<ContentType> | string>,
    id?: GraphCacheResolver<WithTypename<ToolDetailsType>, Record<string, never>, Scalars['ID'] | string>,
    tool?: GraphCacheResolver<WithTypename<ToolDetailsType>, Record<string, never>, WithTypename<ToolType> | string>,
    user?: GraphCacheResolver<WithTypename<ToolDetailsType>, Record<string, never>, WithTypename<RestrictedUser> | string>
  },
  ToolResponseType?: {
    content?: GraphCacheResolver<WithTypename<ToolResponseType>, Record<string, never>, WithTypename<ContentType> | string>,
    control?: GraphCacheResolver<WithTypename<ToolResponseType>, Record<string, never>, WithTypename<ControlType> | string>,
    id?: GraphCacheResolver<WithTypename<ToolResponseType>, Record<string, never>, Scalars['ID'] | string>,
    param?: GraphCacheResolver<WithTypename<ToolResponseType>, Record<string, never>, Scalars['String'] | string>,
    regex?: GraphCacheResolver<WithTypename<ToolResponseType>, Record<string, never>, Scalars['Boolean'] | string>,
    time?: GraphCacheResolver<WithTypename<ToolResponseType>, Record<string, never>, Scalars['Int'] | string>,
    tool?: GraphCacheResolver<WithTypename<ToolResponseType>, Record<string, never>, WithTypename<ExtendedToolType> | string>
  },
  ToolType?: {
    category?: GraphCacheResolver<WithTypename<ToolType>, Record<string, never>, Scalars['String'] | string>,
    defaultResponse?: GraphCacheResolver<WithTypename<ToolType>, Record<string, never>, Scalars['String'] | string>,
    definition?: GraphCacheResolver<WithTypename<ToolType>, Record<string, never>, WithTypename<ExerciseDefinitionType> | string>,
    hint?: GraphCacheResolver<WithTypename<ToolType>, Record<string, never>, Scalars['String'] | string>,
    id?: GraphCacheResolver<WithTypename<ToolType>, Record<string, never>, Scalars['ID'] | string>,
    name?: GraphCacheResolver<WithTypename<ToolType>, Record<string, never>, Scalars['String'] | string>,
    roles?: GraphCacheResolver<WithTypename<ToolType>, Record<string, never>, Scalars['String'] | string>,
    tooltipDescription?: GraphCacheResolver<WithTypename<ToolType>, Record<string, never>, Scalars['String'] | string>
  },
  UpdateTagAssignmentsMutation?: {
    operationDone?: GraphCacheResolver<WithTypename<UpdateTagAssignmentsMutation>, Record<string, never>, Scalars['Boolean'] | string>
  },
  UpdateTagAssignmentsType?: {
    addTags?: GraphCacheResolver<WithTypename<UpdateTagAssignmentsType>, Record<string, never>, Array<Scalars['ID'] | string>>,
    removeTags?: GraphCacheResolver<WithTypename<UpdateTagAssignmentsType>, Record<string, never>, Array<Scalars['ID'] | string>>,
    userIds?: GraphCacheResolver<WithTypename<UpdateTagAssignmentsType>, Record<string, never>, Array<Scalars['ID'] | string>>
  },
  UpdateTagMutation?: {
    updatedTag?: GraphCacheResolver<WithTypename<UpdateTagMutation>, Record<string, never>, WithTypename<TagType> | string>
  },
  UseToolMutation?: {
    actionLog?: GraphCacheResolver<WithTypename<UseToolMutation>, Record<string, never>, WithTypename<ActionLogType> | string>,
    operationDone?: GraphCacheResolver<WithTypename<UseToolMutation>, Record<string, never>, Scalars['Boolean'] | string>
  },
  UseToolType?: {
    teamId?: GraphCacheResolver<WithTypename<UseToolType>, Record<string, never>, Scalars['ID'] | string>,
    toolArgument?: GraphCacheResolver<WithTypename<UseToolType>, Record<string, never>, Scalars['String'] | string>,
    toolId?: GraphCacheResolver<WithTypename<UseToolType>, Record<string, never>, Scalars['ID'] | string>
  },
  UserType?: {
    createdExercises?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, Array<WithTypename<RestrictedExercise> | string>>,
    dateJoined?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, Scalars['DateTime'] | string>,
    definitions?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, Array<WithTypename<ExerciseDefinitionType> | string>>,
    exercises?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, Array<WithTypename<RestrictedExercise> | string>>,
    firstName?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, Scalars['String'] | string>,
    group?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, AuthGroup | string>,
    id?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, Scalars['UUID'] | string>,
    isActive?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, Scalars['Boolean'] | string>,
    isImported?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, Scalars['Boolean'] | string>,
    lastLogin?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, Scalars['DateTime'] | string>,
    lastName?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, Scalars['String'] | string>,
    tags?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, Array<WithTypename<TagType> | string>>,
    teams?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, Array<WithTypename<RestrictedTeam> | string>>,
    uploadedDefinitions?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, Array<WithTypename<ExerciseDefinitionType> | string>>,
    username?: GraphCacheResolver<WithTypename<UserType>, Record<string, never>, Scalars['String'] | string>
  }
};

export type GraphCacheOptimisticUpdaters = {
  addDefinitionAccess?: GraphCacheOptimisticMutationResolver<MutationAddDefinitionAccessArgs, Maybe<WithTypename<AddDefinitionAccessMutation>>>,
  answerQuestionnaire?: GraphCacheOptimisticMutationResolver<MutationAnswerQuestionnaireArgs, Maybe<WithTypename<AnswerQuestionnaireMutation>>>,
  assignInstructorsToExercise?: GraphCacheOptimisticMutationResolver<MutationAssignInstructorsToExerciseArgs, Maybe<WithTypename<AssignInstructorsToExercise>>>,
  assignUsersByTags?: GraphCacheOptimisticMutationResolver<MutationAssignUsersByTagsArgs, Maybe<WithTypename<AssignUsersByTags>>>,
  assignUsersEqually?: GraphCacheOptimisticMutationResolver<MutationAssignUsersEquallyArgs, Maybe<WithTypename<AssignUsersEqually>>>,
  assignUsersToTeam?: GraphCacheOptimisticMutationResolver<MutationAssignUsersToTeamArgs, Maybe<WithTypename<AssignUsersToTeamMutation>>>,
  changeUserData?: GraphCacheOptimisticMutationResolver<MutationChangeUserDataArgs, Maybe<WithTypename<ChangeUserDataMutation>>>,
  confirmAction?: GraphCacheOptimisticMutationResolver<MutationConfirmActionArgs, Maybe<WithTypename<ConfirmActionMutation>>>,
  copyUsersAssignment?: GraphCacheOptimisticMutationResolver<MutationCopyUsersAssignmentArgs, Maybe<WithTypename<CopyUsersAssignment>>>,
  createExercise?: GraphCacheOptimisticMutationResolver<MutationCreateExerciseArgs, Maybe<WithTypename<CreateExerciseMutation>>>,
  createTag?: GraphCacheOptimisticMutationResolver<MutationCreateTagArgs, Maybe<WithTypename<CreateTagMutation>>>,
  createThread?: GraphCacheOptimisticMutationResolver<MutationCreateThreadArgs, Maybe<WithTypename<CreateThreadMutation>>>,
  createUser?: GraphCacheOptimisticMutationResolver<MutationCreateUserArgs, Maybe<WithTypename<CreateUserMutation>>>,
  deleteDefinition?: GraphCacheOptimisticMutationResolver<MutationDeleteDefinitionArgs, Maybe<WithTypename<DeleteDefinitionMutation>>>,
  deleteEmailDraft?: GraphCacheOptimisticMutationResolver<MutationDeleteEmailDraftArgs, Maybe<WithTypename<MutationResult>>>,
  deleteExercise?: GraphCacheOptimisticMutationResolver<MutationDeleteExerciseArgs, Maybe<WithTypename<DeleteExerciseMutation>>>,
  deleteTags?: GraphCacheOptimisticMutationResolver<MutationDeleteTagsArgs, Maybe<WithTypename<DeleteTagsMutation>>>,
  deleteUsers?: GraphCacheOptimisticMutationResolver<MutationDeleteUsersArgs, Maybe<WithTypename<DeleteUsersMutation>>>,
  modifyMilestone?: GraphCacheOptimisticMutationResolver<MutationModifyMilestoneArgs, Maybe<WithTypename<ModifyMilestoneMutation>>>,
  moveTime?: GraphCacheOptimisticMutationResolver<MutationMoveTimeArgs, Maybe<WithTypename<MoveExerciseTimeMutation>>>,
  passwordChange?: GraphCacheOptimisticMutationResolver<MutationPasswordChangeArgs, Maybe<WithTypename<PasswordChange>>>,
  regenerateCredentials?: GraphCacheOptimisticMutationResolver<MutationRegenerateCredentialsArgs, Maybe<WithTypename<RegenerateCredentialsMutation>>>,
  reloadDefinitions?: GraphCacheOptimisticMutationResolver<Record<string, never>, Maybe<WithTypename<MutationResult>>>,
  reloadExercises?: GraphCacheOptimisticMutationResolver<Record<string, never>, Maybe<WithTypename<MutationResult>>>,
  reloadTable?: GraphCacheOptimisticMutationResolver<Record<string, never>, Maybe<WithTypename<MutationResult>>>,
  removeDefinitionAccess?: GraphCacheOptimisticMutationResolver<MutationRemoveDefinitionAccessArgs, Maybe<WithTypename<RemoveDefinitionAccessMutation>>>,
  removeInstructorsFromExercise?: GraphCacheOptimisticMutationResolver<MutationRemoveInstructorsFromExerciseArgs, Maybe<WithTypename<RemoveInstructorsFromExerciseMutation>>>,
  removeUsersFromTeam?: GraphCacheOptimisticMutationResolver<MutationRemoveUsersFromTeamArgs, Maybe<WithTypename<RemoveUsersFromTeamMutation>>>,
  reviewQuestionnaire?: GraphCacheOptimisticMutationResolver<MutationReviewQuestionnaireArgs, Maybe<WithTypename<ReviewQuestionnaireMutation>>>,
  sendCustomInject?: GraphCacheOptimisticMutationResolver<MutationSendCustomInjectArgs, Maybe<WithTypename<SendCustomInjectMutation>>>,
  sendEmail?: GraphCacheOptimisticMutationResolver<MutationSendEmailArgs, Maybe<WithTypename<SendEmailMutation>>>,
  setArchiveEmail?: GraphCacheOptimisticMutationResolver<MutationSetArchiveEmailArgs, Maybe<WithTypename<MutationResult>>>,
  setEmailDraft?: GraphCacheOptimisticMutationResolver<MutationSetEmailDraftArgs, Maybe<WithTypename<EmailDraftType>>>,
  setEmailTodo?: GraphCacheOptimisticMutationResolver<MutationSetEmailTodoArgs, Maybe<WithTypename<MutationResult>>>,
  setIsUnreadChannel?: GraphCacheOptimisticMutationResolver<MutationSetIsUnreadChannelArgs, Maybe<WithTypename<MutationResult>>>,
  setIsUnreadEmailThread?: GraphCacheOptimisticMutationResolver<MutationSetIsUnreadEmailThreadArgs, Maybe<WithTypename<MutationResult>>>,
  setTeamQuestionnaireTodo?: GraphCacheOptimisticMutationResolver<MutationSetTeamQuestionnaireTodoArgs, Maybe<WithTypename<MutationResult>>>,
  setTodoActionLog?: GraphCacheOptimisticMutationResolver<MutationSetTodoActionLogArgs, Maybe<WithTypename<MutationResult>>>,
  startExercise?: GraphCacheOptimisticMutationResolver<MutationStartExerciseArgs, Maybe<WithTypename<StartExerciseMutation>>>,
  stopExercise?: GraphCacheOptimisticMutationResolver<MutationStopExerciseArgs, Maybe<WithTypename<StopExerciseMutation>>>,
  updateTag?: GraphCacheOptimisticMutationResolver<MutationUpdateTagArgs, Maybe<WithTypename<UpdateTagMutation>>>,
  updateTagAssignments?: GraphCacheOptimisticMutationResolver<MutationUpdateTagAssignmentsArgs, Maybe<WithTypename<UpdateTagAssignmentsMutation>>>,
  useTool?: GraphCacheOptimisticMutationResolver<MutationUseToolArgs, Maybe<WithTypename<UseToolMutation>>>,
  writeReadReceipt?: GraphCacheOptimisticMutationResolver<MutationWriteReadReceiptArgs, Maybe<WithTypename<ReadReceiptType>>>,
  writeReadReceiptEmail?: GraphCacheOptimisticMutationResolver<MutationWriteReadReceiptEmailArgs, Maybe<WithTypename<EmailReceipt>>>
};

export type GraphCacheUpdaters = {
  Query?: {
    actionLog?: GraphCacheUpdateResolver<{ actionLog: WithTypename<ActionLogType> }, QueryActionLogArgs>,
    analyticsActionLogs?: GraphCacheUpdateResolver<{ analyticsActionLogs: Array<WithTypename<ActionLogType>> }, QueryAnalyticsActionLogsArgs>,
    analyticsEmailThreads?: GraphCacheUpdateResolver<{ analyticsEmailThreads: Array<WithTypename<EmailThreadType>> }, QueryAnalyticsEmailThreadsArgs>,
    analyticsMilestones?: GraphCacheUpdateResolver<{ analyticsMilestones: Array<WithTypename<MilestoneStateType>> }, QueryAnalyticsMilestonesArgs>,
    channel?: GraphCacheUpdateResolver<{ channel: WithTypename<DefinitionChannelType> }, QueryChannelArgs>,
    definition?: GraphCacheUpdateResolver<{ definition: WithTypename<DefinitionType> }, QueryDefinitionArgs>,
    definitions?: GraphCacheUpdateResolver<{ definitions: Array<WithTypename<DefinitionType>> }, Record<string, never>>,
    emailAddresses?: GraphCacheUpdateResolver<{ emailAddresses: Array<Scalars['String']> }, QueryEmailAddressesArgs>,
    emailContact?: GraphCacheUpdateResolver<{ emailContact: WithTypename<EmailParticipantType> }, QueryEmailContactArgs>,
    emailContacts?: GraphCacheUpdateResolver<{ emailContacts: Array<WithTypename<EmailParticipantType>> }, QueryEmailContactsArgs>,
    emailTemplates?: GraphCacheUpdateResolver<{ emailTemplates: Array<WithTypename<EmailTemplateType>> }, QueryEmailTemplatesArgs>,
    emailThread?: GraphCacheUpdateResolver<{ emailThread: WithTypename<EmailThreadType> }, QueryEmailThreadArgs>,
    emailThreads?: GraphCacheUpdateResolver<{ emailThreads: Array<WithTypename<EmailThreadType>> }, QueryEmailThreadsArgs>,
    exerciseChannels?: GraphCacheUpdateResolver<{ exerciseChannels: Array<WithTypename<DefinitionChannelType>> }, QueryExerciseChannelsArgs>,
    exerciseConfig?: GraphCacheUpdateResolver<{ exerciseConfig: WithTypename<GrapheneConfig> }, QueryExerciseConfigArgs>,
    exerciseId?: GraphCacheUpdateResolver<{ exerciseId: WithTypename<ExerciseType> }, QueryExerciseIdArgs>,
    exerciseLoopRunning?: GraphCacheUpdateResolver<{ exerciseLoopRunning: Scalars['Boolean'] }, QueryExerciseLoopRunningArgs>,
    exerciseQuestionnaires?: GraphCacheUpdateResolver<{ exerciseQuestionnaires: Array<WithTypename<TeamQuestionnaireStateType>> }, QueryExerciseQuestionnairesArgs>,
    exerciseTimeLeft?: GraphCacheUpdateResolver<{ exerciseTimeLeft: Scalars['Int'] }, Record<string, never>>,
    exerciseTools?: GraphCacheUpdateResolver<{ exerciseTools: Array<WithTypename<ToolType>> }, QueryExerciseToolsArgs>,
    exercises?: GraphCacheUpdateResolver<{ exercises: Array<WithTypename<ExerciseType>> }, QueryExercisesArgs>,
    extendedTeamTools?: GraphCacheUpdateResolver<{ extendedTeamTools: Array<WithTypename<ExtendedToolType>> }, QueryExtendedTeamToolsArgs>,
    fileInfo?: GraphCacheUpdateResolver<{ fileInfo: WithTypename<FileInfoType> }, QueryFileInfoArgs>,
    getEmailDraft?: GraphCacheUpdateResolver<{ getEmailDraft: Maybe<WithTypename<EmailDraftType>> }, QueryGetEmailDraftArgs>,
    getEmailDrafts?: GraphCacheUpdateResolver<{ getEmailDrafts: Maybe<Array<WithTypename<EmailDraftType>>> }, QueryGetEmailDraftsArgs>,
    injects?: GraphCacheUpdateResolver<{ injects: Array<WithTypename<DefinitionInjectType>> }, QueryInjectsArgs>,
    learningObjectives?: GraphCacheUpdateResolver<{ learningObjectives: Array<WithTypename<LearningObjectiveType>> }, QueryLearningObjectivesArgs>,
    milestones?: GraphCacheUpdateResolver<{ milestones: Array<WithTypename<MilestoneType>> }, QueryMilestonesArgs>,
    noopReceipt?: GraphCacheUpdateResolver<{ noopReceipt: Maybe<WithTypename<MutationResult>> }, Record<string, never>>,
    noopReload?: GraphCacheUpdateResolver<{ noopReload: Maybe<WithTypename<MutationResult>> }, Record<string, never>>,
    noopTodo?: GraphCacheUpdateResolver<{ noopTodo: Maybe<WithTypename<MutationResult>> }, Record<string, never>>,
    questionnaireState?: GraphCacheUpdateResolver<{ questionnaireState: WithTypename<TeamQuestionnaireStateType> }, QueryQuestionnaireStateArgs>,
    questionnaires?: GraphCacheUpdateResolver<{ questionnaires: Array<WithTypename<QuestionnaireType>> }, QueryQuestionnairesArgs>,
    tags?: GraphCacheUpdateResolver<{ tags: Array<WithTypename<TagType>> }, Record<string, never>>,
    team?: GraphCacheUpdateResolver<{ team: WithTypename<TeamType> }, QueryTeamArgs>,
    teamActionLogs?: GraphCacheUpdateResolver<{ teamActionLogs: Array<WithTypename<ActionLogType>> }, QueryTeamActionLogsArgs>,
    teamChannelLogs?: GraphCacheUpdateResolver<{ teamChannelLogs: Array<WithTypename<ActionLogType>> }, QueryTeamChannelLogsArgs>,
    teamEmailParticipant?: GraphCacheUpdateResolver<{ teamEmailParticipant: WithTypename<EmailParticipantType> }, QueryTeamEmailParticipantArgs>,
    teamLearningObjectives?: GraphCacheUpdateResolver<{ teamLearningObjectives: Array<WithTypename<TeamLearningObjectiveType>> }, QueryTeamLearningObjectivesArgs>,
    teamMilestone?: GraphCacheUpdateResolver<{ teamMilestone: WithTypename<MilestoneStateType> }, QueryTeamMilestoneArgs>,
    teamMilestones?: GraphCacheUpdateResolver<{ teamMilestones: Array<WithTypename<MilestoneStateType>> }, QueryTeamMilestonesArgs>,
    teamQuestionnaires?: GraphCacheUpdateResolver<{ teamQuestionnaires: Array<WithTypename<TeamQuestionnaireStateType>> }, QueryTeamQuestionnairesArgs>,
    teamRoles?: GraphCacheUpdateResolver<{ teamRoles: Array<Scalars['String']> }, Record<string, never>>,
    teamTools?: GraphCacheUpdateResolver<{ teamTools: Array<WithTypename<ToolType>> }, QueryTeamToolsArgs>,
    teamUploadedFiles?: GraphCacheUpdateResolver<{ teamUploadedFiles: Array<WithTypename<FileInfoType>> }, QueryTeamUploadedFilesArgs>,
    threadTemplate?: GraphCacheUpdateResolver<{ threadTemplate: WithTypename<EmailTemplateType> }, QueryThreadTemplateArgs>,
    threadTemplates?: GraphCacheUpdateResolver<{ threadTemplates: Array<WithTypename<EmailTemplateType>> }, QueryThreadTemplatesArgs>,
    user?: GraphCacheUpdateResolver<{ user: WithTypename<UserType> }, QueryUserArgs>,
    users?: GraphCacheUpdateResolver<{ users: Array<WithTypename<UserType>> }, QueryUsersArgs>,
    validateEmailAddress?: GraphCacheUpdateResolver<{ validateEmailAddress: Scalars['Boolean'] }, QueryValidateEmailAddressArgs>,
    whoAmI?: GraphCacheUpdateResolver<{ whoAmI: Maybe<WithTypename<UserType>> }, Record<string, never>>
  },
  Mutation?: {
    addDefinitionAccess?: GraphCacheUpdateResolver<{ addDefinitionAccess: Maybe<WithTypename<AddDefinitionAccessMutation>> }, MutationAddDefinitionAccessArgs>,
    answerQuestionnaire?: GraphCacheUpdateResolver<{ answerQuestionnaire: Maybe<WithTypename<AnswerQuestionnaireMutation>> }, MutationAnswerQuestionnaireArgs>,
    assignInstructorsToExercise?: GraphCacheUpdateResolver<{ assignInstructorsToExercise: Maybe<WithTypename<AssignInstructorsToExercise>> }, MutationAssignInstructorsToExerciseArgs>,
    assignUsersByTags?: GraphCacheUpdateResolver<{ assignUsersByTags: Maybe<WithTypename<AssignUsersByTags>> }, MutationAssignUsersByTagsArgs>,
    assignUsersEqually?: GraphCacheUpdateResolver<{ assignUsersEqually: Maybe<WithTypename<AssignUsersEqually>> }, MutationAssignUsersEquallyArgs>,
    assignUsersToTeam?: GraphCacheUpdateResolver<{ assignUsersToTeam: Maybe<WithTypename<AssignUsersToTeamMutation>> }, MutationAssignUsersToTeamArgs>,
    changeUserData?: GraphCacheUpdateResolver<{ changeUserData: Maybe<WithTypename<ChangeUserDataMutation>> }, MutationChangeUserDataArgs>,
    confirmAction?: GraphCacheUpdateResolver<{ confirmAction: Maybe<WithTypename<ConfirmActionMutation>> }, MutationConfirmActionArgs>,
    copyUsersAssignment?: GraphCacheUpdateResolver<{ copyUsersAssignment: Maybe<WithTypename<CopyUsersAssignment>> }, MutationCopyUsersAssignmentArgs>,
    createExercise?: GraphCacheUpdateResolver<{ createExercise: Maybe<WithTypename<CreateExerciseMutation>> }, MutationCreateExerciseArgs>,
    createTag?: GraphCacheUpdateResolver<{ createTag: Maybe<WithTypename<CreateTagMutation>> }, MutationCreateTagArgs>,
    createThread?: GraphCacheUpdateResolver<{ createThread: Maybe<WithTypename<CreateThreadMutation>> }, MutationCreateThreadArgs>,
    createUser?: GraphCacheUpdateResolver<{ createUser: Maybe<WithTypename<CreateUserMutation>> }, MutationCreateUserArgs>,
    deleteDefinition?: GraphCacheUpdateResolver<{ deleteDefinition: Maybe<WithTypename<DeleteDefinitionMutation>> }, MutationDeleteDefinitionArgs>,
    deleteEmailDraft?: GraphCacheUpdateResolver<{ deleteEmailDraft: Maybe<WithTypename<MutationResult>> }, MutationDeleteEmailDraftArgs>,
    deleteExercise?: GraphCacheUpdateResolver<{ deleteExercise: Maybe<WithTypename<DeleteExerciseMutation>> }, MutationDeleteExerciseArgs>,
    deleteTags?: GraphCacheUpdateResolver<{ deleteTags: Maybe<WithTypename<DeleteTagsMutation>> }, MutationDeleteTagsArgs>,
    deleteUsers?: GraphCacheUpdateResolver<{ deleteUsers: Maybe<WithTypename<DeleteUsersMutation>> }, MutationDeleteUsersArgs>,
    modifyMilestone?: GraphCacheUpdateResolver<{ modifyMilestone: Maybe<WithTypename<ModifyMilestoneMutation>> }, MutationModifyMilestoneArgs>,
    moveTime?: GraphCacheUpdateResolver<{ moveTime: Maybe<WithTypename<MoveExerciseTimeMutation>> }, MutationMoveTimeArgs>,
    passwordChange?: GraphCacheUpdateResolver<{ passwordChange: Maybe<WithTypename<PasswordChange>> }, MutationPasswordChangeArgs>,
    regenerateCredentials?: GraphCacheUpdateResolver<{ regenerateCredentials: Maybe<WithTypename<RegenerateCredentialsMutation>> }, MutationRegenerateCredentialsArgs>,
    reloadDefinitions?: GraphCacheUpdateResolver<{ reloadDefinitions: Maybe<WithTypename<MutationResult>> }, Record<string, never>>,
    reloadExercises?: GraphCacheUpdateResolver<{ reloadExercises: Maybe<WithTypename<MutationResult>> }, Record<string, never>>,
    reloadTable?: GraphCacheUpdateResolver<{ reloadTable: Maybe<WithTypename<MutationResult>> }, Record<string, never>>,
    removeDefinitionAccess?: GraphCacheUpdateResolver<{ removeDefinitionAccess: Maybe<WithTypename<RemoveDefinitionAccessMutation>> }, MutationRemoveDefinitionAccessArgs>,
    removeInstructorsFromExercise?: GraphCacheUpdateResolver<{ removeInstructorsFromExercise: Maybe<WithTypename<RemoveInstructorsFromExerciseMutation>> }, MutationRemoveInstructorsFromExerciseArgs>,
    removeUsersFromTeam?: GraphCacheUpdateResolver<{ removeUsersFromTeam: Maybe<WithTypename<RemoveUsersFromTeamMutation>> }, MutationRemoveUsersFromTeamArgs>,
    reviewQuestionnaire?: GraphCacheUpdateResolver<{ reviewQuestionnaire: Maybe<WithTypename<ReviewQuestionnaireMutation>> }, MutationReviewQuestionnaireArgs>,
    sendCustomInject?: GraphCacheUpdateResolver<{ sendCustomInject: Maybe<WithTypename<SendCustomInjectMutation>> }, MutationSendCustomInjectArgs>,
    sendEmail?: GraphCacheUpdateResolver<{ sendEmail: Maybe<WithTypename<SendEmailMutation>> }, MutationSendEmailArgs>,
    setArchiveEmail?: GraphCacheUpdateResolver<{ setArchiveEmail: Maybe<WithTypename<MutationResult>> }, MutationSetArchiveEmailArgs>,
    setEmailDraft?: GraphCacheUpdateResolver<{ setEmailDraft: Maybe<WithTypename<EmailDraftType>> }, MutationSetEmailDraftArgs>,
    setEmailTodo?: GraphCacheUpdateResolver<{ setEmailTodo: Maybe<WithTypename<MutationResult>> }, MutationSetEmailTodoArgs>,
    setIsUnreadChannel?: GraphCacheUpdateResolver<{ setIsUnreadChannel: Maybe<WithTypename<MutationResult>> }, MutationSetIsUnreadChannelArgs>,
    setIsUnreadEmailThread?: GraphCacheUpdateResolver<{ setIsUnreadEmailThread: Maybe<WithTypename<MutationResult>> }, MutationSetIsUnreadEmailThreadArgs>,
    setTeamQuestionnaireTodo?: GraphCacheUpdateResolver<{ setTeamQuestionnaireTodo: Maybe<WithTypename<MutationResult>> }, MutationSetTeamQuestionnaireTodoArgs>,
    setTodoActionLog?: GraphCacheUpdateResolver<{ setTodoActionLog: Maybe<WithTypename<MutationResult>> }, MutationSetTodoActionLogArgs>,
    startExercise?: GraphCacheUpdateResolver<{ startExercise: Maybe<WithTypename<StartExerciseMutation>> }, MutationStartExerciseArgs>,
    stopExercise?: GraphCacheUpdateResolver<{ stopExercise: Maybe<WithTypename<StopExerciseMutation>> }, MutationStopExerciseArgs>,
    updateTag?: GraphCacheUpdateResolver<{ updateTag: Maybe<WithTypename<UpdateTagMutation>> }, MutationUpdateTagArgs>,
    updateTagAssignments?: GraphCacheUpdateResolver<{ updateTagAssignments: Maybe<WithTypename<UpdateTagAssignmentsMutation>> }, MutationUpdateTagAssignmentsArgs>,
    useTool?: GraphCacheUpdateResolver<{ useTool: Maybe<WithTypename<UseToolMutation>> }, MutationUseToolArgs>,
    writeReadReceipt?: GraphCacheUpdateResolver<{ writeReadReceipt: Maybe<WithTypename<ReadReceiptType>> }, MutationWriteReadReceiptArgs>,
    writeReadReceiptEmail?: GraphCacheUpdateResolver<{ writeReadReceiptEmail: Maybe<WithTypename<EmailReceipt>> }, MutationWriteReadReceiptEmailArgs>
  },
  Subscription?: {
    actionLogs?: GraphCacheUpdateResolver<{ actionLogs: Maybe<WithTypename<ActionLogsSubscription>> }, SubscriptionActionLogsArgs>,
    analyticsActionLogsSubscription?: GraphCacheUpdateResolver<{ analyticsActionLogsSubscription: Maybe<WithTypename<AnalyticsActionLogsSubscription>> }, SubscriptionAnalyticsActionLogsSubscriptionArgs>,
    analyticsEmailThreadSubscription?: GraphCacheUpdateResolver<{ analyticsEmailThreadSubscription: Maybe<WithTypename<AnalyticsEmailThreadSubscription>> }, SubscriptionAnalyticsEmailThreadSubscriptionArgs>,
    analyticsMilestonesSubscription?: GraphCacheUpdateResolver<{ analyticsMilestonesSubscription: Maybe<WithTypename<AnalyticsMilestonesSubscription>> }, SubscriptionAnalyticsMilestonesSubscriptionArgs>,
    emailThreads?: GraphCacheUpdateResolver<{ emailThreads: Maybe<WithTypename<EmailThreadSubscription>> }, SubscriptionEmailThreadsArgs>,
    exerciseLoopRunning?: GraphCacheUpdateResolver<{ exerciseLoopRunning: Maybe<WithTypename<ExerciseLoopRunningSubscription>> }, SubscriptionExerciseLoopRunningArgs>,
    exercisesSubscription?: GraphCacheUpdateResolver<{ exercisesSubscription: Maybe<WithTypename<ExercisesSubscription>> }, Record<string, never>>,
    milestones?: GraphCacheUpdateResolver<{ milestones: Maybe<WithTypename<MilestonesSubscription>> }, SubscriptionMilestonesArgs>,
    teamQuestionnaireStateSubscription?: GraphCacheUpdateResolver<{ teamQuestionnaireStateSubscription: Maybe<WithTypename<TeamQuestionnaireStateSubscription>> }, SubscriptionTeamQuestionnaireStateSubscriptionArgs>
  },
  ActionLogType?: {
    channel?: GraphCacheUpdateResolver<Maybe<WithTypename<ActionLogType>>, Record<string, never>>,
    details?: GraphCacheUpdateResolver<Maybe<WithTypename<ActionLogType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<ActionLogType>>, Record<string, never>>,
    readReceipt?: GraphCacheUpdateResolver<Maybe<WithTypename<ActionLogType>>, Record<string, never>>,
    requiresAttention?: GraphCacheUpdateResolver<Maybe<WithTypename<ActionLogType>>, Record<string, never>>,
    team?: GraphCacheUpdateResolver<Maybe<WithTypename<ActionLogType>>, Record<string, never>>,
    teamId?: GraphCacheUpdateResolver<Maybe<WithTypename<ActionLogType>>, Record<string, never>>,
    timestamp?: GraphCacheUpdateResolver<Maybe<WithTypename<ActionLogType>>, Record<string, never>>,
    todo?: GraphCacheUpdateResolver<Maybe<WithTypename<ActionLogType>>, Record<string, never>>,
    type?: GraphCacheUpdateResolver<Maybe<WithTypename<ActionLogType>>, Record<string, never>>
  },
  ActionLogsSubscription?: {
    actionLog?: GraphCacheUpdateResolver<Maybe<WithTypename<ActionLogsSubscription>>, Record<string, never>>,
    eventType?: GraphCacheUpdateResolver<Maybe<WithTypename<ActionLogsSubscription>>, Record<string, never>>
  },
  AddDefinitionAccessMutation?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<AddDefinitionAccessMutation>>, Record<string, never>>
  },
  AnalyticsActionLogsSubscription?: {
    actionLog?: GraphCacheUpdateResolver<Maybe<WithTypename<AnalyticsActionLogsSubscription>>, Record<string, never>>,
    eventType?: GraphCacheUpdateResolver<Maybe<WithTypename<AnalyticsActionLogsSubscription>>, Record<string, never>>
  },
  AnalyticsEmailThreadSubscription?: {
    emailThread?: GraphCacheUpdateResolver<Maybe<WithTypename<AnalyticsEmailThreadSubscription>>, Record<string, never>>
  },
  AnalyticsMilestonesSubscription?: {
    milestones?: GraphCacheUpdateResolver<Maybe<WithTypename<AnalyticsMilestonesSubscription>>, Record<string, never>>
  },
  AnswerQuestionnaireMutation?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<AnswerQuestionnaireMutation>>, Record<string, never>>
  },
  AnswerType?: {
    questionId?: GraphCacheUpdateResolver<Maybe<WithTypename<AnswerType>>, Record<string, never>>,
    value?: GraphCacheUpdateResolver<Maybe<WithTypename<AnswerType>>, Record<string, never>>
  },
  AssignInstructorsToExercise?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<AssignInstructorsToExercise>>, Record<string, never>>
  },
  AssignUsersByTags?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<AssignUsersByTags>>, Record<string, never>>
  },
  AssignUsersEqually?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<AssignUsersEqually>>, Record<string, never>>
  },
  AssignUsersToTeamMutation?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<AssignUsersToTeamMutation>>, Record<string, never>>
  },
  ChangeUserDataMutation?: {
    user?: GraphCacheUpdateResolver<Maybe<WithTypename<ChangeUserDataMutation>>, Record<string, never>>
  },
  ChangeUserType?: {
    active?: GraphCacheUpdateResolver<Maybe<WithTypename<ChangeUserType>>, Record<string, never>>,
    group?: GraphCacheUpdateResolver<Maybe<WithTypename<ChangeUserType>>, Record<string, never>>,
    userId?: GraphCacheUpdateResolver<Maybe<WithTypename<ChangeUserType>>, Record<string, never>>
  },
  ChannelReceipt?: {
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<ChannelReceipt>>, Record<string, never>>,
    isUnread?: GraphCacheUpdateResolver<Maybe<WithTypename<ChannelReceipt>>, Record<string, never>>,
    teamId?: GraphCacheUpdateResolver<Maybe<WithTypename<ChannelReceipt>>, Record<string, never>>
  },
  ConfigOverrideType?: {
    customEmailSuffix?: GraphCacheUpdateResolver<Maybe<WithTypename<ConfigOverrideType>>, Record<string, never>>,
    customTeamNames?: GraphCacheUpdateResolver<Maybe<WithTypename<ConfigOverrideType>>, Record<string, never>>,
    emailBetweenTeams?: GraphCacheUpdateResolver<Maybe<WithTypename<ConfigOverrideType>>, Record<string, never>>,
    exerciseDuration?: GraphCacheUpdateResolver<Maybe<WithTypename<ConfigOverrideType>>, Record<string, never>>,
    showExerciseTime?: GraphCacheUpdateResolver<Maybe<WithTypename<ConfigOverrideType>>, Record<string, never>>
  },
  ConfirmActionMutation?: {
    actionLog?: GraphCacheUpdateResolver<Maybe<WithTypename<ConfirmActionMutation>>, Record<string, never>>
  },
  ConfirmationType?: {
    control?: GraphCacheUpdateResolver<Maybe<WithTypename<ConfirmationType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<ConfirmationType>>, Record<string, never>>,
    text?: GraphCacheUpdateResolver<Maybe<WithTypename<ConfirmationType>>, Record<string, never>>
  },
  ContentType?: {
    fileInfo?: GraphCacheUpdateResolver<Maybe<WithTypename<ContentType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<ContentType>>, Record<string, never>>,
    raw?: GraphCacheUpdateResolver<Maybe<WithTypename<ContentType>>, Record<string, never>>,
    rendered?: GraphCacheUpdateResolver<Maybe<WithTypename<ContentType>>, Record<string, never>>
  },
  ControlType?: {
    activateMilestone?: GraphCacheUpdateResolver<Maybe<WithTypename<ControlType>>, Record<string, never>>,
    deactivateMilestone?: GraphCacheUpdateResolver<Maybe<WithTypename<ControlType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<ControlType>>, Record<string, never>>,
    milestoneCondition?: GraphCacheUpdateResolver<Maybe<WithTypename<ControlType>>, Record<string, never>>,
    roles?: GraphCacheUpdateResolver<Maybe<WithTypename<ControlType>>, Record<string, never>>
  },
  ControlsMapType?: {
    choice?: GraphCacheUpdateResolver<Maybe<WithTypename<ControlsMapType>>, Record<string, never>>,
    control?: GraphCacheUpdateResolver<Maybe<WithTypename<ControlsMapType>>, Record<string, never>>
  },
  CopyUsersAssignment?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<CopyUsersAssignment>>, Record<string, never>>
  },
  CreateExerciseMutation?: {
    exercise?: GraphCacheUpdateResolver<Maybe<WithTypename<CreateExerciseMutation>>, Record<string, never>>
  },
  CreateExerciseType?: {
    configOverride?: GraphCacheUpdateResolver<Maybe<WithTypename<CreateExerciseType>>, Record<string, never>>,
    definitionId?: GraphCacheUpdateResolver<Maybe<WithTypename<CreateExerciseType>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<CreateExerciseType>>, Record<string, never>>,
    teamCount?: GraphCacheUpdateResolver<Maybe<WithTypename<CreateExerciseType>>, Record<string, never>>
  },
  CreateTagMutation?: {
    newTag?: GraphCacheUpdateResolver<Maybe<WithTypename<CreateTagMutation>>, Record<string, never>>
  },
  CreateThreadMutation?: {
    thread?: GraphCacheUpdateResolver<Maybe<WithTypename<CreateThreadMutation>>, Record<string, never>>
  },
  CreateUserMutation?: {
    newUser?: GraphCacheUpdateResolver<Maybe<WithTypename<CreateUserMutation>>, Record<string, never>>
  },
  CreateUserType?: {
    email?: GraphCacheUpdateResolver<Maybe<WithTypename<CreateUserType>>, Record<string, never>>,
    firstName?: GraphCacheUpdateResolver<Maybe<WithTypename<CreateUserType>>, Record<string, never>>,
    group?: GraphCacheUpdateResolver<Maybe<WithTypename<CreateUserType>>, Record<string, never>>,
    lastName?: GraphCacheUpdateResolver<Maybe<WithTypename<CreateUserType>>, Record<string, never>>,
    tags?: GraphCacheUpdateResolver<Maybe<WithTypename<CreateUserType>>, Record<string, never>>
  },
  CustomInjectDetailsType?: {
    content?: GraphCacheUpdateResolver<Maybe<WithTypename<CustomInjectDetailsType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<CustomInjectDetailsType>>, Record<string, never>>,
    overlay?: GraphCacheUpdateResolver<Maybe<WithTypename<CustomInjectDetailsType>>, Record<string, never>>,
    user?: GraphCacheUpdateResolver<Maybe<WithTypename<CustomInjectDetailsType>>, Record<string, never>>
  },
  CustomInjectType?: {
    channelId?: GraphCacheUpdateResolver<Maybe<WithTypename<CustomInjectType>>, Record<string, never>>,
    content?: GraphCacheUpdateResolver<Maybe<WithTypename<CustomInjectType>>, Record<string, never>>,
    exerciseId?: GraphCacheUpdateResolver<Maybe<WithTypename<CustomInjectType>>, Record<string, never>>,
    fileId?: GraphCacheUpdateResolver<Maybe<WithTypename<CustomInjectType>>, Record<string, never>>,
    overlay?: GraphCacheUpdateResolver<Maybe<WithTypename<CustomInjectType>>, Record<string, never>>,
    teamIds?: GraphCacheUpdateResolver<Maybe<WithTypename<CustomInjectType>>, Record<string, never>>
  },
  DefinitionChannelType?: {
    definition?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionChannelType>>, Record<string, never>>,
    description?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionChannelType>>, Record<string, never>>,
    displayName?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionChannelType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionChannelType>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionChannelType>>, Record<string, never>>,
    readReceipt?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionChannelType>>, Record<string, never>>,
    type?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionChannelType>>, Record<string, never>>
  },
  DefinitionInjectType?: {
    delay?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionInjectType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionInjectType>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionInjectType>>, Record<string, never>>,
    organization?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionInjectType>>, Record<string, never>>,
    target?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionInjectType>>, Record<string, never>>,
    time?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionInjectType>>, Record<string, never>>,
    type?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionInjectType>>, Record<string, never>>
  },
  DefinitionRoleType?: {
    definition?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionRoleType>>, Record<string, never>>,
    description?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionRoleType>>, Record<string, never>>,
    displayName?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionRoleType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionRoleType>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionRoleType>>, Record<string, never>>
  },
  DefinitionType?: {
    addresses?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    channels?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    description?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    exercises?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    files?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    injects?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    learningObjectives?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    maintainers?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    prerequisites?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    questionnaires?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    roles?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    targetAudience?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    timestampCreated?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    tools?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    uploadedBy?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>,
    version?: GraphCacheUpdateResolver<Maybe<WithTypename<DefinitionType>>, Record<string, never>>
  },
  DeleteDefinitionMutation?: {
    definitionId?: GraphCacheUpdateResolver<Maybe<WithTypename<DeleteDefinitionMutation>>, Record<string, never>>,
    exerciseIds?: GraphCacheUpdateResolver<Maybe<WithTypename<DeleteDefinitionMutation>>, Record<string, never>>,
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<DeleteDefinitionMutation>>, Record<string, never>>,
    teamIds?: GraphCacheUpdateResolver<Maybe<WithTypename<DeleteDefinitionMutation>>, Record<string, never>>
  },
  DeleteExerciseMutation?: {
    exerciseId?: GraphCacheUpdateResolver<Maybe<WithTypename<DeleteExerciseMutation>>, Record<string, never>>,
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<DeleteExerciseMutation>>, Record<string, never>>,
    teamIds?: GraphCacheUpdateResolver<Maybe<WithTypename<DeleteExerciseMutation>>, Record<string, never>>
  },
  DeleteTagsMutation?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<DeleteTagsMutation>>, Record<string, never>>,
    tagIds?: GraphCacheUpdateResolver<Maybe<WithTypename<DeleteTagsMutation>>, Record<string, never>>
  },
  DeleteUsersMutation?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<DeleteUsersMutation>>, Record<string, never>>,
    userIds?: GraphCacheUpdateResolver<Maybe<WithTypename<DeleteUsersMutation>>, Record<string, never>>
  },
  EmailAddressType?: {
    address?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailAddressType>>, Record<string, never>>,
    control?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailAddressType>>, Record<string, never>>,
    definition?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailAddressType>>, Record<string, never>>,
    description?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailAddressType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailAddressType>>, Record<string, never>>,
    organization?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailAddressType>>, Record<string, never>>,
    teamVisible?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailAddressType>>, Record<string, never>>,
    templates?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailAddressType>>, Record<string, never>>
  },
  EmailDraftType?: {
    activateMilestone?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailDraftType>>, Record<string, never>>,
    content?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailDraftType>>, Record<string, never>>,
    deactivateMilestone?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailDraftType>>, Record<string, never>>,
    emailThreadId?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailDraftType>>, Record<string, never>>,
    fileId?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailDraftType>>, Record<string, never>>,
    instructor?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailDraftType>>, Record<string, never>>,
    selectedContacts?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailDraftType>>, Record<string, never>>,
    senderAddress?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailDraftType>>, Record<string, never>>,
    subject?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailDraftType>>, Record<string, never>>,
    teamId?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailDraftType>>, Record<string, never>>,
    templateId?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailDraftType>>, Record<string, never>>
  },
  EmailParticipantType?: {
    address?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailParticipantType>>, Record<string, never>>,
    definitionAddress?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailParticipantType>>, Record<string, never>>,
    emails?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailParticipantType>>, Record<string, never>>,
    exercise?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailParticipantType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailParticipantType>>, Record<string, never>>,
    team?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailParticipantType>>, Record<string, never>>,
    threads?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailParticipantType>>, Record<string, never>>
  },
  EmailReceipt?: {
    emailId?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailReceipt>>, Record<string, never>>,
    readReceipt?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailReceipt>>, Record<string, never>>
  },
  EmailTemplateType?: {
    content?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailTemplateType>>, Record<string, never>>,
    context?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailTemplateType>>, Record<string, never>>,
    control?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailTemplateType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailTemplateType>>, Record<string, never>>,
    sender?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailTemplateType>>, Record<string, never>>,
    subject?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailTemplateType>>, Record<string, never>>
  },
  EmailThreadReceipt?: {
    isUnread?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailThreadReceipt>>, Record<string, never>>,
    teamId?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailThreadReceipt>>, Record<string, never>>,
    threadId?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailThreadReceipt>>, Record<string, never>>
  },
  EmailThreadSubscription?: {
    emailThread?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailThreadSubscription>>, Record<string, never>>
  },
  EmailThreadType?: {
    archived?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailThreadType>>, Record<string, never>>,
    emails?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailThreadType>>, Record<string, never>>,
    exercise?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailThreadType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailThreadType>>, Record<string, never>>,
    lastEmail?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailThreadType>>, Record<string, never>>,
    participants?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailThreadType>>, Record<string, never>>,
    readReceipt?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailThreadType>>, Record<string, never>>,
    subject?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailThreadType>>, Record<string, never>>,
    timestamp?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailThreadType>>, Record<string, never>>
  },
  EmailType?: {
    content?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailType>>, Record<string, never>>,
    overlay?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailType>>, Record<string, never>>,
    readReceipt?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailType>>, Record<string, never>>,
    sender?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailType>>, Record<string, never>>,
    thread?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailType>>, Record<string, never>>,
    timestamp?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailType>>, Record<string, never>>,
    todo?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailType>>, Record<string, never>>,
    user?: GraphCacheUpdateResolver<Maybe<WithTypename<EmailType>>, Record<string, never>>
  },
  ExerciseDefinitionType?: {
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseDefinitionType>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseDefinitionType>>, Record<string, never>>
  },
  ExerciseLoopRunningSubscription?: {
    exerciseLoopRunning?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseLoopRunningSubscription>>, Record<string, never>>
  },
  ExerciseType?: {
    createdBy?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseType>>, Record<string, never>>,
    definition?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseType>>, Record<string, never>>,
    elapsedS?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseType>>, Record<string, never>>,
    emailParticipants?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseType>>, Record<string, never>>,
    exerciseStart?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseType>>, Record<string, never>>,
    finished?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseType>>, Record<string, never>>,
    instructors?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseType>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseType>>, Record<string, never>>,
    running?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseType>>, Record<string, never>>,
    teams?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseType>>, Record<string, never>>,
    threads?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseType>>, Record<string, never>>,
    timestampCreated?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseType>>, Record<string, never>>,
    uuid?: GraphCacheUpdateResolver<Maybe<WithTypename<ExerciseType>>, Record<string, never>>
  },
  ExercisesSubscription?: {
    eventType?: GraphCacheUpdateResolver<Maybe<WithTypename<ExercisesSubscription>>, Record<string, never>>,
    exercise?: GraphCacheUpdateResolver<Maybe<WithTypename<ExercisesSubscription>>, Record<string, never>>
  },
  ExtendedToolType?: {
    category?: GraphCacheUpdateResolver<Maybe<WithTypename<ExtendedToolType>>, Record<string, never>>,
    defaultResponse?: GraphCacheUpdateResolver<Maybe<WithTypename<ExtendedToolType>>, Record<string, never>>,
    definition?: GraphCacheUpdateResolver<Maybe<WithTypename<ExtendedToolType>>, Record<string, never>>,
    hint?: GraphCacheUpdateResolver<Maybe<WithTypename<ExtendedToolType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<ExtendedToolType>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<ExtendedToolType>>, Record<string, never>>,
    responses?: GraphCacheUpdateResolver<Maybe<WithTypename<ExtendedToolType>>, Record<string, never>>,
    roles?: GraphCacheUpdateResolver<Maybe<WithTypename<ExtendedToolType>>, Record<string, never>>,
    tooltipDescription?: GraphCacheUpdateResolver<Maybe<WithTypename<ExtendedToolType>>, Record<string, never>>
  },
  FileInfoType?: {
    definition?: GraphCacheUpdateResolver<Maybe<WithTypename<FileInfoType>>, Record<string, never>>,
    fileName?: GraphCacheUpdateResolver<Maybe<WithTypename<FileInfoType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<FileInfoType>>, Record<string, never>>
  },
  FilterUsersType?: {
    active?: GraphCacheUpdateResolver<Maybe<WithTypename<FilterUsersType>>, Record<string, never>>,
    firstName?: GraphCacheUpdateResolver<Maybe<WithTypename<FilterUsersType>>, Record<string, never>>,
    groups?: GraphCacheUpdateResolver<Maybe<WithTypename<FilterUsersType>>, Record<string, never>>,
    imported?: GraphCacheUpdateResolver<Maybe<WithTypename<FilterUsersType>>, Record<string, never>>,
    lastName?: GraphCacheUpdateResolver<Maybe<WithTypename<FilterUsersType>>, Record<string, never>>,
    limit?: GraphCacheUpdateResolver<Maybe<WithTypename<FilterUsersType>>, Record<string, never>>,
    skip?: GraphCacheUpdateResolver<Maybe<WithTypename<FilterUsersType>>, Record<string, never>>,
    tags?: GraphCacheUpdateResolver<Maybe<WithTypename<FilterUsersType>>, Record<string, never>>,
    username?: GraphCacheUpdateResolver<Maybe<WithTypename<FilterUsersType>>, Record<string, never>>
  },
  FreeFormQuestionDetailsType?: {
    definition?: GraphCacheUpdateResolver<Maybe<WithTypename<FreeFormQuestionDetailsType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<FreeFormQuestionDetailsType>>, Record<string, never>>,
    multiline?: GraphCacheUpdateResolver<Maybe<WithTypename<FreeFormQuestionDetailsType>>, Record<string, never>>,
    relatedMilestones?: GraphCacheUpdateResolver<Maybe<WithTypename<FreeFormQuestionDetailsType>>, Record<string, never>>
  },
  GrapheneConfig?: {
    customEmailSuffix?: GraphCacheUpdateResolver<Maybe<WithTypename<GrapheneConfig>>, Record<string, never>>,
    emailBetweenTeams?: GraphCacheUpdateResolver<Maybe<WithTypename<GrapheneConfig>>, Record<string, never>>,
    enableRoles?: GraphCacheUpdateResolver<Maybe<WithTypename<GrapheneConfig>>, Record<string, never>>,
    exerciseDuration?: GraphCacheUpdateResolver<Maybe<WithTypename<GrapheneConfig>>, Record<string, never>>,
    showExerciseTime?: GraphCacheUpdateResolver<Maybe<WithTypename<GrapheneConfig>>, Record<string, never>>
  },
  InjectDetailsType?: {
    confirmation?: GraphCacheUpdateResolver<Maybe<WithTypename<InjectDetailsType>>, Record<string, never>>,
    confirmed?: GraphCacheUpdateResolver<Maybe<WithTypename<InjectDetailsType>>, Record<string, never>>,
    confirmedBy?: GraphCacheUpdateResolver<Maybe<WithTypename<InjectDetailsType>>, Record<string, never>>,
    content?: GraphCacheUpdateResolver<Maybe<WithTypename<InjectDetailsType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<InjectDetailsType>>, Record<string, never>>,
    inject?: GraphCacheUpdateResolver<Maybe<WithTypename<InjectDetailsType>>, Record<string, never>>,
    overlay?: GraphCacheUpdateResolver<Maybe<WithTypename<InjectDetailsType>>, Record<string, never>>,
    timestampConfirmed?: GraphCacheUpdateResolver<Maybe<WithTypename<InjectDetailsType>>, Record<string, never>>
  },
  LearningActivityType?: {
    description?: GraphCacheUpdateResolver<Maybe<WithTypename<LearningActivityType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<LearningActivityType>>, Record<string, never>>,
    milestones?: GraphCacheUpdateResolver<Maybe<WithTypename<LearningActivityType>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<LearningActivityType>>, Record<string, never>>,
    objective?: GraphCacheUpdateResolver<Maybe<WithTypename<LearningActivityType>>, Record<string, never>>,
    tags?: GraphCacheUpdateResolver<Maybe<WithTypename<LearningActivityType>>, Record<string, never>>
  },
  LearningObjectiveType?: {
    activities?: GraphCacheUpdateResolver<Maybe<WithTypename<LearningObjectiveType>>, Record<string, never>>,
    definition?: GraphCacheUpdateResolver<Maybe<WithTypename<LearningObjectiveType>>, Record<string, never>>,
    description?: GraphCacheUpdateResolver<Maybe<WithTypename<LearningObjectiveType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<LearningObjectiveType>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<LearningObjectiveType>>, Record<string, never>>,
    order?: GraphCacheUpdateResolver<Maybe<WithTypename<LearningObjectiveType>>, Record<string, never>>,
    tags?: GraphCacheUpdateResolver<Maybe<WithTypename<LearningObjectiveType>>, Record<string, never>>
  },
  MilestoneStateHistoryType?: {
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneStateHistoryType>>, Record<string, never>>,
    reached?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneStateHistoryType>>, Record<string, never>>,
    timestampFrom?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneStateHistoryType>>, Record<string, never>>
  },
  MilestoneStateType?: {
    activity?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneStateType>>, Record<string, never>>,
    history?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneStateType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneStateType>>, Record<string, never>>,
    milestone?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneStateType>>, Record<string, never>>,
    reached?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneStateType>>, Record<string, never>>,
    teamIds?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneStateType>>, Record<string, never>>,
    timestampReached?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneStateType>>, Record<string, never>>
  },
  MilestoneType?: {
    activity?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneType>>, Record<string, never>>,
    description?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneType>>, Record<string, never>>,
    displayName?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneType>>, Record<string, never>>,
    fileNames?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneType>>, Record<string, never>>,
    final?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneType>>, Record<string, never>>,
    initialState?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneType>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneType>>, Record<string, never>>,
    roles?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneType>>, Record<string, never>>,
    tags?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneType>>, Record<string, never>>,
    teamVisible?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestoneType>>, Record<string, never>>
  },
  MilestonesSubscription?: {
    milestones?: GraphCacheUpdateResolver<Maybe<WithTypename<MilestonesSubscription>>, Record<string, never>>
  },
  ModifyMilestoneMutation?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<ModifyMilestoneMutation>>, Record<string, never>>
  },
  MoveExerciseTimeMutation?: {
    exercise?: GraphCacheUpdateResolver<Maybe<WithTypename<MoveExerciseTimeMutation>>, Record<string, never>>
  },
  MutationResult?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<MutationResult>>, Record<string, never>>
  },
  OverlayType?: {
    duration?: GraphCacheUpdateResolver<Maybe<WithTypename<OverlayType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<OverlayType>>, Record<string, never>>
  },
  PasswordChange?: {
    passwordChanged?: GraphCacheUpdateResolver<Maybe<WithTypename<PasswordChange>>, Record<string, never>>
  },
  QuestionRelatedMilestonesType?: {
    milestones?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionRelatedMilestonesType>>, Record<string, never>>,
    questionId?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionRelatedMilestonesType>>, Record<string, never>>
  },
  QuestionType?: {
    content?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionType>>, Record<string, never>>,
    details?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionType>>, Record<string, never>>,
    questionnaire?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionType>>, Record<string, never>>,
    type?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionType>>, Record<string, never>>
  },
  QuestionnaireAnswerType?: {
    answer?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireAnswerType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireAnswerType>>, Record<string, never>>,
    isCorrect?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireAnswerType>>, Record<string, never>>,
    question?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireAnswerType>>, Record<string, never>>,
    teamQuestionnaireState?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireAnswerType>>, Record<string, never>>
  },
  QuestionnaireInputType?: {
    answers?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireInputType>>, Record<string, never>>,
    questionnaireId?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireInputType>>, Record<string, never>>,
    teamId?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireInputType>>, Record<string, never>>
  },
  QuestionnaireReviewInputType?: {
    activateMilestones?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireReviewInputType>>, Record<string, never>>,
    deactivateMilestones?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireReviewInputType>>, Record<string, never>>,
    questionnaireId?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireReviewInputType>>, Record<string, never>>,
    teamId?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireReviewInputType>>, Record<string, never>>
  },
  QuestionnaireType?: {
    content?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireType>>, Record<string, never>>,
    control?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireType>>, Record<string, never>>,
    definition?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireType>>, Record<string, never>>,
    overlay?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireType>>, Record<string, never>>,
    questions?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireType>>, Record<string, never>>,
    teamQuestionnaireStates?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireType>>, Record<string, never>>,
    time?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireType>>, Record<string, never>>,
    title?: GraphCacheUpdateResolver<Maybe<WithTypename<QuestionnaireType>>, Record<string, never>>
  },
  RadioQuestionDetailsType?: {
    controls?: GraphCacheUpdateResolver<Maybe<WithTypename<RadioQuestionDetailsType>>, Record<string, never>>,
    correct?: GraphCacheUpdateResolver<Maybe<WithTypename<RadioQuestionDetailsType>>, Record<string, never>>,
    definition?: GraphCacheUpdateResolver<Maybe<WithTypename<RadioQuestionDetailsType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<RadioQuestionDetailsType>>, Record<string, never>>,
    labels?: GraphCacheUpdateResolver<Maybe<WithTypename<RadioQuestionDetailsType>>, Record<string, never>>,
    max?: GraphCacheUpdateResolver<Maybe<WithTypename<RadioQuestionDetailsType>>, Record<string, never>>
  },
  ReadReceiptType?: {
    actionLogId?: GraphCacheUpdateResolver<Maybe<WithTypename<ReadReceiptType>>, Record<string, never>>,
    readReceipt?: GraphCacheUpdateResolver<Maybe<WithTypename<ReadReceiptType>>, Record<string, never>>
  },
  RegenerateCredentialsMutation?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<RegenerateCredentialsMutation>>, Record<string, never>>
  },
  RemoveDefinitionAccessMutation?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<RemoveDefinitionAccessMutation>>, Record<string, never>>
  },
  RemoveInstructorsFromExerciseMutation?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<RemoveInstructorsFromExerciseMutation>>, Record<string, never>>
  },
  RemoveUsersFromTeamMutation?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<RemoveUsersFromTeamMutation>>, Record<string, never>>
  },
  RestrictedExercise?: {
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedExercise>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedExercise>>, Record<string, never>>,
    uuid?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedExercise>>, Record<string, never>>
  },
  RestrictedTeam?: {
    emailAddress?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedTeam>>, Record<string, never>>,
    exercise?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedTeam>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedTeam>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedTeam>>, Record<string, never>>,
    role?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedTeam>>, Record<string, never>>
  },
  RestrictedUser?: {
    dateJoined?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedUser>>, Record<string, never>>,
    firstName?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedUser>>, Record<string, never>>,
    group?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedUser>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedUser>>, Record<string, never>>,
    isActive?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedUser>>, Record<string, never>>,
    isImported?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedUser>>, Record<string, never>>,
    lastLogin?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedUser>>, Record<string, never>>,
    lastName?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedUser>>, Record<string, never>>,
    tags?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedUser>>, Record<string, never>>,
    username?: GraphCacheUpdateResolver<Maybe<WithTypename<RestrictedUser>>, Record<string, never>>
  },
  ReviewQuestionnaireMutation?: {
    updatedState?: GraphCacheUpdateResolver<Maybe<WithTypename<ReviewQuestionnaireMutation>>, Record<string, never>>
  },
  SendCustomInjectMutation?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<SendCustomInjectMutation>>, Record<string, never>>
  },
  SendEmailMutation?: {
    email?: GraphCacheUpdateResolver<Maybe<WithTypename<SendEmailMutation>>, Record<string, never>>,
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<SendEmailMutation>>, Record<string, never>>
  },
  SendEmailType?: {
    activateMilestone?: GraphCacheUpdateResolver<Maybe<WithTypename<SendEmailType>>, Record<string, never>>,
    content?: GraphCacheUpdateResolver<Maybe<WithTypename<SendEmailType>>, Record<string, never>>,
    deactivateMilestone?: GraphCacheUpdateResolver<Maybe<WithTypename<SendEmailType>>, Record<string, never>>,
    fileId?: GraphCacheUpdateResolver<Maybe<WithTypename<SendEmailType>>, Record<string, never>>,
    senderAddress?: GraphCacheUpdateResolver<Maybe<WithTypename<SendEmailType>>, Record<string, never>>,
    threadId?: GraphCacheUpdateResolver<Maybe<WithTypename<SendEmailType>>, Record<string, never>>
  },
  StartExerciseMutation?: {
    exercise?: GraphCacheUpdateResolver<Maybe<WithTypename<StartExerciseMutation>>, Record<string, never>>
  },
  StopExerciseMutation?: {
    exercise?: GraphCacheUpdateResolver<Maybe<WithTypename<StopExerciseMutation>>, Record<string, never>>
  },
  TagType?: {
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<TagType>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<TagType>>, Record<string, never>>
  },
  TeamLearningActivityType?: {
    activity?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamLearningActivityType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamLearningActivityType>>, Record<string, never>>,
    milestoneStates?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamLearningActivityType>>, Record<string, never>>,
    reached?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamLearningActivityType>>, Record<string, never>>,
    teamObjective?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamLearningActivityType>>, Record<string, never>>
  },
  TeamLearningObjectiveType?: {
    activities?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamLearningObjectiveType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamLearningObjectiveType>>, Record<string, never>>,
    objective?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamLearningObjectiveType>>, Record<string, never>>,
    reached?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamLearningObjectiveType>>, Record<string, never>>
  },
  TeamQuestionnaireStateSubscription?: {
    teamQuestionnaireState?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamQuestionnaireStateSubscription>>, Record<string, never>>
  },
  TeamQuestionnaireStateType?: {
    answers?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamQuestionnaireStateType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamQuestionnaireStateType>>, Record<string, never>>,
    questionnaire?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamQuestionnaireStateType>>, Record<string, never>>,
    relatedMilestones?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamQuestionnaireStateType>>, Record<string, never>>,
    reviewedBy?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamQuestionnaireStateType>>, Record<string, never>>,
    status?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamQuestionnaireStateType>>, Record<string, never>>,
    team?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamQuestionnaireStateType>>, Record<string, never>>,
    timestampAnswered?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamQuestionnaireStateType>>, Record<string, never>>,
    timestampReviewed?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamQuestionnaireStateType>>, Record<string, never>>,
    timestampSent?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamQuestionnaireStateType>>, Record<string, never>>,
    todo?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamQuestionnaireStateType>>, Record<string, never>>
  },
  TeamType?: {
    emailAddress?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamType>>, Record<string, never>>,
    exercise?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamType>>, Record<string, never>>,
    finishTime?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamType>>, Record<string, never>>,
    logs?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamType>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamType>>, Record<string, never>>,
    role?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamType>>, Record<string, never>>,
    teamQuestionnaireStates?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamType>>, Record<string, never>>,
    users?: GraphCacheUpdateResolver<Maybe<WithTypename<TeamType>>, Record<string, never>>
  },
  ToolDetailsType?: {
    argument?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolDetailsType>>, Record<string, never>>,
    content?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolDetailsType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolDetailsType>>, Record<string, never>>,
    tool?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolDetailsType>>, Record<string, never>>,
    user?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolDetailsType>>, Record<string, never>>
  },
  ToolResponseType?: {
    content?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolResponseType>>, Record<string, never>>,
    control?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolResponseType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolResponseType>>, Record<string, never>>,
    param?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolResponseType>>, Record<string, never>>,
    regex?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolResponseType>>, Record<string, never>>,
    time?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolResponseType>>, Record<string, never>>,
    tool?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolResponseType>>, Record<string, never>>
  },
  ToolType?: {
    category?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolType>>, Record<string, never>>,
    defaultResponse?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolType>>, Record<string, never>>,
    definition?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolType>>, Record<string, never>>,
    hint?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolType>>, Record<string, never>>,
    name?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolType>>, Record<string, never>>,
    roles?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolType>>, Record<string, never>>,
    tooltipDescription?: GraphCacheUpdateResolver<Maybe<WithTypename<ToolType>>, Record<string, never>>
  },
  UpdateTagAssignmentsMutation?: {
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<UpdateTagAssignmentsMutation>>, Record<string, never>>
  },
  UpdateTagAssignmentsType?: {
    addTags?: GraphCacheUpdateResolver<Maybe<WithTypename<UpdateTagAssignmentsType>>, Record<string, never>>,
    removeTags?: GraphCacheUpdateResolver<Maybe<WithTypename<UpdateTagAssignmentsType>>, Record<string, never>>,
    userIds?: GraphCacheUpdateResolver<Maybe<WithTypename<UpdateTagAssignmentsType>>, Record<string, never>>
  },
  UpdateTagMutation?: {
    updatedTag?: GraphCacheUpdateResolver<Maybe<WithTypename<UpdateTagMutation>>, Record<string, never>>
  },
  UseToolMutation?: {
    actionLog?: GraphCacheUpdateResolver<Maybe<WithTypename<UseToolMutation>>, Record<string, never>>,
    operationDone?: GraphCacheUpdateResolver<Maybe<WithTypename<UseToolMutation>>, Record<string, never>>
  },
  UseToolType?: {
    teamId?: GraphCacheUpdateResolver<Maybe<WithTypename<UseToolType>>, Record<string, never>>,
    toolArgument?: GraphCacheUpdateResolver<Maybe<WithTypename<UseToolType>>, Record<string, never>>,
    toolId?: GraphCacheUpdateResolver<Maybe<WithTypename<UseToolType>>, Record<string, never>>
  },
  UserType?: {
    createdExercises?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>,
    dateJoined?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>,
    definitions?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>,
    exercises?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>,
    firstName?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>,
    group?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>,
    id?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>,
    isActive?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>,
    isImported?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>,
    lastLogin?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>,
    lastName?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>,
    tags?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>,
    teams?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>,
    uploadedDefinitions?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>,
    username?: GraphCacheUpdateResolver<Maybe<WithTypename<UserType>>, Record<string, never>>
  },
};

export type GraphCacheConfig = Parameters<typeof offlineExchange>[0] & {
  updates?: GraphCacheUpdaters,
  keys?: GraphCacheKeysConfig,
  optimistic?: GraphCacheOptimisticUpdaters,
  resolvers?: GraphCacheResolvers,
};