import { graphql } from './graphql'

import * as Fragments from './fragments'

export const exerciseActionLogs = graphql(
  `
    subscription exerciseActionLogs($exerciseId: ID!) {
      analyticsActionLogsSubscription(exerciseId: $exerciseId) {
        actionLog {
          ...ActionLog
        }
        eventType
      }
    }
  `,
  [Fragments.ActionLog]
)

export const exerciseEmailThreads = graphql(
  `
    subscription exerciseEmailThreads($exerciseId: ID!) {
      analyticsEmailThreadSubscription(exerciseId: $exerciseId) {
        emailThread {
          ...EmailThread
        }
      }
    }
  `,
  [Fragments.EmailThread]
)

export const exerciseMilestones = graphql(
  `
    subscription exerciseMilestones($exerciseId: ID!) {
      analyticsMilestonesSubscription(exerciseId: $exerciseId) {
        milestones {
          activity {
            id
            teamObjective {
              id
            }
          }
          ...MilestoneState
        }
      }
    }
  `,
  [Fragments.MilestoneState]
)

export const EmailThreadsSubscription = graphql(
  `
    subscription EmailThreadsSubscription($teamId: ID!) {
      emailThreads(teamId: $teamId) {
        emailThread {
          ...EmailThread
        }
      }
    }
  `,
  [Fragments.EmailThread]
)

export const exerciseLoopRunning = graphql(
  `
    subscription exerciseLoopRunning($exerciseId: ID!) {
      exerciseLoopRunning(exerciseId: $exerciseId) {
        exerciseLoopRunning
      }
    }
  `,
  []
)

export const exercises = graphql(
  `
    subscription exercises {
      exercisesSubscription {
        exercise {
          ...Exercise
        }
        eventType
      }
    }
  `,
  [Fragments.Exercise]
)

export const teamAction = graphql(
  `
    subscription teamAction($teamId: ID!) {
      actionLogs(teamId: $teamId) {
        actionLog {
          ...ActionLog
        }
        eventType
      }
    }
  `,
  [Fragments.ActionLog]
)

export const teamMilestones = graphql(
  `
    subscription teamMilestones($teamId: ID!) {
      milestones: milestones(teamId: $teamId, visibleOnly: false) {
        milestones {
          ...MilestoneState
        }
      }
    }
  `,
  [Fragments.MilestoneState]
)

export const teamQuestionnaireState = graphql(
  `
    subscription teamQuestionnaireState($teamId: ID!) {
      teamQuestionnaireState: teamQuestionnaireStateSubscription(
        teamId: $teamId
      ) {
        teamQuestionnaireState {
          ...TeamQuestionnaireState
        }
      }
    }
  `,
  [Fragments.TeamQuestionnaireState]
)

export const teamVisibleMilestones = graphql(
  `
    subscription teamVisibleMilestones($teamId: ID!) {
      teamVisibleMilestones: milestones(teamId: $teamId, visibleOnly: true) {
        milestones {
          ...MilestoneState
        }
      }
    }
  `,
  [Fragments.MilestoneState]
)
