import { graphql } from './graphql'

import * as Fragments from './fragments'

export const GetAnalyticsActionLogs = graphql(
  `
    query GetAnalyticsActionLogs($exerciseId: ID!, $newestFirst: Boolean) {
      analyticsActionLogs(exerciseId: $exerciseId, newestFirst: $newestFirst) {
        ...ActionLog
      }
    }
  `,
  [Fragments.ActionLog]
)

export const GetAnalyticsActionLogsFlat = graphql(
  `
    query GetAnalyticsActionLogsFlat($exerciseId: ID!, $newestFirst: Boolean) {
      analyticsActionLogs(exerciseId: $exerciseId, newestFirst: $newestFirst) {
        ...ActionLogFlat
      }
    }
  `,
  [Fragments.ActionLogFlat]
)

export const GetAnalyticsEmailThreads = graphql(
  `
    query GetAnalyticsEmailThreads($exerciseId: ID!) {
      analyticsEmailThreads(exerciseId: $exerciseId) {
        ...EmailThread
      }
    }
  `,
  [Fragments.EmailThread]
)

export const GetAnalyticsMilestones = graphql(
  `
    query GetAnalyticsMilestones($exerciseId: ID!) {
      analyticsMilestones(exerciseId: $exerciseId) {
        activity {
          id
          activity {
            ...LearningActivity
          }
          reached
          milestoneStates {
            id
          }
          teamObjective {
            id
            reached
            objective {
              ...LearningObjective
            }
            activities {
              id
            }
          }
        }
        ...MilestoneState
      }
    }
  `,
  [
    Fragments.LearningActivity,
    Fragments.LearningObjective,
    Fragments.MilestoneState,
  ]
)

export const GetAutoInjects = graphql(
  `
    query GetAutoInjects($exerciseId: ID!) {
      injects(exerciseId: $exerciseId) {
        ...DefinitionInject
      }
    }
  `,
  [Fragments.DefinitionInject]
)

export const GetChannel = graphql(
  `
    query GetChannel($channelId: ID!) {
      channel(channelId: $channelId) {
        ...Channel
      }
    }
  `,
  [Fragments.Channel]
)

export const GetDefinition = graphql(
  `
    query GetDefinition($definitionId: ID!) {
      definition(definitionId: $definitionId) {
        ...Definition
      }
    }
  `,
  [Fragments.Definition]
)

export const GetDefinitions = graphql(
  `
    query GetDefinitions {
      definitions {
        ...Definition
      }
    }
  `,
  [Fragments.Definition]
)

export const GetEmailAddresses = graphql(
  `
    query GetEmailAddresses($threadId: ID!) {
      emailAddresses(threadId: $threadId)
    }
  `,
  []
)

export const GetEmailContacts = graphql(
  `
    query GetEmailContacts($visibleOnly: Boolean = false) {
      emailContacts(visibleOnly: $visibleOnly) {
        ...EmailParticipant
      }
    }
  `,
  [Fragments.EmailParticipant]
)

export const GetEmailTemplate = graphql(
  `
    query GetEmailTemplate($templateId: ID!) {
      threadTemplate(templateId: $templateId) {
        ...EmailTemplate
      }
    }
  `,
  [Fragments.EmailTemplate]
)

export const GetEmailTemplates = graphql(
  `
    query GetEmailTemplates($exerciseId: ID!, $emailAddresses: [String]!) {
      emailTemplates(exerciseId: $exerciseId, emailAddresses: $emailAddresses) {
        ...EmailTemplate
      }
    }
  `,
  [Fragments.EmailTemplate]
)

export const GetEmailThread = graphql(
  `
    query GetEmailThread($threadId: ID!) {
      emailThread(threadId: $threadId) {
        ...EmailThread
      }
    }
  `,
  [Fragments.EmailThread]
)

export const GetEmailThreads = graphql(
  `
    query GetEmailThreads(
      $teamId: ID!
      $received: Boolean = true
      $sent: Boolean = true
      $archived: Boolean = false
    ) {
      emailThreads(teamId: $teamId)
        @_filterEmails(received: $received, sent: $sent, archived: $archived) {
        id
        ...EmailThread @_unmask
      }
    }
  `,
  [Fragments.EmailThread]
)

export const GetExercise = graphql(
  `
    query GetExercise($exerciseId: ID!) {
      exerciseId(exerciseId: $exerciseId) {
        ...Exercise
      }
    }
  `,
  [Fragments.Exercise]
)

export const GetExerciseChannels = graphql(
  `
    query GetExerciseChannels($exerciseId: ID!) {
      exerciseChannels(exerciseId: $exerciseId) {
        id
        name
        type
        displayName
        description
        readReceipt {
          teamId
          isUnread
          id
        }
      }
    }
  `,
  []
)

export const GetExerciseConfig = graphql(
  `
    query GetExerciseConfig($exerciseId: ID!, $teamId: ID!) {
      exerciseConfig(exerciseId: $exerciseId) {
        ...ExerciseConfig
      }
      teamTools(teamId: $teamId) {
        ...Tool
      }
    }
  `,
  [Fragments.ExerciseConfig, Fragments.Tool]
)

export const GetExerciseLoopStatus = graphql(
  `
    query GetExerciseLoopStatus($exerciseId: ID!) {
      exerciseLoopRunning(exerciseId: $exerciseId)
    }
  `,
  []
)

export const GetExerciseQuestionnaires = graphql(
  `
    query GetExerciseQuestionnaires($exerciseId: ID!) {
      questionnaires(exerciseId: $exerciseId) {
        ...QuestionnaireDetails
      }
    }
  `,
  [Fragments.QuestionnaireDetails]
)

export const GetExercises = graphql(
  `
    query GetExercises {
      exercises {
        ...Exercise
      }
    }
  `,
  [Fragments.Exercise]
)

export const GetExerciseTimeLeft = graphql(
  `
    query GetExerciseTimeLeft {
      exerciseTimeLeft
    }
  `,
  []
)

export const GetExerciseWithConfig = graphql(
  `
    query GetExerciseWithConfig($exerciseId: ID!) {
      exerciseId(exerciseId: $exerciseId) {
        ...Exercise
      }
      exerciseConfig(exerciseId: $exerciseId) {
        ...ExerciseConfig
      }
    }
  `,
  [Fragments.Exercise, Fragments.ExerciseConfig]
)

export const GetFileInfo = graphql(
  `
    query GetFileInfo($fileInfoId: UUID!) {
      fileInfo(fileInfoId: $fileInfoId) {
        ...FileInfo
      }
    }
  `,
  [Fragments.FileInfo]
)

export const GetMilestones = graphql(
  `
    query GetMilestones($exerciseId: ID!) {
      milestones(exerciseId: $exerciseId) {
        ...Milestone
      }
    }
  `,
  [Fragments.Milestone]
)

export const GetRunningExercises = graphql(
  `
    query GetRunningExercises {
      exercises(running: true) {
        ...Exercise
      }
    }
  `,
  [Fragments.Exercise]
)

export const GetSingleActionLog = graphql(
  `
    query GetSingleActionLog($logId: ID!) {
      actionLog(logId: $logId) {
        ...ActionLog
      }
    }
  `,
  [Fragments.ActionLog]
)

export const GetTags = graphql(
  `
    query GetTags {
      tags {
        ...Tag
      }
    }
  `,
  [Fragments.Tag]
)

export const GetTeam = graphql(
  `
    query GetTeam($teamId: ID!) {
      team(teamId: $teamId) {
        ...Team
      }
    }
  `,
  [Fragments.Team]
)

export const GetTeamActionLogs = graphql(
  `
    query GetTeamActionLogs($teamId: ID!) {
      actionLogs: teamActionLogs(teamId: $teamId) {
        ...ActionLog
      }
    }
  `,
  [Fragments.ActionLog]
)

export const GetTeamActionLogsFlat = graphql(
  `
    query GetTeamActionLogsFlat($teamId: ID!) {
      actionLogs: teamActionLogs(teamId: $teamId) {
        ...ActionLogFlat
      }
    }
  `,
  [Fragments.ActionLogFlat]
)

export const GetTeamChannelLogs = graphql(
  `
    query GetTeamChannelLogs($teamId: ID!, $channelId: ID!) {
      teamChannelLogs(teamId: $teamId, channelId: $channelId) {
        ...ActionLog
      }
    }
  `,
  [Fragments.ActionLog]
)

export const GetTeamChannelLogsFlat = graphql(
  `
    query GetTeamChannelLogsFlat($teamId: ID!, $channelId: ID!) {
      teamChannelLogs(teamId: $teamId, channelId: $channelId) {
        ...ActionLogSimple
      }
    }
  `,
  [Fragments.ActionLogSimple]
)

export const GetTeamEmailParticipant = graphql(
  `
    query GetTeamEmailParticipant($teamId: ID!) {
      teamEmailParticipant(teamId: $teamId) {
        ...EmailParticipant
      }
    }
  `,
  [Fragments.EmailParticipant]
)

export const GetTeamLearningObjectives = graphql(
  `
    query GetTeamLearningObjectives($teamId: ID!) {
      teamLearningObjectives(teamId: $teamId) {
        ...TeamLearningObjective
      }
    }
  `,
  [Fragments.TeamLearningObjective]
)

export const GetTeamMilestones = graphql(
  `
    query GetTeamMilestones($teamId: ID!) {
      teamMilestones(teamId: $teamId, visibleOnly: false) {
        activity {
          id
          teamObjective {
            id
          }
        }
        ...MilestoneState
      }
    }
  `,
  [Fragments.MilestoneState]
)

export const GetTeamQuestionnaires = graphql(
  `
    query GetTeamQuestionnaires($teamId: ID!) {
      teamQuestionnaires(teamId: $teamId) {
        ...TeamQuestionnaireState
      }
    }
  `,
  [Fragments.TeamQuestionnaireState]
)

export const GetTeamQuestionnaireState = graphql(
  `
    query GetTeamQuestionnaireState($teamId: ID!, $questionnaireId: ID!) {
      questionnaireState(teamId: $teamId, questionnaireId: $questionnaireId) {
        ...TeamQuestionnaireState
        questionnaire {
          ...QuestionnaireDetails
        }
      }
    }
  `,
  [Fragments.TeamQuestionnaireState, Fragments.QuestionnaireDetails]
)

export const GetThreadTemplates = graphql(
  `
    query GetThreadTemplates($threadId: ID!) {
      threadTemplates(threadId: $threadId) {
        ...EmailTemplate
      }
    }
  `,
  [Fragments.EmailTemplate]
)

export const GetTools = graphql(
  `
    query GetTools($exerciseId: ID!) {
      exerciseTools(exerciseId: $exerciseId) {
        ...Tool
      }
    }
  `,
  [Fragments.Tool]
)

export const GetTraineeViewData = graphql(
  `
    query GetTraineeViewData($teamId: ID!, $exerciseId: ID!) {
      team(teamId: $teamId) {
        ...Team
      }
      exerciseConfig(exerciseId: $exerciseId) {
        showExerciseTime
      }
      exerciseChannels(exerciseId: $exerciseId) {
        id
        name
        type
        displayName
        description
        readReceipt {
          isUnread
          teamId
          id
        }
      }
    }
  `,
  [Fragments.Team]
)

export const GetUser = graphql(
  `
    query GetUser($userId: UUID!) {
      user(userId: $userId) {
        ...User
      }
    }
  `,
  [Fragments.User]
)

export const GetUsers = graphql(
  `
    query GetUsers($active: Boolean, $groups: [AuthGroup], $tags: [String]) {
      users(
        filterUsersInput: { active: $active, groups: $groups, tags: $tags }
      ) {
        ...User
      }
    }
  `,
  [Fragments.User]
)

export const Identity = graphql(
  `
    query Identity {
      whoAmI {
        ...User
      }
    }
  `,
  [Fragments.User]
)

export const ValidateEmailAddress = graphql(
  `
    query ValidateEmailAddress($exerciseId: ID!, $address: String!) {
      validateEmailAddress(exerciseId: $exerciseId, address: $address)
    }
  `,
  []
)
