import { graphql } from './graphql'

import * as Fragments from './fragments'

export const AddDefinitionAccess = graphql(
  `
    mutation AddDefinitionAccess($definitionId: ID!, $userIds: [ID]!) {
      addDefinitionAccess(definitionId: $definitionId, userIds: $userIds) {
        operationDone
      }
    }
  `,
  []
)

export const AnswerQuestionnaire = graphql(
  `
    mutation AnswerQuestionnaire($questInput: QuestionnaireInput!) {
      answerQuestionnaire(questInput: $questInput) {
        operationDone
      }
    }
  `,
  []
)

export const AssignInstructorsToExercise = graphql(
  `
    mutation AssignInstructorsToExercise($exerciseId: ID!, $userIds: [ID]!) {
      assignInstructorsToExercise(exerciseId: $exerciseId, userIds: $userIds) {
        operationDone
      }
    }
  `,
  []
)

export const AssignUsersByTags = graphql(
  `
    mutation AssignUsersByTags(
      $exerciseId: ID!
      $tagPrefix: String!
      $userIds: [ID!]!
    ) {
      assignUsersByTags(
        exerciseId: $exerciseId
        tagPrefix: $tagPrefix
        userIds: $userIds
      ) {
        operationDone
      }
    }
  `,
  []
)

export const AssignUsersEqually = graphql(
  `
    mutation AssignUsersEqually($exerciseId: ID!, $userIds: [ID!]!) {
      assignUsersEqually(exerciseId: $exerciseId, userIds: $userIds) {
        operationDone
      }
    }
  `,
  []
)

export const AssignUsersToTeam = graphql(
  `
    mutation AssignUsersToTeam($teamId: ID!, $userIds: [ID]!) {
      assignUsersToTeam(teamId: $teamId, userIds: $userIds) {
        operationDone
      }
    }
  `,
  []
)

export const ChangeUserData = graphql(
  `
    mutation ChangeUserData(
      $userId: UUID!
      $group: AuthGroup
      $active: Boolean
    ) {
      changeUserData(
        changeUserInput: { userId: $userId, group: $group, active: $active }
      ) {
        user {
          ...User
        }
      }
    }
  `,
  [Fragments.User]
)

export const Confirm = graphql(
  `
    mutation Confirm($logId: ID!, $teamId: ID!) {
      confirmAction(logId: $logId, teamId: $teamId) {
        actionLog {
          id
        }
      }
    }
  `,
  []
)

export const CopyUsersAssignment = graphql(
  `
    mutation CopyUsersAssignment($fromExerciseId: ID!, $toExerciseId: ID!) {
      copyUsersAssignment(
        fromExerciseId: $fromExerciseId
        toExerciseId: $toExerciseId
      ) {
        operationDone
      }
    }
  `,
  []
)

export const CreateExercises = graphql(
  `
    mutation CreateExercises($id: ID!, $teamCount: Int!, $name: String) {
      createExercise(
        createExerciseInput: {
          definitionId: $id
          teamCount: $teamCount
          name: $name
        }
      ) {
        exercise {
          ...Exercise
        }
      }
    }
  `,
  [Fragments.Exercise]
)

export const CreateThread = graphql(
  `
    mutation CreateThread(
      $exerciseId: ID!
      $participantAddresses: [String]!
      $subject: String!
    ) {
      createThread(
        exerciseId: $exerciseId
        participantAddresses: $participantAddresses
        subject: $subject
      ) {
        thread {
          ...EmailThread
        }
      }
    }
  `,
  [Fragments.EmailThread]
)

export const CreateUser = graphql(
  `
    mutation CreateUser(
      $email: String!
      $firstName: String
      $lastName: String
      $tags: [String!]!
      $group: AuthGroup
    ) {
      createUser(
        createUserInput: {
          email: $email
          firstName: $firstName
          lastName: $lastName
          tags: $tags
          group: $group
        }
      ) {
        newUser {
          ...RestrictedUserF
        }
      }
    }
  `,
  [Fragments.RestrictedUserF]
)

export const DeleteDefinition = graphql(
  `
    mutation DeleteDefinition($definitionId: ID!) {
      deleteDefinition(definitionId: $definitionId) {
        operationDone
      }
    }
  `,
  []
)

export const DeleteExercise = graphql(
  `
    mutation DeleteExercise($id: ID!) {
      deleteExercise(exerciseId: $id) {
        operationDone
      }
    }
  `,
  []
)

export const DeleteUsers = graphql(
  `
    mutation DeleteUsers($userIds: [ID]!) {
      deleteUsers(userIds: $userIds) {
        operationDone
      }
    }
  `,
  []
)

export const MoveTime = graphql(
  `
    mutation MoveTime($exerciseId: ID!, $timeDiff: Int!) {
      moveTime(exerciseId: $exerciseId, timeDiff: $timeDiff) {
        exercise {
          ...Exercise
        }
      }
    }
  `,
  [Fragments.Exercise]
)

export const PerformTeamToolAction = graphql(
  `
    mutation PerformTeamToolAction(
      $teamId: ID!
      $toolArgument: String!
      $toolId: ID!
    ) {
      useTool(
        useToolInput: {
          teamId: $teamId
          toolArgument: $toolArgument
          toolId: $toolId
        }
      ) {
        operationDone
      }
    }
  `,
  []
)

export const RegenerateCredentials = graphql(
  `
    mutation RegenerateCredentials($userIds: [ID]!) {
      regenerateCredentials(userIds: $userIds) {
        operationDone
      }
    }
  `,
  []
)

export const RemoveDefinitionAccess = graphql(
  `
    mutation RemoveDefinitionAccess($definitionId: ID!, $userIds: [ID]!) {
      removeDefinitionAccess(definitionId: $definitionId, userIds: $userIds) {
        operationDone
      }
    }
  `,
  []
)

export const RemoveInstructorsFromExercise = graphql(
  `
    mutation RemoveInstructorsFromExercise($exerciseId: ID!, $userIds: [ID]!) {
      removeInstructorsFromExercise(
        exerciseId: $exerciseId
        userIds: $userIds
      ) {
        operationDone
      }
    }
  `,
  []
)

export const RemoveUsersFromTeam = graphql(
  `
    mutation RemoveUsersFromTeam($teamId: ID!, $userIds: [ID]!) {
      removeUsersFromTeam(teamId: $teamId, userIds: $userIds) {
        operationDone
      }
    }
  `,
  []
)

export const ReviewQuestionnaire = graphql(
  `
    mutation ReviewQuestionnaire($reviewInput: QuestionnaireReviewInput!) {
      reviewQuestionnaire(reviewInput: $reviewInput) {
        updatedState {
          ...TeamQuestionnaireState
        }
      }
    }
  `,
  [Fragments.TeamQuestionnaireState]
)

export const SendCustomInject = graphql(
  `
    mutation SendCustomInject($customInjectInput: CustomInjectInput!) {
      sendCustomInject(customInjectInput: $customInjectInput) {
        operationDone
      }
    }
  `,
  []
)

export const SendEmail = graphql(
  `
    mutation SendEmail($sendEmailInput: SendEmailInput!) {
      sendEmail(sendEmailInput: $sendEmailInput) {
        operationDone
      }
    }
  `,
  []
)

export const SetMilestone = graphql(
  `
    mutation SetMilestone(
      $activate: Boolean!
      $milestone: String!
      $teamId: ID!
    ) {
      modifyMilestone(
        activate: $activate
        milestone: $milestone
        teamId: $teamId
      ) {
        operationDone
      }
    }
  `,
  []
)

export const StartExercise = graphql(
  `
    mutation StartExercise($id: ID!) {
      startExercise(exerciseId: $id) {
        exercise {
          id
        }
      }
    }
  `,
  []
)

export const StopExercise = graphql(
  `
    mutation StopExercise($id: ID!) {
      stopExercise(exerciseId: $id) {
        exercise {
          id
        }
      }
    }
  `,
  []
)
