import { graphql } from './graphql'

import * as FragmentsClient from './fragments.client'

export const DeleteEmailDraft = graphql(
  `
    mutation DeleteEmailDraft(
      $teamId: ID!
      $instructor: Boolean!
      $emailThreadId: ID
    ) {
      deleteEmailDraft(
        teamId: $teamId
        instructor: $instructor
        emailThreadId: $emailThreadId
      ) @client {
        operationDone
      }
    }
  `,
  []
)

export const ReloadDefinitions = graphql(
  `
    mutation ReloadDefinitions {
      reloadDefinitions @client {
        operationDone
      }
    }
  `,
  []
)

export const ReloadExercises = graphql(
  `
    mutation ReloadExercises {
      reloadExercises @client {
        operationDone
      }
    }
  `,
  []
)

export const ReloadTable = graphql(
  `
    mutation ReloadTable {
      reloadTable @client {
        operationDone
      }
    }
  `,
  []
)

export const SetEmailDraft = graphql(
  `
    mutation SetEmailDraft($emailDraft: EmailDraftInput!) {
      setEmailDraft(emailDraft: $emailDraft) @client {
        ...EmailDraft
      }
    }
  `,
  [FragmentsClient.EmailDraft]
)

export const SetEmailThreadArchive = graphql(
  `
    mutation SetEmailThreadArchive($emailThreadId: ID!, $state: Boolean!) {
      setArchiveEmail(emailThreadId: $emailThreadId, state: $state) {
        operationDone
      }
    }
  `,
  []
)

export const setIsUnreadChannel = graphql(
  `
    mutation setIsUnreadChannel(
      $channelId: ID!
      $teamId: ID!
      $isUnread: Boolean!
    ) {
      setIsUnreadChannel(
        channelId: $channelId
        teamId: $teamId
        isUnread: $isUnread
      ) @client {
        operationDone
      }
    }
  `,
  []
)

export const setIsUnreadEmailThread = graphql(
  `
    mutation setIsUnreadEmailThread(
      $threadId: ID!
      $teamId: ID!
      $isUnread: Boolean!
    ) {
      setIsUnreadEmailThread(
        threadId: $threadId
        teamId: $teamId
        isUnread: $isUnread
      ) @client {
        operationDone
      }
    }
  `,
  []
)

export const SetTodoActionLog = graphql(
  `
    mutation SetTodoActionLog($actionLogId: ID!, $state: Boolean!) {
      setTodoActionLog(actionLogId: $actionLogId, state: $state) {
        operationDone
      }
    }
  `,
  []
)

export const SetEmailTodo = graphql(
  `
    mutation SetEmailTodo($emailId: ID!, $state: Boolean!) {
      setEmailTodo(emailId: $emailId, state: $state) {
        operationDone
      }
    }
  `,
  []
)

export const SetTeamQuestionnaireTodo = graphql(
  `
    mutation SetTeamQuestionnaireTodo(
      $questionnaireId: ID!
      $teamId: ID!
      $state: Boolean!
    ) {
      setTeamQuestionnaireTodo(
        questionnaireId: $questionnaireId
        teamId: $teamId
        state: $state
      ) {
        operationDone
      }
    }
  `,
  []
)

export const WriteReadReceipt = graphql(
  `
    mutation WriteReadReceipt($actionLogId: ID!) {
      writeReadReceipt(actionLogId: $actionLogId) @client {
        actionLogId
        readReceipt
      }
    }
  `,
  []
)

export const WriteReadReceiptEmail = graphql(
  `
    mutation WriteReadReceiptEmail($emailId: ID!) {
      writeReadReceiptEmail(emailId: $emailId) @client {
        emailId
        readReceipt
      }
    }
  `,
  []
)
