/* eslint-disable */
/* prettier-ignore */
import type { TadaDocumentNode, $tada } from 'gql.tada';

declare module 'gql.tada' {
 interface setupCache {
    "\n    fragment RestrictedExercise on RestrictedExercise @_unmask {\n      id\n      name\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; }, {}, { fragment: "RestrictedExercise"; on: "RestrictedExercise"; masked: false; }>;
    "\n    fragment Control on ControlType @_unmask {\n      id\n      milestoneCondition\n      activateMilestone\n      deactivateMilestone\n      roles\n    }\n  ":
      TadaDocumentNode<{ id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }, {}, { fragment: "Control"; on: "ControlType"; masked: false; }>;
    "\n    fragment Answer on AnswerType @_unmask {\n      questionId\n      value\n    }\n  ":
      TadaDocumentNode<{ questionId: string; value: string; }, {}, { fragment: "Answer"; on: "AnswerType"; masked: false; }>;
    "\n    fragment Channel on DefinitionChannelType @_unmask {\n      id\n      name\n      displayName\n      description\n      type\n      readReceipt {\n        isUnread\n        teamId\n        id\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; displayName: string; description: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; readReceipt: { isUnread: boolean | null; teamId: string; id: string; }[]; }, {}, { fragment: "Channel"; on: "DefinitionChannelType"; masked: false; }>;
    "\n    fragment Confirmation on ConfirmationType @_unmask {\n      id\n      text\n    }\n  ":
      TadaDocumentNode<{ id: string; text: string; }, {}, { fragment: "Confirmation"; on: "ConfirmationType"; masked: false; }>;
    "\n    fragment ExerciseConfig on GrapheneConfig @_unmask {\n      exerciseDuration\n      emailBetweenTeams\n      showExerciseTime\n      enableRoles\n      customEmailSuffix\n    }\n  ":
      TadaDocumentNode<{ exerciseDuration: number | null; emailBetweenTeams: boolean | null; showExerciseTime: boolean | null; enableRoles: boolean | null; customEmailSuffix: string | null; }, {}, { fragment: "ExerciseConfig"; on: "GrapheneConfig"; masked: false; }>;
    "\n    fragment ExerciseDefinition on ExerciseDefinitionType @_unmask {\n      id\n      name\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; }, {}, { fragment: "ExerciseDefinition"; on: "ExerciseDefinitionType"; masked: false; }>;
    "\n    fragment ActionLogSimple on ActionLogType @_unmask {\n      id\n      type\n      requiresAttention\n      readReceipt\n    }\n  ":
      TadaDocumentNode<{ id: string; type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; requiresAttention: boolean; readReceipt: string | null; }, {}, { fragment: "ActionLogSimple"; on: "ActionLogType"; masked: false; }>;
    "\n    fragment FileInfo on FileInfoType @_unmask {\n      id\n      fileName\n    }\n  ":
      TadaDocumentNode<{ id: string; fileName: string; }, {}, { fragment: "FileInfo"; on: "FileInfoType"; masked: false; }>;
    "\n    fragment Milestone on MilestoneType @_unmask {\n      id\n      name\n      description\n      displayName\n      tags\n      teamVisible\n      roles\n      fileNames\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }, {}, { fragment: "Milestone"; on: "MilestoneType"; masked: false; }>;
    "\n    fragment Overlay on OverlayType @_unmask {\n      id\n      duration\n    }\n  ":
      TadaDocumentNode<{ id: string; duration: number; }, {}, { fragment: "Overlay"; on: "OverlayType"; masked: false; }>;
    "\n    fragment RestrictedUserF on RestrictedUser @_unmask {\n      id\n      username\n      firstName\n      lastName\n      group\n    }\n  ":
      TadaDocumentNode<{ id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }, {}, { fragment: "RestrictedUserF"; on: "RestrictedUser"; masked: false; }>;
    "\n    fragment Role on DefinitionRoleType @_unmask {\n      id\n      name\n      displayName\n      description\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; displayName: string; description: string; }, {}, { fragment: "Role"; on: "DefinitionRoleType"; masked: false; }>;
    "\n    fragment Tag on TagType @_unmask {\n      id\n      name\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; }, {}, { fragment: "Tag"; on: "TagType"; masked: false; }>;
    "\n    fragment TeamWithoutEmailAddress on TeamType @_unmask {\n      id\n      name\n      role\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; role: string; }, {}, { fragment: "TeamWithoutEmailAddress"; on: "TeamType"; masked: false; }>;
    "\n    fragment EmailAddress on EmailAddressType @_unmask {\n      id\n      address\n      description\n      control {\n        ...Control\n      }\n      teamVisible\n      organization\n    }\n  ":
      TadaDocumentNode<{ id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; }, {}, { fragment: "EmailAddress"; on: "EmailAddressType"; masked: false; }>;
    "\n    fragment EmailParticipant on EmailParticipantType @_unmask {\n      id\n      definitionAddress {\n        ...EmailAddress\n      }\n      address\n      team {\n        ...TeamWithoutEmailAddress\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }, {}, { fragment: "EmailParticipant"; on: "EmailParticipantType"; masked: false; }>;
    "\n    fragment Team on TeamType @_unmask {\n      id\n      name\n      role\n      emailAddress {\n        ...EmailParticipant\n      }\n      exercise {\n        id\n        name\n      }\n      users {\n        ...RestrictedUserF\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }, {}, { fragment: "Team"; on: "TeamType"; masked: false; }>;
    "\n    fragment ActionLogFlat on ActionLogType @_unmask {\n      ...ActionLogSimple\n      todo\n      team {\n        id\n      }\n      details {\n        __typename\n        ... on QuestionnaireType {\n          id\n          teamQuestionnaireStates {\n            id\n            team {\n              id\n            }\n            questionnaire {\n              id\n            }\n            todo\n          }\n        }\n        ... on EmailType {\n          id\n          todo\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; requiresAttention: boolean; readReceipt: string | null; todo: boolean; team: { id: string; }; details: { __typename: "QuestionnaireType"; id: string; teamQuestionnaireStates: { id: string; team: { id: string; }; questionnaire: { id: string; }; todo: boolean; }[]; } | { __typename: "EmailType"; id: string; todo: boolean; } | { __typename: "CustomInjectDetailsType"; } | { __typename: "InjectDetailsType"; } | { __typename: "ToolDetailsType"; }; }, {}, { fragment: "ActionLogFlat"; on: "ActionLogType"; masked: false; }>;
    "\n    fragment Content on ContentType @_unmask {\n      id\n      raw\n      rendered\n      fileInfo {\n        ...FileInfo\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }, {}, { fragment: "Content"; on: "ContentType"; masked: false; }>;
    "\n    fragment ControlsMap on ControlsMapType @_unmask {\n      choice\n      control {\n        ...Control\n      }\n    }\n  ":
      TadaDocumentNode<{ choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }, {}, { fragment: "ControlsMap"; on: "ControlsMapType"; masked: false; }>;
    "\n    fragment CustomInjectDetails on CustomInjectDetailsType @_unmask {\n      id\n      content {\n        ...Content\n      }\n      overlay {\n        ...Overlay\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; }, {}, { fragment: "CustomInjectDetails"; on: "CustomInjectDetailsType"; masked: false; }>;
    "\n    fragment Definition on DefinitionType @_unmask {\n      id\n      name\n      description\n      prerequisites\n      targetAudience\n      version\n      channels {\n        id\n        name\n        type\n        displayName\n        description\n      }\n      roles {\n        ...Role\n      }\n      maintainers {\n        ...RestrictedUserF\n      }\n      uploadedBy {\n        ...RestrictedUserF\n      }\n      timestampCreated\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; description: string; prerequisites: string[]; targetAudience: string; version: string; channels: { id: string; name: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; displayName: string; description: string; }[]; roles: { id: string; name: string; displayName: string; description: string; }[]; maintainers: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; uploadedBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }, {}, { fragment: "Definition"; on: "DefinitionType"; masked: false; }>;
    "\n    fragment DefinitionInject on DefinitionInjectType @_unmask {\n      id\n      name\n      time\n      delay\n      organization\n      type\n      target {\n        ...Channel\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; time: number; delay: number; organization: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; target: { id: string; name: string; displayName: string; description: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; readReceipt: { isUnread: boolean | null; teamId: string; id: string; }[]; }; }, {}, { fragment: "DefinitionInject"; on: "DefinitionInjectType"; masked: false; }>;
    "\n    fragment Email on EmailType @_unmask {\n      id\n      sender {\n        ...EmailParticipant\n      }\n      thread {\n        id\n      }\n      content {\n        ...Content\n      }\n      overlay {\n        ...Overlay\n      }\n      todo\n      timestamp\n      readReceipt @client(always: true)\n    }\n  ":
      TadaDocumentNode<{ id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }, {}, { fragment: "Email"; on: "EmailType"; masked: false; }>;
    "\n    fragment EmailThread on EmailThreadType @_unmask {\n      id\n      participants {\n        ...EmailParticipant\n      }\n      subject\n      timestamp\n      emails {\n        ...Email\n      }\n      lastEmail {\n        ...Email\n      }\n      readReceipt @client(always: true) {\n        isUnread\n        teamId\n        threadId\n      }\n      archived\n    }\n  ":
      TadaDocumentNode<{ id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }, {}, { fragment: "EmailThread"; on: "EmailThreadType"; masked: false; }>;
    "\n    fragment EmailDetails on EmailType @_unmask {\n      id\n      sender {\n        ...EmailParticipant\n      }\n      thread {\n        ...EmailThread\n      }\n      content {\n        ...Content\n      }\n      overlay {\n        ...Overlay\n      }\n      timestamp\n      readReceipt @client(always: true)\n    }\n  ":
      TadaDocumentNode<{ id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; timestamp: string; readReceipt: string | null; }, {}, { fragment: "EmailDetails"; on: "EmailType"; masked: false; }>;
    "\n    fragment EmailTemplate on EmailTemplateType @_unmask {\n      id\n      sender\n      context\n      subject\n      content {\n        ...Content\n      }\n      control {\n        ...Control\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; sender: string; context: string; subject: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }, {}, { fragment: "EmailTemplate"; on: "EmailTemplateType"; masked: false; }>;
    "\n    fragment Exercise on ExerciseType @_unmask {\n      id\n      name\n      running\n      finished\n      exerciseStart\n      definition {\n        ...ExerciseDefinition\n      }\n      teams {\n        ...Team\n      }\n      emailParticipants {\n        ...EmailParticipant\n      }\n      timeDelta: elapsedS\n      definition {\n        id\n        name\n      }\n      instructors {\n        ...RestrictedUserF\n      }\n      createdBy {\n        ...RestrictedUserF\n      }\n      timestampCreated\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; running: boolean; finished: boolean; exerciseStart: string | null; definition: { id: string; name: string; } & { id: string; name: string; }; teams: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }[]; emailParticipants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; timeDelta: number; instructors: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; createdBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }, {}, { fragment: "Exercise"; on: "ExerciseType"; masked: false; }>;
    "\n    fragment ExtendedTool on ExtendedToolType @_unmask {\n      id\n      name\n      category\n      tooltipDescription\n      defaultResponse\n      roles\n      hint\n      definition {\n        ...ExerciseDefinition\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; category: string; tooltipDescription: string; defaultResponse: string; roles: string; hint: string; definition: { id: string; name: string; } | null; }, {}, { fragment: "ExtendedTool"; on: "ExtendedToolType"; masked: false; }>;
    "\n    fragment FreeFormQuestionDetails on FreeFormQuestionDetailsType @_unmask {\n      id\n      relatedMilestones {\n        ...Milestone\n      }\n      multiline\n    }\n  ":
      TadaDocumentNode<{ id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; }, {}, { fragment: "FreeFormQuestionDetails"; on: "FreeFormQuestionDetailsType"; masked: false; }>;
    "\n    fragment InjectDetails on InjectDetailsType @_unmask {\n      id\n      inject {\n        ...DefinitionInject\n      }\n      content {\n        ...Content\n      }\n      overlay {\n        ...Overlay\n      }\n      confirmation {\n        ...Confirmation\n      }\n      confirmed\n      confirmedBy {\n        ...RestrictedUserF\n      }\n      timestampConfirmed\n    }\n  ":
      TadaDocumentNode<{ id: string; inject: { id: string; name: string; time: number; delay: number; organization: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; target: { id: string; name: string; displayName: string; description: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; readReceipt: { isUnread: boolean | null; teamId: string; id: string; }[]; }; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; confirmation: { id: string; text: string; } | null; confirmed: boolean | null; confirmedBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampConfirmed: string | null; }, {}, { fragment: "InjectDetails"; on: "InjectDetailsType"; masked: false; }>;
    "\n    fragment LearningActivity on LearningActivityType @_unmask {\n      id\n      name\n      description\n      tags\n      milestones {\n        ...Milestone\n      }\n      objective {\n        id\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; description: string; tags: string; milestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; objective: { id: string; }; }, {}, { fragment: "LearningActivity"; on: "LearningActivityType"; masked: false; }>;
    "\n    fragment LearningObjective on LearningObjectiveType @_unmask {\n      id\n      name\n      description\n      order\n      tags\n      activities {\n        ...LearningActivity\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; description: string; order: number; tags: string; activities: { id: string; name: string; description: string; tags: string; milestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; objective: { id: string; }; }[]; }, {}, { fragment: "LearningObjective"; on: "LearningObjectiveType"; masked: false; }>;
    "\n    fragment RadioQuestionDetails on RadioQuestionDetailsType @_unmask {\n      id\n      max\n      correct\n      labels\n      controls {\n        ...ControlsMap\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }, {}, { fragment: "RadioQuestionDetails"; on: "RadioQuestionDetailsType"; masked: false; }>;
    "\n    fragment MilestoneState on MilestoneStateType @_unmask {\n      id\n      milestone {\n        ...Milestone\n      }\n      reached\n      timestampReached\n      teamIds\n    }\n  ":
      TadaDocumentNode<{ id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }, {}, { fragment: "MilestoneState"; on: "MilestoneStateType"; masked: false; }>;
    "\n    fragment Question on QuestionType @_unmask {\n      id\n      content {\n        ...Content\n      }\n      type\n      details {\n        ... on RadioQuestionDetailsType {\n          ...RadioQuestionDetails\n        }\n        ... on FreeFormQuestionDetailsType {\n          ...FreeFormQuestionDetails\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }, {}, { fragment: "Question"; on: "QuestionType"; masked: false; }>;
    "\n    fragment QuestionnaireAnswer on QuestionnaireAnswerType @_unmask {\n      id\n      isCorrect\n      question {\n        ...Question\n      }\n      answer\n    }\n  ":
      TadaDocumentNode<{ id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }, {}, { fragment: "QuestionnaireAnswer"; on: "QuestionnaireAnswerType"; masked: false; }>;
    "\n    fragment QuestionRelatedMilestones on QuestionRelatedMilestonesType\n    @_unmask {\n      questionId\n      milestones {\n        ...MilestoneState\n      }\n    }\n  ":
      TadaDocumentNode<{ questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }, {}, { fragment: "QuestionRelatedMilestones"; on: "QuestionRelatedMilestonesType"; masked: false; }>;
    "\n    fragment QuestionnaireDetails on QuestionnaireType @_unmask {\n      id\n      title\n      time\n      content {\n        ...Content\n      }\n      control {\n        ...Control\n      }\n      overlay {\n        ...Overlay\n      }\n      questions {\n        ...Question\n      }\n      teamQuestionnaireStates {\n        id\n        team {\n          ...Team\n        }\n        questionnaire {\n          id\n        }\n        status\n        timestampSent\n        timestampAnswered\n        answers {\n          ...QuestionnaireAnswer\n        }\n        relatedMilestones {\n          ...QuestionRelatedMilestones\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; title: string; time: number; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; overlay: { id: string; duration: number; } | null; questions: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }[]; teamQuestionnaireStates: { id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; questionnaire: { id: string; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }[]; }, {}, { fragment: "QuestionnaireDetails"; on: "QuestionnaireType"; masked: false; }>;
    "\n    fragment RestrictedTeam on RestrictedTeam @_unmask {\n      id\n      exercise {\n        ...Exercise\n      }\n      name\n      role\n    }\n  ":
      TadaDocumentNode<{ id: string; exercise: { id: string; name: string; running: boolean; finished: boolean; exerciseStart: string | null; definition: { id: string; name: string; } & { id: string; name: string; }; teams: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }[]; emailParticipants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; timeDelta: number; instructors: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; createdBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }; name: string; role: string; }, {}, { fragment: "RestrictedTeam"; on: "RestrictedTeam"; masked: false; }>;
    "\n    fragment SimplifiedActionLog on ActionLogType @_unmask {\n      ...ActionLogFlat\n      timestamp\n      team {\n        name\n        exercise {\n          id\n        }\n      }\n      channel {\n        id\n      }\n      details {\n        __typename\n        ... on ToolDetailsType {\n          tool {\n            id\n            name\n          }\n          argument\n        }\n        ... on InjectDetailsType {\n          inject {\n            id\n            name\n            organization\n          }\n        }\n        ... on CustomInjectDetailsType {\n          content {\n            raw\n          }\n        }\n        ... on EmailType {\n          thread {\n            id\n            subject\n          }\n          sender {\n            address\n          }\n        }\n        ... on QuestionnaireType {\n          id\n          title\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; requiresAttention: boolean; readReceipt: string | null; todo: boolean; team: { id: string; } & { name: string; exercise: { id: string; }; }; details: ({ __typename: "QuestionnaireType"; id: string; teamQuestionnaireStates: { id: string; team: { id: string; }; questionnaire: { id: string; }; todo: boolean; }[]; } | { __typename: "EmailType"; id: string; todo: boolean; } | { __typename: "CustomInjectDetailsType"; } | { __typename: "InjectDetailsType"; } | { __typename: "ToolDetailsType"; }) & ({ __typename: "QuestionnaireType"; id: string; title: string; } | { __typename: "EmailType"; thread: { id: string; subject: string; }; sender: { address: string; }; } | { __typename: "CustomInjectDetailsType"; content: { raw: string; }; } | { __typename: "InjectDetailsType"; inject: { id: string; name: string; organization: string; }; } | { __typename: "ToolDetailsType"; tool: { id: string; name: string; }; argument: string; }); timestamp: string; channel: { id: string; }; }, {}, { fragment: "SimplifiedActionLog"; on: "ActionLogType"; masked: false; }>;
    "\n    fragment TeamLearningActivity on TeamLearningActivityType @_unmask {\n      id\n      reached\n      activity {\n        ...LearningActivity\n      }\n      milestoneStates {\n        ...MilestoneState\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; reached: boolean | null; activity: { id: string; name: string; description: string; tags: string; milestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; objective: { id: string; }; }; milestoneStates: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }, {}, { fragment: "TeamLearningActivity"; on: "TeamLearningActivityType"; masked: false; }>;
    "\n    fragment TeamLearningObjective on TeamLearningObjectiveType @_unmask {\n      id\n      reached\n      objective {\n        ...LearningObjective\n      }\n      activities {\n        ...TeamLearningActivity\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; reached: boolean | null; objective: { id: string; name: string; description: string; order: number; tags: string; activities: { id: string; name: string; description: string; tags: string; milestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; objective: { id: string; }; }[]; }; activities: { id: string; reached: boolean | null; activity: { id: string; name: string; description: string; tags: string; milestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; objective: { id: string; }; }; milestoneStates: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }, {}, { fragment: "TeamLearningObjective"; on: "TeamLearningObjectiveType"; masked: false; }>;
    "\n    fragment TeamQuestionnaireState on TeamQuestionnaireStateType @_unmask {\n      id\n      team {\n        ...Team\n      }\n      status\n      timestampSent\n      timestampAnswered\n      answers {\n        ...QuestionnaireAnswer\n      }\n      questionnaire {\n        id\n      }\n      relatedMilestones {\n        ...QuestionRelatedMilestones\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; questionnaire: { id: string; }; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }, {}, { fragment: "TeamQuestionnaireState"; on: "TeamQuestionnaireStateType"; masked: false; }>;
    "\n    fragment Tool on ToolType @_unmask {\n      id\n      name\n      category\n      tooltipDescription\n      defaultResponse\n      roles\n      hint\n      definition {\n        ...ExerciseDefinition\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; name: string; category: string; tooltipDescription: string; defaultResponse: string; roles: string; hint: string; definition: { id: string; name: string; }; }, {}, { fragment: "Tool"; on: "ToolType"; masked: false; }>;
    "\n    fragment ToolDetails on ToolDetailsType @_unmask {\n      id\n      tool {\n        ...Tool\n      }\n      argument\n      content {\n        ...Content\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; tool: { id: string; name: string; category: string; tooltipDescription: string; defaultResponse: string; roles: string; hint: string; definition: { id: string; name: string; }; }; argument: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; }, {}, { fragment: "ToolDetails"; on: "ToolDetailsType"; masked: false; }>;
    "\n    fragment User on UserType @_unmask {\n      id\n      lastLogin\n      username\n      firstName\n      lastName\n      dateJoined\n      group\n      isActive\n      isImported\n      tags {\n        ...Tag\n      }\n      teams {\n        ...RestrictedTeam\n      }\n      exercises {\n        ...RestrictedExercise\n      }\n      definitions {\n        ...ExerciseDefinition\n      }\n    }\n  ":
      TadaDocumentNode<{ id: string; lastLogin: string | null; username: string; firstName: string | null; lastName: string | null; dateJoined: string; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE"; isActive: boolean; isImported: boolean; tags: { id: string; name: string; }[]; teams: { id: string; exercise: { id: string; name: string; running: boolean; finished: boolean; exerciseStart: string | null; definition: { id: string; name: string; } & { id: string; name: string; }; teams: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }[]; emailParticipants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; timeDelta: number; instructors: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; createdBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }; name: string; role: string; }[]; exercises: { id: string; name: string; }[]; definitions: { id: string; name: string; }[]; }, {}, { fragment: "User"; on: "UserType"; masked: false; }>;
    "\n    fragment ActionLog on ActionLogType @_unmask {\n      ...SimplifiedActionLog\n      id\n      timestamp\n      team {\n        id\n        name\n        role\n        emailAddress {\n          ...EmailParticipant\n        }\n        exercise {\n          id\n          name\n        }\n      }\n      channel {\n        id\n      }\n      todo\n      type\n      details {\n        __typename\n        ... on ToolDetailsType {\n          ...ToolDetails\n        }\n        ... on InjectDetailsType {\n          ...InjectDetails\n        }\n        ... on CustomInjectDetailsType {\n          ...CustomInjectDetails\n        }\n        ... on EmailType {\n          ...EmailDetails\n        }\n        ... on QuestionnaireType {\n          ...QuestionnaireDetails\n        }\n      }\n      readReceipt\n      requiresAttention\n    }\n  ":
      TadaDocumentNode<{ id: string; type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; requiresAttention: boolean; readReceipt: string | null; todo: boolean; team: { id: string; } & { name: string; exercise: { id: string; }; } & { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; }; details: (({ __typename: "QuestionnaireType"; id: string; teamQuestionnaireStates: { id: string; team: { id: string; }; questionnaire: { id: string; }; todo: boolean; }[]; } | { __typename: "EmailType"; id: string; todo: boolean; } | { __typename: "CustomInjectDetailsType"; } | { __typename: "InjectDetailsType"; } | { __typename: "ToolDetailsType"; }) & ({ __typename: "QuestionnaireType"; id: string; title: string; } | { __typename: "EmailType"; thread: { id: string; subject: string; }; sender: { address: string; }; } | { __typename: "CustomInjectDetailsType"; content: { raw: string; }; } | { __typename: "InjectDetailsType"; inject: { id: string; name: string; organization: string; }; } | { __typename: "ToolDetailsType"; tool: { id: string; name: string; }; argument: string; })) & ({ __typename: "QuestionnaireType"; id: string; title: string; time: number; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; overlay: { id: string; duration: number; } | null; questions: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }[]; teamQuestionnaireStates: { id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; questionnaire: { id: string; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }[]; } | { __typename: "EmailType"; id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; timestamp: string; readReceipt: string | null; } | { __typename: "CustomInjectDetailsType"; id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; } | { __typename: "InjectDetailsType"; id: string; inject: { id: string; name: string; time: number; delay: number; organization: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; target: { id: string; name: string; displayName: string; description: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; readReceipt: { isUnread: boolean | null; teamId: string; id: string; }[]; }; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; confirmation: { id: string; text: string; } | null; confirmed: boolean | null; confirmedBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampConfirmed: string | null; } | { __typename: "ToolDetailsType"; id: string; tool: { id: string; name: string; category: string; tooltipDescription: string; defaultResponse: string; roles: string; hint: string; definition: { id: string; name: string; }; }; argument: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; }); timestamp: string; channel: { id: string; } & { id: string; }; }, {}, { fragment: "ActionLog"; on: "ActionLogType"; masked: false; }>;
    "\n    fragment EmailDraft on EmailDraftType @_unmask {\n      teamId\n      instructor\n      emailThreadId\n      senderAddress\n      content\n      activateMilestone\n      deactivateMilestone\n      fileId\n      selectedContacts\n      subject\n      templateId\n    }\n  ":
      TadaDocumentNode<{ teamId: string; instructor: boolean; emailThreadId: string | null; senderAddress: string | null; content: string | null; activateMilestone: string | null; deactivateMilestone: string | null; fileId: string | null; selectedContacts: (string | null)[] | null; subject: string | null; templateId: string | null; }, {}, { fragment: "EmailDraft"; on: "EmailDraftType"; masked: false; }>;
    "\n    mutation DeleteEmailDraft(\n      $teamId: ID!\n      $instructor: Boolean!\n      $emailThreadId: ID\n    ) {\n      deleteEmailDraft(\n        teamId: $teamId\n        instructor: $instructor\n        emailThreadId: $emailThreadId\n      ) @client {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ deleteEmailDraft: { operationDone: boolean | null; } | null; }, { emailThreadId?: string | null | undefined; instructor: boolean; teamId: string; }, void>;
    "\n    mutation ReloadDefinitions {\n      reloadDefinitions @client {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ reloadDefinitions: { operationDone: boolean | null; } | null; }, {}, void>;
    "\n    mutation ReloadExercises {\n      reloadExercises @client {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ reloadExercises: { operationDone: boolean | null; } | null; }, {}, void>;
    "\n    mutation ReloadTable {\n      reloadTable @client {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ reloadTable: { operationDone: boolean | null; } | null; }, {}, void>;
    "\n    mutation SetEmailDraft($emailDraft: EmailDraftInput!) {\n      setEmailDraft(emailDraft: $emailDraft) @client {\n        ...EmailDraft\n      }\n    }\n  ":
      TadaDocumentNode<{ setEmailDraft: { teamId: string; instructor: boolean; emailThreadId: string | null; senderAddress: string | null; content: string | null; activateMilestone: string | null; deactivateMilestone: string | null; fileId: string | null; selectedContacts: (string | null)[] | null; subject: string | null; templateId: string | null; } | null; }, { emailDraft: { templateId?: string | null | undefined; teamId: string; subject?: string | null | undefined; senderAddress?: string | null | undefined; selectedContacts?: (string | null)[] | null | undefined; instructor: boolean; fileId?: string | null | undefined; emailThreadId?: string | null | undefined; deactivateMilestone?: string | null | undefined; content?: string | null | undefined; activateMilestone?: string | null | undefined; }; }, void>;
    "\n    mutation SetEmailThreadArchive($emailThreadId: ID!, $state: Boolean!) {\n      setArchiveEmail(emailThreadId: $emailThreadId, state: $state) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ setArchiveEmail: { operationDone: boolean | null; } | null; }, { state: boolean; emailThreadId: string; }, void>;
    "\n    mutation setIsUnreadChannel(\n      $channelId: ID!\n      $teamId: ID!\n      $isUnread: Boolean!\n    ) {\n      setIsUnreadChannel(\n        channelId: $channelId\n        teamId: $teamId\n        isUnread: $isUnread\n      ) @client {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ setIsUnreadChannel: { operationDone: boolean | null; } | null; }, { isUnread: boolean; teamId: string; channelId: string; }, void>;
    "\n    mutation setIsUnreadEmailThread(\n      $threadId: ID!\n      $teamId: ID!\n      $isUnread: Boolean!\n    ) {\n      setIsUnreadEmailThread(\n        threadId: $threadId\n        teamId: $teamId\n        isUnread: $isUnread\n      ) @client {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ setIsUnreadEmailThread: { operationDone: boolean | null; } | null; }, { isUnread: boolean; teamId: string; threadId: string; }, void>;
    "\n    mutation SetTodoActionLog($actionLogId: ID!, $state: Boolean!) {\n      setTodoActionLog(actionLogId: $actionLogId, state: $state) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ setTodoActionLog: { operationDone: boolean | null; } | null; }, { state: boolean; actionLogId: string; }, void>;
    "\n    mutation SetEmailTodo($emailId: ID!, $state: Boolean!) {\n      setEmailTodo(emailId: $emailId, state: $state) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ setEmailTodo: { operationDone: boolean | null; } | null; }, { state: boolean; emailId: string; }, void>;
    "\n    mutation SetTeamQuestionnaireTodo(\n      $questionnaireId: ID!\n      $teamId: ID!\n      $state: Boolean!\n    ) {\n      setTeamQuestionnaireTodo(\n        questionnaireId: $questionnaireId\n        teamId: $teamId\n        state: $state\n      ) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ setTeamQuestionnaireTodo: { operationDone: boolean | null; } | null; }, { state: boolean; teamId: string; questionnaireId: string; }, void>;
    "\n    mutation WriteReadReceipt($actionLogId: ID!) {\n      writeReadReceipt(actionLogId: $actionLogId) @client {\n        actionLogId\n        readReceipt\n      }\n    }\n  ":
      TadaDocumentNode<{ writeReadReceipt: { actionLogId: string; readReceipt: string | null; } | null; }, { actionLogId: string; }, void>;
    "\n    mutation WriteReadReceiptEmail($emailId: ID!) {\n      writeReadReceiptEmail(emailId: $emailId) @client {\n        emailId\n        readReceipt\n      }\n    }\n  ":
      TadaDocumentNode<{ writeReadReceiptEmail: { emailId: string; readReceipt: string | null; } | null; }, { emailId: string; }, void>;
    "\n    mutation AddDefinitionAccess($definitionId: ID!, $userIds: [ID]!) {\n      addDefinitionAccess(definitionId: $definitionId, userIds: $userIds) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ addDefinitionAccess: { operationDone: boolean; } | null; }, { userIds: (string | null)[]; definitionId: string; }, void>;
    "\n    mutation AnswerQuestionnaire($questInput: QuestionnaireInput!) {\n      answerQuestionnaire(questInput: $questInput) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ answerQuestionnaire: { operationDone: boolean; } | null; }, { questInput: { teamId: string; questionnaireId: string; answers: { value: string; questionId: string; }[]; }; }, void>;
    "\n    mutation AssignInstructorsToExercise($exerciseId: ID!, $userIds: [ID]!) {\n      assignInstructorsToExercise(exerciseId: $exerciseId, userIds: $userIds) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ assignInstructorsToExercise: { operationDone: boolean; } | null; }, { userIds: (string | null)[]; exerciseId: string; }, void>;
    "\n    mutation AssignUsersByTags(\n      $exerciseId: ID!\n      $tagPrefix: String!\n      $userIds: [ID!]!\n    ) {\n      assignUsersByTags(\n        exerciseId: $exerciseId\n        tagPrefix: $tagPrefix\n        userIds: $userIds\n      ) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ assignUsersByTags: { operationDone: boolean; } | null; }, { userIds: string[]; tagPrefix: string; exerciseId: string; }, void>;
    "\n    mutation AssignUsersEqually($exerciseId: ID!, $userIds: [ID!]!) {\n      assignUsersEqually(exerciseId: $exerciseId, userIds: $userIds) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ assignUsersEqually: { operationDone: boolean; } | null; }, { userIds: string[]; exerciseId: string; }, void>;
    "\n    mutation AssignUsersToTeam($teamId: ID!, $userIds: [ID]!) {\n      assignUsersToTeam(teamId: $teamId, userIds: $userIds) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ assignUsersToTeam: { operationDone: boolean; } | null; }, { userIds: (string | null)[]; teamId: string; }, void>;
    "\n    mutation ChangeUserData(\n      $userId: UUID!\n      $group: AuthGroup\n      $active: Boolean\n    ) {\n      changeUserData(\n        changeUserInput: { userId: $userId, group: $group, active: $active }\n      ) {\n        user {\n          ...User\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ changeUserData: { user: { id: string; lastLogin: string | null; username: string; firstName: string | null; lastName: string | null; dateJoined: string; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE"; isActive: boolean; isImported: boolean; tags: { id: string; name: string; }[]; teams: { id: string; exercise: { id: string; name: string; running: boolean; finished: boolean; exerciseStart: string | null; definition: { id: string; name: string; } & { id: string; name: string; }; teams: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }[]; emailParticipants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; timeDelta: number; instructors: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; createdBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }; name: string; role: string; }[]; exercises: { id: string; name: string; }[]; definitions: { id: string; name: string; }[]; }; } | null; }, { active?: boolean | null | undefined; group?: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null | undefined; userId: string; }, void>;
    "\n    mutation Confirm($logId: ID!, $teamId: ID!) {\n      confirmAction(logId: $logId, teamId: $teamId) {\n        actionLog {\n          id\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ confirmAction: { actionLog: { id: string; }; } | null; }, { teamId: string; logId: string; }, void>;
    "\n    mutation CopyUsersAssignment($fromExerciseId: ID!, $toExerciseId: ID!) {\n      copyUsersAssignment(\n        fromExerciseId: $fromExerciseId\n        toExerciseId: $toExerciseId\n      ) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ copyUsersAssignment: { operationDone: boolean; } | null; }, { toExerciseId: string; fromExerciseId: string; }, void>;
    "\n    mutation CreateExercises($id: ID!, $teamCount: Int!, $name: String) {\n      createExercise(\n        createExerciseInput: {\n          definitionId: $id\n          teamCount: $teamCount\n          name: $name\n        }\n      ) {\n        exercise {\n          ...Exercise\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ createExercise: { exercise: { id: string; name: string; running: boolean; finished: boolean; exerciseStart: string | null; definition: { id: string; name: string; } & { id: string; name: string; }; teams: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }[]; emailParticipants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; timeDelta: number; instructors: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; createdBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }; } | null; }, { name?: string | null | undefined; teamCount: number; id: string; }, void>;
    "\n    mutation CreateThread(\n      $exerciseId: ID!\n      $participantAddresses: [String]!\n      $subject: String!\n    ) {\n      createThread(\n        exerciseId: $exerciseId\n        participantAddresses: $participantAddresses\n        subject: $subject\n      ) {\n        thread {\n          ...EmailThread\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ createThread: { thread: { id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }; } | null; }, { subject: string; participantAddresses: (string | null)[]; exerciseId: string; }, void>;
    "\n    mutation CreateUser(\n      $email: String!\n      $firstName: String\n      $lastName: String\n      $tags: [String!]!\n      $group: AuthGroup\n    ) {\n      createUser(\n        createUserInput: {\n          email: $email\n          firstName: $firstName\n          lastName: $lastName\n          tags: $tags\n          group: $group\n        }\n      ) {\n        newUser {\n          ...RestrictedUserF\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ createUser: { newUser: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }; } | null; }, { group?: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null | undefined; tags: string[]; lastName?: string | null | undefined; firstName?: string | null | undefined; email: string; }, void>;
    "\n    mutation DeleteDefinition($definitionId: ID!) {\n      deleteDefinition(definitionId: $definitionId) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ deleteDefinition: { operationDone: boolean; } | null; }, { definitionId: string; }, void>;
    "\n    mutation DeleteExercise($id: ID!) {\n      deleteExercise(exerciseId: $id) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ deleteExercise: { operationDone: boolean; } | null; }, { id: string; }, void>;
    "\n    mutation DeleteUsers($userIds: [ID]!) {\n      deleteUsers(userIds: $userIds) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ deleteUsers: { operationDone: boolean; } | null; }, { userIds: (string | null)[]; }, void>;
    "\n    mutation MoveTime($exerciseId: ID!, $timeDiff: Int!) {\n      moveTime(exerciseId: $exerciseId, timeDiff: $timeDiff) {\n        exercise {\n          ...Exercise\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ moveTime: { exercise: { id: string; name: string; running: boolean; finished: boolean; exerciseStart: string | null; definition: { id: string; name: string; } & { id: string; name: string; }; teams: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }[]; emailParticipants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; timeDelta: number; instructors: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; createdBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }; } | null; }, { timeDiff: number; exerciseId: string; }, void>;
    "\n    mutation PerformTeamToolAction(\n      $teamId: ID!\n      $toolArgument: String!\n      $toolId: ID!\n    ) {\n      useTool(\n        useToolInput: {\n          teamId: $teamId\n          toolArgument: $toolArgument\n          toolId: $toolId\n        }\n      ) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ useTool: { operationDone: boolean; } | null; }, { toolId: string; toolArgument: string; teamId: string; }, void>;
    "\n    mutation RegenerateCredentials($userIds: [ID]!) {\n      regenerateCredentials(userIds: $userIds) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ regenerateCredentials: { operationDone: boolean; } | null; }, { userIds: (string | null)[]; }, void>;
    "\n    mutation RemoveDefinitionAccess($definitionId: ID!, $userIds: [ID]!) {\n      removeDefinitionAccess(definitionId: $definitionId, userIds: $userIds) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ removeDefinitionAccess: { operationDone: boolean; } | null; }, { userIds: (string | null)[]; definitionId: string; }, void>;
    "\n    mutation RemoveInstructorsFromExercise($exerciseId: ID!, $userIds: [ID]!) {\n      removeInstructorsFromExercise(\n        exerciseId: $exerciseId\n        userIds: $userIds\n      ) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ removeInstructorsFromExercise: { operationDone: boolean; } | null; }, { userIds: (string | null)[]; exerciseId: string; }, void>;
    "\n    mutation RemoveUsersFromTeam($teamId: ID!, $userIds: [ID]!) {\n      removeUsersFromTeam(teamId: $teamId, userIds: $userIds) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ removeUsersFromTeam: { operationDone: boolean; } | null; }, { userIds: (string | null)[]; teamId: string; }, void>;
    "\n    mutation ReviewQuestionnaire($reviewInput: QuestionnaireReviewInput!) {\n      reviewQuestionnaire(reviewInput: $reviewInput) {\n        updatedState {\n          ...TeamQuestionnaireState\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ reviewQuestionnaire: { updatedState: { id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; questionnaire: { id: string; }; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }; } | null; }, { reviewInput: { teamId: string; questionnaireId: string; deactivateMilestones: string[]; activateMilestones: string[]; }; }, void>;
    "\n    mutation SendCustomInject($customInjectInput: CustomInjectInput!) {\n      sendCustomInject(customInjectInput: $customInjectInput) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ sendCustomInject: { operationDone: boolean; } | null; }, { customInjectInput: { teamIds: (string | null)[]; overlay?: { duration: number; } | null | undefined; fileId?: string | null | undefined; exerciseId: string; content: string; channelId: string; }; }, void>;
    "\n    mutation SendEmail($sendEmailInput: SendEmailInput!) {\n      sendEmail(sendEmailInput: $sendEmailInput) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ sendEmail: { operationDone: boolean; } | null; }, { sendEmailInput: { threadId: string; senderAddress: string; fileId?: string | null | undefined; deactivateMilestone?: string | null | undefined; content?: string | null | undefined; activateMilestone?: string | null | undefined; }; }, void>;
    "\n    mutation SetMilestone(\n      $activate: Boolean!\n      $milestone: String!\n      $teamId: ID!\n    ) {\n      modifyMilestone(\n        activate: $activate\n        milestone: $milestone\n        teamId: $teamId\n      ) {\n        operationDone\n      }\n    }\n  ":
      TadaDocumentNode<{ modifyMilestone: { operationDone: boolean; } | null; }, { teamId: string; milestone: string; activate: boolean; }, void>;
    "\n    mutation StartExercise($id: ID!) {\n      startExercise(exerciseId: $id) {\n        exercise {\n          id\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ startExercise: { exercise: { id: string; }; } | null; }, { id: string; }, void>;
    "\n    mutation StopExercise($id: ID!) {\n      stopExercise(exerciseId: $id) {\n        exercise {\n          id\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ stopExercise: { exercise: { id: string; }; } | null; }, { id: string; }, void>;
    "\n    query GetEmailDraft(\n      $teamId: ID!\n      $instructor: Boolean!\n      $emailThreadId: ID\n    ) {\n      getEmailDraft(\n        teamId: $teamId\n        instructor: $instructor\n        emailThreadId: $emailThreadId\n      ) @client {\n        ...EmailDraft\n      }\n    }\n  ":
      TadaDocumentNode<{ getEmailDraft: { teamId: string; instructor: boolean; emailThreadId: string | null; senderAddress: string | null; content: string | null; activateMilestone: string | null; deactivateMilestone: string | null; fileId: string | null; selectedContacts: (string | null)[] | null; subject: string | null; templateId: string | null; } | null; }, { emailThreadId?: string | null | undefined; instructor: boolean; teamId: string; }, void>;
    "\n    query GetEmailDrafts($teamId: ID!, $instructor: Boolean!) {\n      getEmailDrafts(teamId: $teamId, instructor: $instructor) @client {\n        ...EmailDraft\n      }\n    }\n  ":
      TadaDocumentNode<{ getEmailDrafts: ({ teamId: string; instructor: boolean; emailThreadId: string | null; senderAddress: string | null; content: string | null; activateMilestone: string | null; deactivateMilestone: string | null; fileId: string | null; selectedContacts: (string | null)[] | null; subject: string | null; templateId: string | null; } | null)[] | null; }, { instructor: boolean; teamId: string; }, void>;
    "\n    query GetAnalyticsActionLogs($exerciseId: ID!, $newestFirst: Boolean) {\n      analyticsActionLogs(exerciseId: $exerciseId, newestFirst: $newestFirst) {\n        ...ActionLog\n      }\n    }\n  ":
      TadaDocumentNode<{ analyticsActionLogs: { id: string; type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; requiresAttention: boolean; readReceipt: string | null; todo: boolean; team: { id: string; } & { name: string; exercise: { id: string; }; } & { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; }; details: (({ __typename: "QuestionnaireType"; id: string; teamQuestionnaireStates: { id: string; team: { id: string; }; questionnaire: { id: string; }; todo: boolean; }[]; } | { __typename: "EmailType"; id: string; todo: boolean; } | { __typename: "CustomInjectDetailsType"; } | { __typename: "InjectDetailsType"; } | { __typename: "ToolDetailsType"; }) & ({ __typename: "QuestionnaireType"; id: string; title: string; } | { __typename: "EmailType"; thread: { id: string; subject: string; }; sender: { address: string; }; } | { __typename: "CustomInjectDetailsType"; content: { raw: string; }; } | { __typename: "InjectDetailsType"; inject: { id: string; name: string; organization: string; }; } | { __typename: "ToolDetailsType"; tool: { id: string; name: string; }; argument: string; })) & ({ __typename: "QuestionnaireType"; id: string; title: string; time: number; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; overlay: { id: string; duration: number; } | null; questions: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }[]; teamQuestionnaireStates: { id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; questionnaire: { id: string; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }[]; } | { __typename: "EmailType"; id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; timestamp: string; readReceipt: string | null; } | { __typename: "CustomInjectDetailsType"; id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; } | { __typename: "InjectDetailsType"; id: string; inject: { id: string; name: string; time: number; delay: number; organization: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; target: { id: string; name: string; displayName: string; description: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; readReceipt: { isUnread: boolean | null; teamId: string; id: string; }[]; }; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; confirmation: { id: string; text: string; } | null; confirmed: boolean | null; confirmedBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampConfirmed: string | null; } | { __typename: "ToolDetailsType"; id: string; tool: { id: string; name: string; category: string; tooltipDescription: string; defaultResponse: string; roles: string; hint: string; definition: { id: string; name: string; }; }; argument: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; }); timestamp: string; channel: { id: string; } & { id: string; }; }[]; }, { newestFirst?: boolean | null | undefined; exerciseId: string; }, void>;
    "\n    query GetAnalyticsActionLogsFlat($exerciseId: ID!, $newestFirst: Boolean) {\n      analyticsActionLogs(exerciseId: $exerciseId, newestFirst: $newestFirst) {\n        ...ActionLogFlat\n      }\n    }\n  ":
      TadaDocumentNode<{ analyticsActionLogs: { id: string; type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; requiresAttention: boolean; readReceipt: string | null; todo: boolean; team: { id: string; }; details: { __typename: "QuestionnaireType"; id: string; teamQuestionnaireStates: { id: string; team: { id: string; }; questionnaire: { id: string; }; todo: boolean; }[]; } | { __typename: "EmailType"; id: string; todo: boolean; } | { __typename: "CustomInjectDetailsType"; } | { __typename: "InjectDetailsType"; } | { __typename: "ToolDetailsType"; }; }[]; }, { newestFirst?: boolean | null | undefined; exerciseId: string; }, void>;
    "\n    query GetAnalyticsEmailThreads($exerciseId: ID!) {\n      analyticsEmailThreads(exerciseId: $exerciseId) {\n        ...EmailThread\n      }\n    }\n  ":
      TadaDocumentNode<{ analyticsEmailThreads: { id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }[]; }, { exerciseId: string; }, void>;
    "\n    query GetAnalyticsMilestones($exerciseId: ID!) {\n      analyticsMilestones(exerciseId: $exerciseId) {\n        activity {\n          id\n          activity {\n            ...LearningActivity\n          }\n          reached\n          milestoneStates {\n            id\n          }\n          teamObjective {\n            id\n            reached\n            objective {\n              ...LearningObjective\n            }\n            activities {\n              id\n            }\n          }\n        }\n        ...MilestoneState\n      }\n    }\n  ":
      TadaDocumentNode<{ analyticsMilestones: { activity: { id: string; activity: { id: string; name: string; description: string; tags: string; milestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; objective: { id: string; }; }; reached: boolean | null; milestoneStates: { id: string; }[]; teamObjective: { id: string; reached: boolean | null; objective: { id: string; name: string; description: string; order: number; tags: string; activities: { id: string; name: string; description: string; tags: string; milestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; objective: { id: string; }; }[]; }; activities: { id: string; }[]; }; } | null; id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }, { exerciseId: string; }, void>;
    "\n    query GetAutoInjects($exerciseId: ID!) {\n      injects(exerciseId: $exerciseId) {\n        ...DefinitionInject\n      }\n    }\n  ":
      TadaDocumentNode<{ injects: { id: string; name: string; time: number; delay: number; organization: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; target: { id: string; name: string; displayName: string; description: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; readReceipt: { isUnread: boolean | null; teamId: string; id: string; }[]; }; }[]; }, { exerciseId: string; }, void>;
    "\n    query GetChannel($channelId: ID!) {\n      channel(channelId: $channelId) {\n        ...Channel\n      }\n    }\n  ":
      TadaDocumentNode<{ channel: { id: string; name: string; displayName: string; description: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; readReceipt: { isUnread: boolean | null; teamId: string; id: string; }[]; }; }, { channelId: string; }, void>;
    "\n    query GetDefinition($definitionId: ID!) {\n      definition(definitionId: $definitionId) {\n        ...Definition\n      }\n    }\n  ":
      TadaDocumentNode<{ definition: { id: string; name: string; description: string; prerequisites: string[]; targetAudience: string; version: string; channels: { id: string; name: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; displayName: string; description: string; }[]; roles: { id: string; name: string; displayName: string; description: string; }[]; maintainers: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; uploadedBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }; }, { definitionId: string; }, void>;
    "\n    query GetDefinitions {\n      definitions {\n        ...Definition\n      }\n    }\n  ":
      TadaDocumentNode<{ definitions: { id: string; name: string; description: string; prerequisites: string[]; targetAudience: string; version: string; channels: { id: string; name: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; displayName: string; description: string; }[]; roles: { id: string; name: string; displayName: string; description: string; }[]; maintainers: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; uploadedBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }[]; }, {}, void>;
    "\n    query GetEmailAddresses($threadId: ID!) {\n      emailAddresses(threadId: $threadId)\n    }\n  ":
      TadaDocumentNode<{ emailAddresses: string[]; }, { threadId: string; }, void>;
    "\n    query GetEmailContacts($visibleOnly: Boolean = false) {\n      emailContacts(visibleOnly: $visibleOnly) {\n        ...EmailParticipant\n      }\n    }\n  ":
      TadaDocumentNode<{ emailContacts: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; }, { visibleOnly?: boolean | null | undefined; }, void>;
    "\n    query GetEmailTemplate($templateId: ID!) {\n      threadTemplate(templateId: $templateId) {\n        ...EmailTemplate\n      }\n    }\n  ":
      TadaDocumentNode<{ threadTemplate: { id: string; sender: string; context: string; subject: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }; }, { templateId: string; }, void>;
    "\n    query GetEmailTemplates($exerciseId: ID!, $emailAddresses: [String]!) {\n      emailTemplates(exerciseId: $exerciseId, emailAddresses: $emailAddresses) {\n        ...EmailTemplate\n      }\n    }\n  ":
      TadaDocumentNode<{ emailTemplates: { id: string; sender: string; context: string; subject: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }, { emailAddresses: (string | null)[]; exerciseId: string; }, void>;
    "\n    query GetEmailThread($threadId: ID!) {\n      emailThread(threadId: $threadId) {\n        ...EmailThread\n      }\n    }\n  ":
      TadaDocumentNode<{ emailThread: { id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }; }, { threadId: string; }, void>;
    "\n    query GetEmailThreads(\n      $teamId: ID!\n      $received: Boolean = true\n      $sent: Boolean = true\n      $archived: Boolean = false\n    ) {\n      emailThreads(teamId: $teamId)\n        @_filterEmails(received: $received, sent: $sent, archived: $archived) {\n        id\n        ...EmailThread @_unmask\n      }\n    }\n  ":
      TadaDocumentNode<{ emailThreads: { id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }[]; }, { archived?: boolean | null | undefined; sent?: boolean | null | undefined; received?: boolean | null | undefined; teamId: string; }, void>;
    "\n    query GetExercise($exerciseId: ID!) {\n      exerciseId(exerciseId: $exerciseId) {\n        ...Exercise\n      }\n    }\n  ":
      TadaDocumentNode<{ exerciseId: { id: string; name: string; running: boolean; finished: boolean; exerciseStart: string | null; definition: { id: string; name: string; } & { id: string; name: string; }; teams: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }[]; emailParticipants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; timeDelta: number; instructors: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; createdBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }; }, { exerciseId: string; }, void>;
    "\n    query GetExerciseChannels($exerciseId: ID!) {\n      exerciseChannels(exerciseId: $exerciseId) {\n        id\n        name\n        type\n        displayName\n        description\n        readReceipt {\n          teamId\n          isUnread\n          id\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ exerciseChannels: { id: string; name: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; displayName: string; description: string; readReceipt: { teamId: string; isUnread: boolean | null; id: string; }[]; }[]; }, { exerciseId: string; }, void>;
    "\n    query GetExerciseConfig($exerciseId: ID!, $teamId: ID!) {\n      exerciseConfig(exerciseId: $exerciseId) {\n        ...ExerciseConfig\n      }\n      teamTools(teamId: $teamId) {\n        ...Tool\n      }\n    }\n  ":
      TadaDocumentNode<{ exerciseConfig: { exerciseDuration: number | null; emailBetweenTeams: boolean | null; showExerciseTime: boolean | null; enableRoles: boolean | null; customEmailSuffix: string | null; }; teamTools: { id: string; name: string; category: string; tooltipDescription: string; defaultResponse: string; roles: string; hint: string; definition: { id: string; name: string; }; }[]; }, { teamId: string; exerciseId: string; }, void>;
    "\n    query GetExerciseLoopStatus($exerciseId: ID!) {\n      exerciseLoopRunning(exerciseId: $exerciseId)\n    }\n  ":
      TadaDocumentNode<{ exerciseLoopRunning: boolean; }, { exerciseId: string; }, void>;
    "\n    query GetExerciseQuestionnaires($exerciseId: ID!) {\n      questionnaires(exerciseId: $exerciseId) {\n        ...QuestionnaireDetails\n      }\n    }\n  ":
      TadaDocumentNode<{ questionnaires: { id: string; title: string; time: number; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; overlay: { id: string; duration: number; } | null; questions: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }[]; teamQuestionnaireStates: { id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; questionnaire: { id: string; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }[]; }[]; }, { exerciseId: string; }, void>;
    "\n    query GetExercises {\n      exercises {\n        ...Exercise\n      }\n    }\n  ":
      TadaDocumentNode<{ exercises: { id: string; name: string; running: boolean; finished: boolean; exerciseStart: string | null; definition: { id: string; name: string; } & { id: string; name: string; }; teams: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }[]; emailParticipants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; timeDelta: number; instructors: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; createdBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }[]; }, {}, void>;
    "\n    query GetExerciseTimeLeft {\n      exerciseTimeLeft\n    }\n  ":
      TadaDocumentNode<{ exerciseTimeLeft: number; }, {}, void>;
    "\n    query GetExerciseWithConfig($exerciseId: ID!) {\n      exerciseId(exerciseId: $exerciseId) {\n        ...Exercise\n      }\n      exerciseConfig(exerciseId: $exerciseId) {\n        ...ExerciseConfig\n      }\n    }\n  ":
      TadaDocumentNode<{ exerciseId: { id: string; name: string; running: boolean; finished: boolean; exerciseStart: string | null; definition: { id: string; name: string; } & { id: string; name: string; }; teams: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }[]; emailParticipants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; timeDelta: number; instructors: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; createdBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }; exerciseConfig: { exerciseDuration: number | null; emailBetweenTeams: boolean | null; showExerciseTime: boolean | null; enableRoles: boolean | null; customEmailSuffix: string | null; }; }, { exerciseId: string; }, void>;
    "\n    query GetFileInfo($fileInfoId: UUID!) {\n      fileInfo(fileInfoId: $fileInfoId) {\n        ...FileInfo\n      }\n    }\n  ":
      TadaDocumentNode<{ fileInfo: { id: string; fileName: string; }; }, { fileInfoId: string; }, void>;
    "\n    query GetMilestones($exerciseId: ID!) {\n      milestones(exerciseId: $exerciseId) {\n        ...Milestone\n      }\n    }\n  ":
      TadaDocumentNode<{ milestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; }, { exerciseId: string; }, void>;
    "\n    query GetRunningExercises {\n      exercises(running: true) {\n        ...Exercise\n      }\n    }\n  ":
      TadaDocumentNode<{ exercises: { id: string; name: string; running: boolean; finished: boolean; exerciseStart: string | null; definition: { id: string; name: string; } & { id: string; name: string; }; teams: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }[]; emailParticipants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; timeDelta: number; instructors: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; createdBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }[]; }, {}, void>;
    "\n    query GetSingleActionLog($logId: ID!) {\n      actionLog(logId: $logId) {\n        ...ActionLog\n      }\n    }\n  ":
      TadaDocumentNode<{ actionLog: { id: string; type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; requiresAttention: boolean; readReceipt: string | null; todo: boolean; team: { id: string; } & { name: string; exercise: { id: string; }; } & { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; }; details: (({ __typename: "QuestionnaireType"; id: string; teamQuestionnaireStates: { id: string; team: { id: string; }; questionnaire: { id: string; }; todo: boolean; }[]; } | { __typename: "EmailType"; id: string; todo: boolean; } | { __typename: "CustomInjectDetailsType"; } | { __typename: "InjectDetailsType"; } | { __typename: "ToolDetailsType"; }) & ({ __typename: "QuestionnaireType"; id: string; title: string; } | { __typename: "EmailType"; thread: { id: string; subject: string; }; sender: { address: string; }; } | { __typename: "CustomInjectDetailsType"; content: { raw: string; }; } | { __typename: "InjectDetailsType"; inject: { id: string; name: string; organization: string; }; } | { __typename: "ToolDetailsType"; tool: { id: string; name: string; }; argument: string; })) & ({ __typename: "QuestionnaireType"; id: string; title: string; time: number; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; overlay: { id: string; duration: number; } | null; questions: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }[]; teamQuestionnaireStates: { id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; questionnaire: { id: string; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }[]; } | { __typename: "EmailType"; id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; timestamp: string; readReceipt: string | null; } | { __typename: "CustomInjectDetailsType"; id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; } | { __typename: "InjectDetailsType"; id: string; inject: { id: string; name: string; time: number; delay: number; organization: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; target: { id: string; name: string; displayName: string; description: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; readReceipt: { isUnread: boolean | null; teamId: string; id: string; }[]; }; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; confirmation: { id: string; text: string; } | null; confirmed: boolean | null; confirmedBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampConfirmed: string | null; } | { __typename: "ToolDetailsType"; id: string; tool: { id: string; name: string; category: string; tooltipDescription: string; defaultResponse: string; roles: string; hint: string; definition: { id: string; name: string; }; }; argument: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; }); timestamp: string; channel: { id: string; } & { id: string; }; }; }, { logId: string; }, void>;
    "\n    query GetTags {\n      tags {\n        ...Tag\n      }\n    }\n  ":
      TadaDocumentNode<{ tags: { id: string; name: string; }[]; }, {}, void>;
    "\n    query GetTeam($teamId: ID!) {\n      team(teamId: $teamId) {\n        ...Team\n      }\n    }\n  ":
      TadaDocumentNode<{ team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; }, { teamId: string; }, void>;
    "\n    query GetTeamActionLogs($teamId: ID!) {\n      actionLogs: teamActionLogs(teamId: $teamId) {\n        ...ActionLog\n      }\n    }\n  ":
      TadaDocumentNode<{ actionLogs: { id: string; type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; requiresAttention: boolean; readReceipt: string | null; todo: boolean; team: { id: string; } & { name: string; exercise: { id: string; }; } & { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; }; details: (({ __typename: "QuestionnaireType"; id: string; teamQuestionnaireStates: { id: string; team: { id: string; }; questionnaire: { id: string; }; todo: boolean; }[]; } | { __typename: "EmailType"; id: string; todo: boolean; } | { __typename: "CustomInjectDetailsType"; } | { __typename: "InjectDetailsType"; } | { __typename: "ToolDetailsType"; }) & ({ __typename: "QuestionnaireType"; id: string; title: string; } | { __typename: "EmailType"; thread: { id: string; subject: string; }; sender: { address: string; }; } | { __typename: "CustomInjectDetailsType"; content: { raw: string; }; } | { __typename: "InjectDetailsType"; inject: { id: string; name: string; organization: string; }; } | { __typename: "ToolDetailsType"; tool: { id: string; name: string; }; argument: string; })) & ({ __typename: "QuestionnaireType"; id: string; title: string; time: number; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; overlay: { id: string; duration: number; } | null; questions: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }[]; teamQuestionnaireStates: { id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; questionnaire: { id: string; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }[]; } | { __typename: "EmailType"; id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; timestamp: string; readReceipt: string | null; } | { __typename: "CustomInjectDetailsType"; id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; } | { __typename: "InjectDetailsType"; id: string; inject: { id: string; name: string; time: number; delay: number; organization: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; target: { id: string; name: string; displayName: string; description: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; readReceipt: { isUnread: boolean | null; teamId: string; id: string; }[]; }; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; confirmation: { id: string; text: string; } | null; confirmed: boolean | null; confirmedBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampConfirmed: string | null; } | { __typename: "ToolDetailsType"; id: string; tool: { id: string; name: string; category: string; tooltipDescription: string; defaultResponse: string; roles: string; hint: string; definition: { id: string; name: string; }; }; argument: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; }); timestamp: string; channel: { id: string; } & { id: string; }; }[]; }, { teamId: string; }, void>;
    "\n    query GetTeamActionLogsFlat($teamId: ID!) {\n      actionLogs: teamActionLogs(teamId: $teamId) {\n        ...ActionLogFlat\n      }\n    }\n  ":
      TadaDocumentNode<{ actionLogs: { id: string; type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; requiresAttention: boolean; readReceipt: string | null; todo: boolean; team: { id: string; }; details: { __typename: "QuestionnaireType"; id: string; teamQuestionnaireStates: { id: string; team: { id: string; }; questionnaire: { id: string; }; todo: boolean; }[]; } | { __typename: "EmailType"; id: string; todo: boolean; } | { __typename: "CustomInjectDetailsType"; } | { __typename: "InjectDetailsType"; } | { __typename: "ToolDetailsType"; }; }[]; }, { teamId: string; }, void>;
    "\n    query GetTeamChannelLogs($teamId: ID!, $channelId: ID!) {\n      teamChannelLogs(teamId: $teamId, channelId: $channelId) {\n        ...ActionLog\n      }\n    }\n  ":
      TadaDocumentNode<{ teamChannelLogs: { id: string; type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; requiresAttention: boolean; readReceipt: string | null; todo: boolean; team: { id: string; } & { name: string; exercise: { id: string; }; } & { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; }; details: (({ __typename: "QuestionnaireType"; id: string; teamQuestionnaireStates: { id: string; team: { id: string; }; questionnaire: { id: string; }; todo: boolean; }[]; } | { __typename: "EmailType"; id: string; todo: boolean; } | { __typename: "CustomInjectDetailsType"; } | { __typename: "InjectDetailsType"; } | { __typename: "ToolDetailsType"; }) & ({ __typename: "QuestionnaireType"; id: string; title: string; } | { __typename: "EmailType"; thread: { id: string; subject: string; }; sender: { address: string; }; } | { __typename: "CustomInjectDetailsType"; content: { raw: string; }; } | { __typename: "InjectDetailsType"; inject: { id: string; name: string; organization: string; }; } | { __typename: "ToolDetailsType"; tool: { id: string; name: string; }; argument: string; })) & ({ __typename: "QuestionnaireType"; id: string; title: string; time: number; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; overlay: { id: string; duration: number; } | null; questions: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }[]; teamQuestionnaireStates: { id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; questionnaire: { id: string; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }[]; } | { __typename: "EmailType"; id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; timestamp: string; readReceipt: string | null; } | { __typename: "CustomInjectDetailsType"; id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; } | { __typename: "InjectDetailsType"; id: string; inject: { id: string; name: string; time: number; delay: number; organization: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; target: { id: string; name: string; displayName: string; description: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; readReceipt: { isUnread: boolean | null; teamId: string; id: string; }[]; }; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; confirmation: { id: string; text: string; } | null; confirmed: boolean | null; confirmedBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampConfirmed: string | null; } | { __typename: "ToolDetailsType"; id: string; tool: { id: string; name: string; category: string; tooltipDescription: string; defaultResponse: string; roles: string; hint: string; definition: { id: string; name: string; }; }; argument: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; }); timestamp: string; channel: { id: string; } & { id: string; }; }[]; }, { channelId: string; teamId: string; }, void>;
    "\n    query GetTeamChannelLogsFlat($teamId: ID!, $channelId: ID!) {\n      teamChannelLogs(teamId: $teamId, channelId: $channelId) {\n        ...ActionLogSimple\n      }\n    }\n  ":
      TadaDocumentNode<{ teamChannelLogs: { id: string; type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; requiresAttention: boolean; readReceipt: string | null; }[]; }, { channelId: string; teamId: string; }, void>;
    "\n    query GetTeamEmailParticipant($teamId: ID!) {\n      teamEmailParticipant(teamId: $teamId) {\n        ...EmailParticipant\n      }\n    }\n  ":
      TadaDocumentNode<{ teamEmailParticipant: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; }, { teamId: string; }, void>;
    "\n    query GetTeamLearningObjectives($teamId: ID!) {\n      teamLearningObjectives(teamId: $teamId) {\n        ...TeamLearningObjective\n      }\n    }\n  ":
      TadaDocumentNode<{ teamLearningObjectives: { id: string; reached: boolean | null; objective: { id: string; name: string; description: string; order: number; tags: string; activities: { id: string; name: string; description: string; tags: string; milestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; objective: { id: string; }; }[]; }; activities: { id: string; reached: boolean | null; activity: { id: string; name: string; description: string; tags: string; milestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; objective: { id: string; }; }; milestoneStates: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }[]; }, { teamId: string; }, void>;
    "\n    query GetTeamMilestones($teamId: ID!) {\n      teamMilestones(teamId: $teamId, visibleOnly: false) {\n        activity {\n          id\n          teamObjective {\n            id\n          }\n        }\n        ...MilestoneState\n      }\n    }\n  ":
      TadaDocumentNode<{ teamMilestones: { activity: { id: string; teamObjective: { id: string; }; } | null; id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }, { teamId: string; }, void>;
    "\n    query GetTeamQuestionnaires($teamId: ID!) {\n      teamQuestionnaires(teamId: $teamId) {\n        ...TeamQuestionnaireState\n      }\n    }\n  ":
      TadaDocumentNode<{ teamQuestionnaires: { id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; questionnaire: { id: string; }; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }[]; }, { teamId: string; }, void>;
    "\n    query GetTeamQuestionnaireState($teamId: ID!, $questionnaireId: ID!) {\n      questionnaireState(teamId: $teamId, questionnaireId: $questionnaireId) {\n        ...TeamQuestionnaireState\n        questionnaire {\n          ...QuestionnaireDetails\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ questionnaireState: { id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; questionnaire: { id: string; } & { id: string; title: string; time: number; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; overlay: { id: string; duration: number; } | null; questions: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }[]; teamQuestionnaireStates: { id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; questionnaire: { id: string; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }[]; }; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }; }, { questionnaireId: string; teamId: string; }, void>;
    "\n    query GetThreadTemplates($threadId: ID!) {\n      threadTemplates(threadId: $threadId) {\n        ...EmailTemplate\n      }\n    }\n  ":
      TadaDocumentNode<{ threadTemplates: { id: string; sender: string; context: string; subject: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }, { threadId: string; }, void>;
    "\n    query GetTools($exerciseId: ID!) {\n      exerciseTools(exerciseId: $exerciseId) {\n        ...Tool\n      }\n    }\n  ":
      TadaDocumentNode<{ exerciseTools: { id: string; name: string; category: string; tooltipDescription: string; defaultResponse: string; roles: string; hint: string; definition: { id: string; name: string; }; }[]; }, { exerciseId: string; }, void>;
    "\n    query GetTraineeViewData($teamId: ID!, $exerciseId: ID!) {\n      team(teamId: $teamId) {\n        ...Team\n      }\n      exerciseConfig(exerciseId: $exerciseId) {\n        showExerciseTime\n      }\n      exerciseChannels(exerciseId: $exerciseId) {\n        id\n        name\n        type\n        displayName\n        description\n        readReceipt {\n          isUnread\n          teamId\n          id\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; exerciseConfig: { showExerciseTime: boolean | null; }; exerciseChannels: { id: string; name: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; displayName: string; description: string; readReceipt: { isUnread: boolean | null; teamId: string; id: string; }[]; }[]; }, { exerciseId: string; teamId: string; }, void>;
    "\n    query GetUser($userId: UUID!) {\n      user(userId: $userId) {\n        ...User\n      }\n    }\n  ":
      TadaDocumentNode<{ user: { id: string; lastLogin: string | null; username: string; firstName: string | null; lastName: string | null; dateJoined: string; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE"; isActive: boolean; isImported: boolean; tags: { id: string; name: string; }[]; teams: { id: string; exercise: { id: string; name: string; running: boolean; finished: boolean; exerciseStart: string | null; definition: { id: string; name: string; } & { id: string; name: string; }; teams: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }[]; emailParticipants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; timeDelta: number; instructors: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; createdBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }; name: string; role: string; }[]; exercises: { id: string; name: string; }[]; definitions: { id: string; name: string; }[]; }; }, { userId: string; }, void>;
    "\n    query GetUsers($active: Boolean, $groups: [AuthGroup], $tags: [String]) {\n      users(\n        filterUsersInput: { active: $active, groups: $groups, tags: $tags }\n      ) {\n        ...User\n      }\n    }\n  ":
      TadaDocumentNode<{ users: { id: string; lastLogin: string | null; username: string; firstName: string | null; lastName: string | null; dateJoined: string; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE"; isActive: boolean; isImported: boolean; tags: { id: string; name: string; }[]; teams: { id: string; exercise: { id: string; name: string; running: boolean; finished: boolean; exerciseStart: string | null; definition: { id: string; name: string; } & { id: string; name: string; }; teams: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }[]; emailParticipants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; timeDelta: number; instructors: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; createdBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }; name: string; role: string; }[]; exercises: { id: string; name: string; }[]; definitions: { id: string; name: string; }[]; }[]; }, { tags?: (string | null)[] | null | undefined; groups?: ("ADMIN" | "INSTRUCTOR" | "TRAINEE" | null)[] | null | undefined; active?: boolean | null | undefined; }, void>;
    "\n    query Identity {\n      whoAmI {\n        ...User\n      }\n    }\n  ":
      TadaDocumentNode<{ whoAmI: { id: string; lastLogin: string | null; username: string; firstName: string | null; lastName: string | null; dateJoined: string; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE"; isActive: boolean; isImported: boolean; tags: { id: string; name: string; }[]; teams: { id: string; exercise: { id: string; name: string; running: boolean; finished: boolean; exerciseStart: string | null; definition: { id: string; name: string; } & { id: string; name: string; }; teams: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }[]; emailParticipants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; timeDelta: number; instructors: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; createdBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }; name: string; role: string; }[]; exercises: { id: string; name: string; }[]; definitions: { id: string; name: string; }[]; } | null; }, {}, void>;
    "\n    query ValidateEmailAddress($exerciseId: ID!, $address: String!) {\n      validateEmailAddress(exerciseId: $exerciseId, address: $address)\n    }\n  ":
      TadaDocumentNode<{ validateEmailAddress: boolean; }, { address: string; exerciseId: string; }, void>;
    "\n    subscription exerciseActionLogs($exerciseId: ID!) {\n      analyticsActionLogsSubscription(exerciseId: $exerciseId) {\n        actionLog {\n          ...ActionLog\n        }\n        eventType\n      }\n    }\n  ":
      TadaDocumentNode<{ analyticsActionLogsSubscription: { actionLog: { id: string; type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; requiresAttention: boolean; readReceipt: string | null; todo: boolean; team: { id: string; } & { name: string; exercise: { id: string; }; } & { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; }; details: (({ __typename: "QuestionnaireType"; id: string; teamQuestionnaireStates: { id: string; team: { id: string; }; questionnaire: { id: string; }; todo: boolean; }[]; } | { __typename: "EmailType"; id: string; todo: boolean; } | { __typename: "CustomInjectDetailsType"; } | { __typename: "InjectDetailsType"; } | { __typename: "ToolDetailsType"; }) & ({ __typename: "QuestionnaireType"; id: string; title: string; } | { __typename: "EmailType"; thread: { id: string; subject: string; }; sender: { address: string; }; } | { __typename: "CustomInjectDetailsType"; content: { raw: string; }; } | { __typename: "InjectDetailsType"; inject: { id: string; name: string; organization: string; }; } | { __typename: "ToolDetailsType"; tool: { id: string; name: string; }; argument: string; })) & ({ __typename: "QuestionnaireType"; id: string; title: string; time: number; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; overlay: { id: string; duration: number; } | null; questions: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }[]; teamQuestionnaireStates: { id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; questionnaire: { id: string; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }[]; } | { __typename: "EmailType"; id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; timestamp: string; readReceipt: string | null; } | { __typename: "CustomInjectDetailsType"; id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; } | { __typename: "InjectDetailsType"; id: string; inject: { id: string; name: string; time: number; delay: number; organization: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; target: { id: string; name: string; displayName: string; description: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; readReceipt: { isUnread: boolean | null; teamId: string; id: string; }[]; }; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; confirmation: { id: string; text: string; } | null; confirmed: boolean | null; confirmedBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampConfirmed: string | null; } | { __typename: "ToolDetailsType"; id: string; tool: { id: string; name: string; category: string; tooltipDescription: string; defaultResponse: string; roles: string; hint: string; definition: { id: string; name: string; }; }; argument: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; }); timestamp: string; channel: { id: string; } & { id: string; }; }; eventType: "CREATE" | "DELETE" | "MODIFY"; } | null; }, { exerciseId: string; }, void>;
    "\n    subscription exerciseEmailThreads($exerciseId: ID!) {\n      analyticsEmailThreadSubscription(exerciseId: $exerciseId) {\n        emailThread {\n          ...EmailThread\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ analyticsEmailThreadSubscription: { emailThread: { id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }; } | null; }, { exerciseId: string; }, void>;
    "\n    subscription exerciseMilestones($exerciseId: ID!) {\n      analyticsMilestonesSubscription(exerciseId: $exerciseId) {\n        milestones {\n          activity {\n            id\n            teamObjective {\n              id\n            }\n          }\n          ...MilestoneState\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ analyticsMilestonesSubscription: { milestones: { activity: { id: string; teamObjective: { id: string; }; } | null; id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; } | null; }, { exerciseId: string; }, void>;
    "\n    subscription EmailThreadsSubscription($teamId: ID!) {\n      emailThreads(teamId: $teamId) {\n        emailThread {\n          ...EmailThread\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ emailThreads: { emailThread: { id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }; } | null; }, { teamId: string; }, void>;
    "\n    subscription exerciseLoopRunning($exerciseId: ID!) {\n      exerciseLoopRunning(exerciseId: $exerciseId) {\n        exerciseLoopRunning\n      }\n    }\n  ":
      TadaDocumentNode<{ exerciseLoopRunning: { exerciseLoopRunning: boolean; } | null; }, { exerciseId: string; }, void>;
    "\n    subscription exercises {\n      exercisesSubscription {\n        exercise {\n          ...Exercise\n        }\n        eventType\n      }\n    }\n  ":
      TadaDocumentNode<{ exercisesSubscription: { exercise: { id: string; name: string; running: boolean; finished: boolean; exerciseStart: string | null; definition: { id: string; name: string; } & { id: string; name: string; }; teams: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }[]; emailParticipants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; timeDelta: number; instructors: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; createdBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampCreated: string; }; eventType: "CREATE" | "DELETE" | "MODIFY"; } | null; }, {}, void>;
    "\n    subscription teamAction($teamId: ID!) {\n      actionLogs(teamId: $teamId) {\n        actionLog {\n          ...ActionLog\n        }\n        eventType\n      }\n    }\n  ":
      TadaDocumentNode<{ actionLogs: { actionLog: { id: string; type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; requiresAttention: boolean; readReceipt: string | null; todo: boolean; team: { id: string; } & { name: string; exercise: { id: string; }; } & { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; }; details: (({ __typename: "QuestionnaireType"; id: string; teamQuestionnaireStates: { id: string; team: { id: string; }; questionnaire: { id: string; }; todo: boolean; }[]; } | { __typename: "EmailType"; id: string; todo: boolean; } | { __typename: "CustomInjectDetailsType"; } | { __typename: "InjectDetailsType"; } | { __typename: "ToolDetailsType"; }) & ({ __typename: "QuestionnaireType"; id: string; title: string; } | { __typename: "EmailType"; thread: { id: string; subject: string; }; sender: { address: string; }; } | { __typename: "CustomInjectDetailsType"; content: { raw: string; }; } | { __typename: "InjectDetailsType"; inject: { id: string; name: string; organization: string; }; } | { __typename: "ToolDetailsType"; tool: { id: string; name: string; }; argument: string; })) & ({ __typename: "QuestionnaireType"; id: string; title: string; time: number; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; overlay: { id: string; duration: number; } | null; questions: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }[]; teamQuestionnaireStates: { id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; questionnaire: { id: string; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }[]; } | { __typename: "EmailType"; id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; participants: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }[]; subject: string; timestamp: string; emails: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; }[]; lastEmail: { id: string; sender: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; }; thread: { id: string; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; todo: boolean; timestamp: string; readReceipt: string | null; } | null; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; archived: boolean; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; timestamp: string; readReceipt: string | null; } | { __typename: "CustomInjectDetailsType"; id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; } | { __typename: "InjectDetailsType"; id: string; inject: { id: string; name: string; time: number; delay: number; organization: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; target: { id: string; name: string; displayName: string; description: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; readReceipt: { isUnread: boolean | null; teamId: string; id: string; }[]; }; }; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; overlay: { id: string; duration: number; } | null; confirmation: { id: string; text: string; } | null; confirmed: boolean | null; confirmedBy: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; } | null; timestampConfirmed: string | null; } | { __typename: "ToolDetailsType"; id: string; tool: { id: string; name: string; category: string; tooltipDescription: string; defaultResponse: string; roles: string; hint: string; definition: { id: string; name: string; }; }; argument: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; }); timestamp: string; channel: { id: string; } & { id: string; }; }; eventType: "CREATE" | "DELETE" | "MODIFY"; } | null; }, { teamId: string; }, void>;
    "\n    subscription teamMilestones($teamId: ID!) {\n      milestones: milestones(teamId: $teamId, visibleOnly: false) {\n        milestones {\n          ...MilestoneState\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ milestones: { milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; } | null; }, { teamId: string; }, void>;
    "\n    subscription teamQuestionnaireState($teamId: ID!) {\n      teamQuestionnaireState: teamQuestionnaireStateSubscription(\n        teamId: $teamId\n      ) {\n        teamQuestionnaireState {\n          ...TeamQuestionnaireState\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ teamQuestionnaireState: { teamQuestionnaireState: { id: string; team: { id: string; name: string; role: string; emailAddress: { id: string; definitionAddress: { id: string; address: string; description: string; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; teamVisible: boolean; organization: string; } | null; address: string; team: { id: string; name: string; role: string; } | null; } | null; exercise: { id: string; name: string; }; users: { id: string; username: string; firstName: string | null; lastName: string | null; group: "ADMIN" | "INSTRUCTOR" | "TRAINEE" | null; }[]; }; status: "ANSWERED" | "REVIEWED" | "SENT" | "UNSENT"; timestampSent: string | null; timestampAnswered: string | null; answers: { id: string; isCorrect: boolean | null; question: { id: string; content: { id: string; raw: string; rendered: string; fileInfo: { id: string; fileName: string; } | null; }; type: "FREE_FORM" | "RADIO"; details: { __typename?: "FreeFormQuestionDetailsType" | undefined; id: string; relatedMilestones: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }[]; multiline: boolean; } | { __typename?: "RadioQuestionDetailsType" | undefined; id: string; max: number; correct: number; labels: string; controls: { choice: number; control: { id: string; milestoneCondition: string; activateMilestone: string; deactivateMilestone: string; roles: string; }; }[]; }; }; answer: string; }[]; questionnaire: { id: string; }; relatedMilestones: { questionId: string; milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; }[]; }; } | null; }, { teamId: string; }, void>;
    "\n    subscription teamVisibleMilestones($teamId: ID!) {\n      teamVisibleMilestones: milestones(teamId: $teamId, visibleOnly: true) {\n        milestones {\n          ...MilestoneState\n        }\n      }\n    }\n  ":
      TadaDocumentNode<{ teamVisibleMilestones: { milestones: { id: string; milestone: { id: string; name: string; description: string; displayName: string; tags: string[]; teamVisible: boolean; roles: string; fileNames: string; }; reached: boolean; timestampReached: string | null; teamIds: string[]; }[]; } | null; }, { teamId: string; }, void>;
    "\n            fragment _ on EmailThreadReceipt {\n              threadId\n              teamId\n              isUnread\n            }\n          ":
      TadaDocumentNode<{ threadId: string; teamId: string; isUnread: boolean | null; }, {}, { fragment: "_"; on: "EmailThreadReceipt"; masked: true; }>;
    "\n            fragment _ on ChannelReceipt {\n              id\n              teamId\n              isUnread\n            }\n          ":
      TadaDocumentNode<{ id: string; teamId: string; isUnread: boolean | null; }, {}, { fragment: "_"; on: "ChannelReceipt"; masked: true; }>;
    "\n              fragment _ on ExerciseType {\n                id\n                running\n              }\n            ":
      TadaDocumentNode<{ id: string; running: boolean; }, {}, { fragment: "_"; on: "ExerciseType"; masked: true; }>;
    "\n              fragment _ on ActionLogType {\n                id\n                readReceipt\n              }\n            ":
      TadaDocumentNode<{ id: string; readReceipt: unknown; }, {}, { fragment: "_"; on: "ActionLogType"; masked: true; }>;
    "\n              fragment _ on EmailType {\n                id\n                readReceipt\n              }\n            ":
      TadaDocumentNode<{ id: string; readReceipt: unknown; }, {}, { fragment: "_"; on: "EmailType"; masked: true; }>;
    "\n            fragment _ on ActionLogType {\n              id\n              todo\n            }\n          ":
      TadaDocumentNode<{ id: string; todo: boolean; }, {}, { fragment: "_"; on: "ActionLogType"; masked: true; }>;
    "\n            fragment _ on TeamQuestionnaireStateType {\n              team {\n                id\n              }\n              questionnaire {\n                id\n              }\n              todo\n            }\n          ":
      TadaDocumentNode<{ team: { id: string; }; questionnaire: { id: string; }; todo: boolean; }, {}, { fragment: "_"; on: "TeamQuestionnaireStateType"; masked: true; }>;
    "\n            fragment _ on EmailType {\n              id\n              todo\n            }\n          ":
      TadaDocumentNode<{ id: string; todo: boolean; }, {}, { fragment: "_"; on: "EmailType"; masked: true; }>;
    "\n            fragment _ on EmailThreadType {\n              id\n              archived\n            }\n          ":
      TadaDocumentNode<{ id: string; archived: boolean; }, {}, { fragment: "_"; on: "EmailThreadType"; masked: true; }>;
    "\n  query GetChannelTypes($exerciseId: ID!) {\n    exerciseChannels(exerciseId: $exerciseId) {\n      id\n      type\n    }\n  }\n":
      TadaDocumentNode<{ exerciseChannels: { id: string; type: "EMAIL" | "FORM" | "INFO" | "TOOL"; }[]; }, { exerciseId: string; }, void>;
    "\n  fragment _ on DefinitionChannelType @_unmask {\n    type\n  }\n":
      TadaDocumentNode<{ type: "EMAIL" | "FORM" | "INFO" | "TOOL"; }, {}, { fragment: "_"; on: "DefinitionChannelType"; masked: false; }>;
    "\n  query EmailThreadsV0(\n    $teamId: ID!\n    $received: Boolean = true\n    $sent: Boolean = true\n    $archived: Boolean = false\n  ) {\n    emailThreads(teamId: $teamId)\n      @_filterEmails(received: $received, sent: $sent, archived: $archived) {\n      id\n      readReceipt {\n        isUnread\n        teamId\n        threadId\n      }\n    }\n  }\n":
      TadaDocumentNode<{ emailThreads: { id: string; readReceipt: { isUnread: boolean | null; teamId: string; threadId: string; }[]; }[]; }, { archived?: boolean | null | undefined; sent?: boolean | null | undefined; received?: boolean | null | undefined; teamId: string; }, void>;
    "\n  fragment _ on ActionLogType @_unmask {\n    channel {\n      id\n    }\n    team {\n      id\n    }\n    details {\n      __typename\n    }\n    type\n  }\n":
      TadaDocumentNode<{ channel: { id: string; }; team: { id: string; }; details: { __typename: "QuestionnaireType"; } | { __typename: "EmailType"; } | { __typename: "CustomInjectDetailsType"; } | { __typename: "InjectDetailsType"; } | { __typename: "ToolDetailsType"; }; type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; }, {}, { fragment: "_"; on: "ActionLogType"; masked: false; }>;
    "\n  fragment _ on ActionLogType @_unmask {\n    type\n  }\n":
      TadaDocumentNode<{ type: "EMAIL" | "FORM" | "TOOL" | "CUSTOM_INJECT" | "INJECT"; }, {}, { fragment: "_"; on: "ActionLogType"; masked: false; }>;
  }
}
