import { graphql } from './graphql'

export const RestrictedExercise = graphql(
  `
    fragment RestrictedExercise on RestrictedExercise @_unmask {
      id
      name
    }
  `,
  []
)

export const Control = graphql(
  `
    fragment Control on ControlType @_unmask {
      id
      milestoneCondition
      activateMilestone
      deactivateMilestone
      roles
    }
  `,
  []
)

export const Answer = graphql(
  `
    fragment Answer on AnswerType @_unmask {
      questionId
      value
    }
  `,
  []
)

export const Channel = graphql(
  `
    fragment Channel on DefinitionChannelType @_unmask {
      id
      name
      displayName
      description
      type
      readReceipt {
        isUnread
        teamId
        id
      }
    }
  `,
  []
)

export const Confirmation = graphql(
  `
    fragment Confirmation on ConfirmationType @_unmask {
      id
      text
    }
  `,
  []
)

export const ExerciseConfig = graphql(
  `
    fragment ExerciseConfig on GrapheneConfig @_unmask {
      exerciseDuration
      emailBetweenTeams
      showExerciseTime
      enableRoles
      customEmailSuffix
    }
  `,
  []
)

export const ExerciseDefinition = graphql(
  `
    fragment ExerciseDefinition on ExerciseDefinitionType @_unmask {
      id
      name
    }
  `,
  []
)

export const ActionLogSimple = graphql(
  `
    fragment ActionLogSimple on ActionLogType @_unmask {
      id
      type
      requiresAttention
      readReceipt
    }
  `,
  []
)

export const FileInfo = graphql(
  `
    fragment FileInfo on FileInfoType @_unmask {
      id
      fileName
    }
  `,
  []
)

export const Milestone = graphql(
  `
    fragment Milestone on MilestoneType @_unmask {
      id
      name
      description
      displayName
      tags
      teamVisible
      roles
      fileNames
    }
  `,
  []
)

export const Overlay = graphql(
  `
    fragment Overlay on OverlayType @_unmask {
      id
      duration
    }
  `,
  []
)

export const RestrictedUserF = graphql(
  `
    fragment RestrictedUserF on RestrictedUser @_unmask {
      id
      username
      firstName
      lastName
      group
    }
  `,
  []
)

export const Role = graphql(
  `
    fragment Role on DefinitionRoleType @_unmask {
      id
      name
      displayName
      description
    }
  `,
  []
)

export const Tag = graphql(
  `
    fragment Tag on TagType @_unmask {
      id
      name
    }
  `,
  []
)

export const TeamWithoutEmailAddress = graphql(
  `
    fragment TeamWithoutEmailAddress on TeamType @_unmask {
      id
      name
      role
    }
  `,
  []
)

export const EmailAddress = graphql(
  `
    fragment EmailAddress on EmailAddressType @_unmask {
      id
      address
      description
      control {
        ...Control
      }
      teamVisible
      organization
    }
  `,
  [Control]
)

export const EmailParticipant = graphql(
  `
    fragment EmailParticipant on EmailParticipantType @_unmask {
      id
      definitionAddress {
        ...EmailAddress
      }
      address
      team {
        ...TeamWithoutEmailAddress
      }
    }
  `,
  [EmailAddress, TeamWithoutEmailAddress]
)

export const Team = graphql(
  `
    fragment Team on TeamType @_unmask {
      id
      name
      role
      emailAddress {
        ...EmailParticipant
      }
      exercise {
        id
        name
      }
      users {
        ...RestrictedUserF
      }
    }
  `,
  [EmailParticipant, RestrictedUserF]
)

export const ActionLogFlat = graphql(
  `
    fragment ActionLogFlat on ActionLogType @_unmask {
      ...ActionLogSimple
      todo
      team {
        id
      }
      details {
        __typename
        ... on QuestionnaireType {
          id
          teamQuestionnaireStates {
            id
            team {
              id
            }
            questionnaire {
              id
            }
            todo
          }
        }
        ... on EmailType {
          id
          todo
        }
      }
    }
  `,
  [ActionLogSimple]
)

export const Content = graphql(
  `
    fragment Content on ContentType @_unmask {
      id
      raw
      rendered
      fileInfo {
        ...FileInfo
      }
    }
  `,
  [FileInfo]
)

export const ControlsMap = graphql(
  `
    fragment ControlsMap on ControlsMapType @_unmask {
      choice
      control {
        ...Control
      }
    }
  `,
  [Control]
)

export const CustomInjectDetails = graphql(
  `
    fragment CustomInjectDetails on CustomInjectDetailsType @_unmask {
      id
      content {
        ...Content
      }
      overlay {
        ...Overlay
      }
    }
  `,
  [Content, Overlay]
)

export const Definition = graphql(
  `
    fragment Definition on DefinitionType @_unmask {
      id
      name
      description
      prerequisites
      targetAudience
      version
      channels {
        id
        name
        type
        displayName
        description
      }
      roles {
        ...Role
      }
      maintainers {
        ...RestrictedUserF
      }
      uploadedBy {
        ...RestrictedUserF
      }
      timestampCreated
    }
  `,
  [Role, RestrictedUserF, RestrictedUserF]
)

export const DefinitionInject = graphql(
  `
    fragment DefinitionInject on DefinitionInjectType @_unmask {
      id
      name
      time
      delay
      organization
      type
      target {
        ...Channel
      }
    }
  `,
  [Channel]
)

export const Email = graphql(
  `
    fragment Email on EmailType @_unmask {
      id
      sender {
        ...EmailParticipant
      }
      thread {
        id
      }
      content {
        ...Content
      }
      overlay {
        ...Overlay
      }
      todo
      timestamp
      readReceipt @client(always: true)
    }
  `,
  [EmailParticipant, Content, Overlay]
)

export const EmailThread = graphql(
  `
    fragment EmailThread on EmailThreadType @_unmask {
      id
      participants {
        ...EmailParticipant
      }
      subject
      timestamp
      emails {
        ...Email
      }
      lastEmail {
        ...Email
      }
      readReceipt @client(always: true) {
        isUnread
        teamId
        threadId
      }
      archived
    }
  `,
  [EmailParticipant, Email]
)

export const EmailDetails = graphql(
  `
    fragment EmailDetails on EmailType @_unmask {
      id
      sender {
        ...EmailParticipant
      }
      thread {
        ...EmailThread
      }
      content {
        ...Content
      }
      overlay {
        ...Overlay
      }
      timestamp
      readReceipt @client(always: true)
    }
  `,
  [EmailParticipant, EmailThread, Content, Overlay]
)

export const EmailTemplate = graphql(
  `
    fragment EmailTemplate on EmailTemplateType @_unmask {
      id
      sender
      context
      subject
      content {
        ...Content
      }
      control {
        ...Control
      }
    }
  `,
  [Content, Control]
)

export const Exercise = graphql(
  `
    fragment Exercise on ExerciseType @_unmask {
      id
      name
      running
      finished
      exerciseStart
      definition {
        ...ExerciseDefinition
      }
      teams {
        ...Team
      }
      emailParticipants {
        ...EmailParticipant
      }
      timeDelta: elapsedS
      definition {
        id
        name
      }
      instructors {
        ...RestrictedUserF
      }
      createdBy {
        ...RestrictedUserF
      }
      timestampCreated
    }
  `,
  [ExerciseDefinition, Team, EmailParticipant, RestrictedUserF]
)

export const ExtendedTool = graphql(
  `
    fragment ExtendedTool on ExtendedToolType @_unmask {
      id
      name
      category
      tooltipDescription
      defaultResponse
      roles
      hint
      definition {
        ...ExerciseDefinition
      }
    }
  `,
  [ExerciseDefinition]
)

export const FreeFormQuestionDetails = graphql(
  `
    fragment FreeFormQuestionDetails on FreeFormQuestionDetailsType @_unmask {
      id
      relatedMilestones {
        ...Milestone
      }
      multiline
    }
  `,
  [Milestone]
)

export const InjectDetails = graphql(
  `
    fragment InjectDetails on InjectDetailsType @_unmask {
      id
      inject {
        ...DefinitionInject
      }
      content {
        ...Content
      }
      overlay {
        ...Overlay
      }
      confirmation {
        ...Confirmation
      }
      confirmed
      confirmedBy {
        ...RestrictedUserF
      }
      timestampConfirmed
    }
  `,
  [DefinitionInject, Content, Overlay, Confirmation, RestrictedUserF]
)

export const LearningActivity = graphql(
  `
    fragment LearningActivity on LearningActivityType @_unmask {
      id
      name
      description
      tags
      milestones {
        ...Milestone
      }
      objective {
        id
      }
    }
  `,
  [Milestone]
)

export const LearningObjective = graphql(
  `
    fragment LearningObjective on LearningObjectiveType @_unmask {
      id
      name
      description
      order
      tags
      activities {
        ...LearningActivity
      }
    }
  `,
  [LearningActivity]
)

export const RadioQuestionDetails = graphql(
  `
    fragment RadioQuestionDetails on RadioQuestionDetailsType @_unmask {
      id
      max
      correct
      labels
      controls {
        ...ControlsMap
      }
    }
  `,
  [ControlsMap]
)

export const MilestoneState = graphql(
  `
    fragment MilestoneState on MilestoneStateType @_unmask {
      id
      milestone {
        ...Milestone
      }
      reached
      timestampReached
      teamIds
    }
  `,
  [Milestone]
)

export const Question = graphql(
  `
    fragment Question on QuestionType @_unmask {
      id
      content {
        ...Content
      }
      type
      details {
        ... on RadioQuestionDetailsType {
          ...RadioQuestionDetails
        }
        ... on FreeFormQuestionDetailsType {
          ...FreeFormQuestionDetails
        }
      }
    }
  `,
  [Content, RadioQuestionDetails, FreeFormQuestionDetails]
)

export const QuestionnaireAnswer = graphql(
  `
    fragment QuestionnaireAnswer on QuestionnaireAnswerType @_unmask {
      id
      isCorrect
      question {
        ...Question
      }
      answer
    }
  `,
  [Question]
)

export const QuestionRelatedMilestones = graphql(
  `
    fragment QuestionRelatedMilestones on QuestionRelatedMilestonesType
    @_unmask {
      questionId
      milestones {
        ...MilestoneState
      }
    }
  `,
  [MilestoneState]
)

export const QuestionnaireDetails = graphql(
  `
    fragment QuestionnaireDetails on QuestionnaireType @_unmask {
      id
      title
      time
      content {
        ...Content
      }
      control {
        ...Control
      }
      overlay {
        ...Overlay
      }
      questions {
        ...Question
      }
      teamQuestionnaireStates {
        id
        team {
          ...Team
        }
        questionnaire {
          id
        }
        status
        timestampSent
        timestampAnswered
        answers {
          ...QuestionnaireAnswer
        }
        relatedMilestones {
          ...QuestionRelatedMilestones
        }
      }
    }
  `,
  [
    Content,
    Control,
    Overlay,
    Question,
    Team,
    QuestionnaireAnswer,
    QuestionRelatedMilestones,
  ]
)

export const RestrictedTeam = graphql(
  `
    fragment RestrictedTeam on RestrictedTeam @_unmask {
      id
      exercise {
        ...Exercise
      }
      name
      role
    }
  `,
  [Exercise]
)

export const SimplifiedActionLog = graphql(
  `
    fragment SimplifiedActionLog on ActionLogType @_unmask {
      ...ActionLogFlat
      timestamp
      team {
        name
        exercise {
          id
        }
      }
      channel {
        id
      }
      details {
        __typename
        ... on ToolDetailsType {
          tool {
            id
            name
          }
          argument
        }
        ... on InjectDetailsType {
          inject {
            id
            name
            organization
          }
        }
        ... on CustomInjectDetailsType {
          content {
            raw
          }
        }
        ... on EmailType {
          thread {
            id
            subject
          }
          sender {
            address
          }
        }
        ... on QuestionnaireType {
          id
          title
        }
      }
    }
  `,
  [ActionLogFlat]
)

export const TeamLearningActivity = graphql(
  `
    fragment TeamLearningActivity on TeamLearningActivityType @_unmask {
      id
      reached
      activity {
        ...LearningActivity
      }
      milestoneStates {
        ...MilestoneState
      }
    }
  `,
  [LearningActivity, MilestoneState]
)

export const TeamLearningObjective = graphql(
  `
    fragment TeamLearningObjective on TeamLearningObjectiveType @_unmask {
      id
      reached
      objective {
        ...LearningObjective
      }
      activities {
        ...TeamLearningActivity
      }
    }
  `,
  [LearningObjective, TeamLearningActivity]
)

export const TeamQuestionnaireState = graphql(
  `
    fragment TeamQuestionnaireState on TeamQuestionnaireStateType @_unmask {
      id
      team {
        ...Team
      }
      status
      timestampSent
      timestampAnswered
      answers {
        ...QuestionnaireAnswer
      }
      questionnaire {
        id
      }
      relatedMilestones {
        ...QuestionRelatedMilestones
      }
    }
  `,
  [Team, QuestionnaireAnswer, QuestionRelatedMilestones]
)

export const Tool = graphql(
  `
    fragment Tool on ToolType @_unmask {
      id
      name
      category
      tooltipDescription
      defaultResponse
      roles
      hint
      definition {
        ...ExerciseDefinition
      }
    }
  `,
  [ExerciseDefinition]
)

export const ToolDetails = graphql(
  `
    fragment ToolDetails on ToolDetailsType @_unmask {
      id
      tool {
        ...Tool
      }
      argument
      content {
        ...Content
      }
    }
  `,
  [Tool, Content]
)

export const User = graphql(
  `
    fragment User on UserType @_unmask {
      id
      lastLogin
      username
      firstName
      lastName
      dateJoined
      group
      isActive
      isImported
      tags {
        ...Tag
      }
      teams {
        ...RestrictedTeam
      }
      exercises {
        ...RestrictedExercise
      }
      definitions {
        ...ExerciseDefinition
      }
    }
  `,
  [Tag, RestrictedTeam, RestrictedExercise, ExerciseDefinition]
)

export const ActionLog = graphql(
  `
    fragment ActionLog on ActionLogType @_unmask {
      ...SimplifiedActionLog
      id
      timestamp
      team {
        id
        name
        role
        emailAddress {
          ...EmailParticipant
        }
        exercise {
          id
          name
        }
      }
      channel {
        id
      }
      todo
      type
      details {
        __typename
        ... on ToolDetailsType {
          ...ToolDetails
        }
        ... on InjectDetailsType {
          ...InjectDetails
        }
        ... on CustomInjectDetailsType {
          ...CustomInjectDetails
        }
        ... on EmailType {
          ...EmailDetails
        }
        ... on QuestionnaireType {
          ...QuestionnaireDetails
        }
      }
      readReceipt
      requiresAttention
    }
  `,
  [
    EmailParticipant,
    ToolDetails,
    InjectDetails,
    CustomInjectDetails,
    EmailDetails,
    QuestionnaireDetails,
    SimplifiedActionLog,
  ]
)
