import { wsGraphql } from '@inject/shared/config'
import { makeVar, useReactiveVar } from '@inject/shared/utils/reactive'

const initialSettings: string = wsGraphql(
  window.VITE_HTTPS_HOST ?? 'localhost:8000'
)

export const ws = makeVar<string>(initialSettings)
export const useWs = () => useReactiveVar(ws)

ws.onNextChange(function onNext() {
  ws.onNextChange(onNext)
})
