import { makeVar, useReactiveVar } from '@inject/shared/utils/reactive'

declare global {
  interface Window {
    VITE_HTTPS_HOST: string | undefined
  }
}

const initialSettings: string = window.VITE_HTTPS_HOST ?? 'localhost:8000'

export const host = makeVar<string>(initialSettings)
export const useHost = () => useReactiveVar(host)

host.onNextChange(function onNext() {
  host.onNextChange(onNext)
})
