import { Dialog, DialogBody } from '@blueprintjs/core'
import { css } from '@emotion/css'
import { dialog } from '@inject/shared/css/dialog'
import type { FC, PropsWithChildren, ReactNode } from 'react'

const body = css`
  display: flex;
  flex-direction: column;
  gap: 1rem;

  p {
    margin: 0;
  }
`

interface ErrorDialogProps extends PropsWithChildren {
  title?: ReactNode
}

const ErrorDialog: FC<ErrorDialogProps> = ({ children, title }) => (
  <Dialog
    className={dialog}
    title={title || 'Connection error'}
    icon='error'
    isOpen
    canOutsideClickClose={false}
    canEscapeKeyClose={false}
    isCloseButtonShown={false}
  >
    <DialogBody className={body}>{children}</DialogBody>
  </Dialog>
)

export default ErrorDialog
