import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'
import generouted from '@generouted/react-router/plugin'
import path from 'path'
import { visualizer } from 'rollup-plugin-visualizer'
import svgr from 'vite-plugin-svgr'
import { vitePluginGraphqlLoader } from 'vite-plugin-graphql-loader'
import * as child_process from 'child_process'
import license from 'rollup-plugin-license'
import { optimizeLodashImports } from "@optimize-lodash/rollup-plugin";

const ReactCompilerConfig = {
  target: '18' // '17' | '18' | '19'
};

// https://vitejs.dev/config/
export default (...params) => {
  console.log('Compiling for these env variables: ', process.env)

  const config = defineConfig(({ mode }) => ({
    esbuild: {
      pure: (mode === 'production' ? ['console.log'] : []),
    },
    server: {
      fs: {
        strict: false,
      }
    },
    plugins: [
      react({
        jsxImportSource: '@emotion/react',
        babel: {
          plugins: ["@emotion", ["babel-plugin-react-compiler", ReactCompilerConfig], "babel-plugin-graphql-tag", "preval"],
        },
      }),
      generouted(),
      //@ts-ignore
      visualizer(),
      optimizeLodashImports(),
      license({
        sourcemap: true,
        cwd: process.cwd(), // The default
  
        banner: {
          commentStyle: 'regular', // The default
  
          content: {
            file: path.join(__dirname, 'LICENSE'),
            encoding: 'utf-8', // Default is utf-8
          },
        },
  
        thirdParty: {
          includePrivate: true, // Default is false.
          multipleVersions: true, // Default is false.
          output: {
            file: path.join(__dirname, 'ThirdPartyLicense.txt'),
            encoding: 'utf-8', // Default is utf-8.
          },
        },
      }),
      vitePluginGraphqlLoader(),
      svgr({
        svgrOptions: {
          ref: true,
        },
      }),
    ],
    envPrefix: ['VITE_', 'INJECT_'],
    resolve: {
      alias: {
        '@': path.resolve(__dirname, './src'),
      },
    },
    define: {
      'globalThis.__DEV__': JSON.stringify(false),
    },
    css: {
      devSourcemap: true,
      modules: {
        localsConvention: 'camelCaseOnly',
      },
    },
    build: {
      cssCodeSplit: true,
      minify: 'terser',
      target: 'es2022',
      outDir: '../dist',
      rollupOptions: {
        input: {
          index: path.resolve(__dirname, 'index.html'),
        },
        output: {
          compact: true,
        }
      },
      terserOptions: {
        mangle: {
          eval: true,
          keep_fnames: false,
          keep_classnames: false,
          toplevel: true,
        },
        compress: {
          dead_code: true,
          // drop_console: true,
          drop_debugger: true,
          ecma: 2020,
          if_return: true,
        },
      }
    },
  }))

  //@ts-ignore
  return config(...params)
}
