import Content from '@/actionlog/InjectMessage/Content'
import { getIcon, getTitle } from '@/actionlog/InjectMessage/utils'
import type { ActionLog } from '@inject/graphql/fragment-types'
import type { ShowPopupProps } from '@inject/shared/popup/typing'

export type GetPopupProps = Omit<ShowPopupProps, 'duration'>

const getPopupProps = (actionLog: ActionLog): GetPopupProps => ({
  getContent: onClose => (
    <Content
      actionLog={actionLog}
      teamId={actionLog.team.id}
      exerciseId={actionLog.team.exercise.id}
      inInstructor={false}
      onClose={onClose}
    />
  ),
  title: getTitle(actionLog),
  icon: getIcon(actionLog.type),
})

export default getPopupProps
