import { useNavigate } from '@/router'
import { Button } from '@blueprintjs/core'
import type { FC } from 'react'
import { useMatch } from 'react-router-dom'

const TeamOverviewButton: FC<{
  exerciseId: string
  teamId: string
  hideLabel?: boolean
}> = ({ exerciseId, teamId, hideLabel }) => {
  const nav = useNavigate()
  const match = useMatch({
    path: `/instructor/${exerciseId}/${teamId}`,
    end: true,
  })

  return (
    <Button
      active={!!match}
      icon='people'
      alignText='left'
      fill
      minimal
      title='Overview selected team'
      onClick={() => {
        nav('/instructor/:exerciseId/:teamId', {
          params: {
            exerciseId,
            teamId,
          },
        })
      }}
      text={!hideLabel ? 'Team Overview' : undefined}
    />
  )
}

export default TeamOverviewButton
