import { useTeamStateMap } from '@/clientsettings/vars/teams'
import { useNavigate } from '@/router'
import { Button } from '@blueprintjs/core'
import type { FC } from 'react'
import { useMemo } from 'react'

const OverviewButton: FC<{
  hideLabel?: boolean
}> = ({ hideLabel }) => {
  const nav = useNavigate()
  const teamStateMap = useTeamStateMap()
  const enabled = useMemo(
    () =>
      (Object.values(teamStateMap) || []).find(teamState => teamState.show)
        ?.team.exercise.id,
    [teamStateMap]
  )
  /*
   * Button should work when team is enabled, or in exceptional cases when exerciseId is known
   *
   */

  return (
    <Button
      icon='feed'
      alignText='left'
      fill
      minimal
      title='Overview all teams'
      disabled={!enabled}
      onClick={() => {
        // eslint-disable-next-line @typescript-eslint/no-unused-expressions
        !!enabled &&
          nav('/instructor/:exerciseId', {
            params: {
              exerciseId: enabled,
            },
          })
      }}
      text={!hideLabel && 'Overview'}
    />
  )
}

export default OverviewButton
