import { css } from '@emotion/css'
import type { RestrictedUserF } from '@inject/graphql/fragment-types'
import type { FC } from 'react'

const usernameClass = css`
  text-decoration: underline;
`

interface LabelProps {
  user: RestrictedUserF
}

const Label: FC<LabelProps> = ({ user }) => {
  const { username, firstName, lastName, group } = user
  const name = `${firstName || ''} ${lastName || ''}`.trim()
  return (
    <>
      <span className={usernameClass}>{username}</span>
      {`${name ? `, ${name}` : ''}${group ? ` (${group})` : ''}`}
    </>
  )
}

export default Label
