import Filters from '@/components/Filters'
import { Checkbox } from '@blueprintjs/core'
import type { FC } from 'react'
import type { Filter } from '../utils'
import { AUTH_GROUPS } from '../utils'

const UserGroups: FC<Filter<typeof AUTH_GROUPS>> = ({
  selected,
  setSelected,
}) => {
  const onItemSelect = (group: (typeof AUTH_GROUPS)[0]) =>
    setSelected(prev => [...prev, group])
  const onRemove = (groupToRemove: (typeof AUTH_GROUPS)[0]) =>
    setSelected(prev => prev.filter(group => group !== groupToRemove))

  const filters = (
    <>
      {AUTH_GROUPS.map(group => (
        <Checkbox
          key={group}
          label={group}
          checked={selected.includes(group)}
          onChange={() =>
            selected.includes(group) ? onRemove(group) : onItemSelect(group)
          }
        />
      ))}
    </>
  )

  return (
    <Filters
      fill
      noWrap
      heading='User groups'
      content={filters}
      position='left'
      onSelectAll={() => setSelected(AUTH_GROUPS)}
      onDeselectAll={() => setSelected([])}
    />
  )
}

export default UserGroups
