import Filters from '@/components/Filters'
import { Checkbox } from '@blueprintjs/core'
import type { FC } from 'react'
import type { Active, Filter } from '../utils'

const Active: FC<Filter<Active>> = ({ selected, setSelected }) => {
  const filters = (
    <>
      <Checkbox
        key='active'
        label='Active'
        checked={selected.active}
        onChange={() => setSelected({ ...selected, active: !selected.active })}
      />
      <Checkbox
        key='inactive'
        label='Inactive'
        checked={selected.inactive}
        onChange={() =>
          setSelected({ ...selected, inactive: !selected.inactive })
        }
      />
    </>
  )

  return (
    <Filters
      fill
      noWrap
      heading='Active status'
      content={filters}
      position='left'
      onSelectAll={() => setSelected({ active: true, inactive: true })}
      onDeselectAll={() => setSelected({ active: false, inactive: false })}
    />
  )
}

export default Active
