import type { ValueType } from '@/components/SortableTable/typing'
import { defaultFormatValue } from '@/components/SortableTable/utils'
import { css } from '@emotion/css'
import type { FC } from 'react'

interface UserDetailRowProps {
  name: string
  value: ValueType
}

const detailRowName = css`
  font-weight: bolder;
`

const UserDetailRow: FC<UserDetailRowProps> = ({ name, value }) => (
  <div>
    <span className={detailRowName}>{name}: </span> {defaultFormatValue(value)}
  </div>
)

export default UserDetailRow
