import { useParams } from '@/router'
import { useSetPageTitle } from '@/utils'
import TraineeView from '@/views/TraineeView'
import { Outlet } from 'react-router-dom'

const Layout = () => {
  const { exerciseId, teamId } = useParams('/trainee/:exerciseId/:teamId')
  useSetPageTitle('Trainee')

  return (
    <TraineeView exerciseId={exerciseId} teamId={teamId}>
      <Outlet />
    </TraineeView>
  )
}

export default Layout
