import Definitions from '@/editor/Definitions'
import EditorPage from '@/editor/EditorPage'
import { GITLAB_ACCESS_FORM } from '@/editor/assets/pageContent/definitions'
import { PageNames } from '@/editor/types'
import useGitlabStorage from '@/editor/useGitlabStorage'
import { useNavigate } from '@/router'
import { useSetPageTitle } from '@/utils'
import { Button } from '@blueprintjs/core'

const EditorDefinitionsPage = () => {
  useSetPageTitle('Editor - definitions')
  const nav = useNavigate()
  const [gitlabConfig] = useGitlabStorage()

  return (
    <EditorPage
      pageKey={PageNames.DEFINITIONS}
      prevPath='/editor'
      pageVisible
      nextVisible={false}
      headerElement={
        <Button icon='cog' onClick={() => nav('/editor/gitlab-settings')} />
      }
      descriptionElement={
        <p>
          {GITLAB_ACCESS_FORM.group.label}:{' '}
          {`${gitlabConfig?.gitlabHost}/${gitlabConfig?.groupPath}`}
        </p>
      }
    >
      <Definitions />
    </EditorPage>
  )
}

export default EditorDefinitionsPage
