import DownloadDefinition from '@/editor/DownloadDefinition'
import EditorPage from '@/editor/EditorPage'
import { PageNames } from '@/editor/types'
import useEditorAccessStorage from '@/editor/useEditorAccessStorage'
import { useNavigate } from '@/router'
import { Button } from '@blueprintjs/core'
import { memo } from 'react'

const DownloadPage = () => {
  const [access] = useEditorAccessStorage()
  const nav = useNavigate()

  return (
    <EditorPage
      pageKey={PageNames.DOWNLOAD}
      prevPath='/editor/create/conclusion'
      nextVisible={false}
      pageVisible={access?.conclusionFilled}
      headerElement={
        <Button
          icon='cog'
          onClick={() => nav('/editor/create/gitlab-settings')}
        />
      }
    >
      <DownloadDefinition />
    </EditorPage>
  )
}

export default memo(DownloadPage)
