import EditorPage from '@/editor/EditorPage'
import LearningObjectiveForm from '@/editor/LearningObjectiveForm'
import LearningObjectives from '@/editor/LearningObjectives'
import { PageNames } from '@/editor/types'
import useEditorAccessStorage from '@/editor/useEditorAccessStorage'
import { memo } from 'react'

const LearningObjectivesPage = () => {
  const [access] = useEditorAccessStorage()

  return (
    <EditorPage
      pageKey={PageNames.LEARNING_OBJECTIVES}
      prevPath='/editor/create/exercise-information'
      nextPath='/editor/create/injects'
      pageVisible={access?.exerciseInformationFilled}
      nextDisabled={!access?.objectivesFilled}
    >
      <LearningObjectives />
      <LearningObjectiveForm
        buttonProps={{
          minimal: true,
          text: 'Add new learning objective',
          alignText: 'left',
          icon: 'plus',
          style: { padding: '1rem', width: '100%' },
        }}
      />
    </EditorPage>
  )
}

export default memo(LearningObjectivesPage)
