import EditorPage from '@/editor/EditorPage'
import IntroductionForm from '@/editor/IntroductionForm'
import { PageNames } from '@/editor/types'
import useEditorAccessStorage from '@/editor/useEditorAccessStorage'
import { memo } from 'react'

const IntroductionPage = () => {
  const [access] = useEditorAccessStorage()

  return (
    <EditorPage
      pageKey={PageNames.INTRODUCTION}
      prevPath='/editor'
      nextPath='/editor/create/exercise-information'
      pageVisible
      nextDisabled={!access?.introductionFilled}
    >
      <IntroductionForm />
    </EditorPage>
  )
}

export default memo(IntroductionPage)
