import EditorPage from '@/editor/EditorPage'
import GitlabSettings from '@/editor/GitlabSettings'
import { PageNames } from '@/editor/types'
import useEditorAccessStorage from '@/editor/useEditorAccessStorage'
import { memo } from 'react'

const EditorGitlabSettingsPage = () => {
  const [access] = useEditorAccessStorage()

  return (
    <EditorPage
      pageKey={PageNames.GITLAB}
      prevPath='/editor/create/save'
      nextVisible={false}
      pageVisible={access?.conclusionFilled}
    >
      <GitlabSettings prevPath='/editor/create/save' />
    </EditorPage>
  )
}

export default memo(EditorGitlabSettingsPage)
