import EditorPage from '@/editor/EditorPage'
import EmailAddressForm from '@/editor/EmailAddressForm'
import EmailAddresses from '@/editor/EmailAddresses'
import { PageNames } from '@/editor/types'
import useEditorAccessStorage from '@/editor/useEditorAccessStorage'
import { memo } from 'react'

const EmailAddressesPage = () => {
  const [access] = useEditorAccessStorage()

  return (
    <EditorPage
      pageKey={PageNames.EMAILS}
      prevPath='/editor/create/other'
      nextVisible={false}
      pageVisible={access?.injectsFilled}
    >
      <EmailAddresses />
      <EmailAddressForm
        buttonProps={{
          minimal: true,
          text: 'Add email address',
          alignText: 'left',
          icon: 'plus',
          style: { padding: '1rem', width: '100%' },
        }}
      />
    </EditorPage>
  )
}

export default memo(EmailAddressesPage)
