import { useTeamStateMap } from '@/clientsettings/vars/teams'
import LinkButton from '@/components/LinkButton'
import { ButtonGroup } from '@blueprintjs/core'
import { css } from '@emotion/css'
import Reloader from '@inject/graphql/components/Reloader'
import { useTypedQuery } from '@inject/graphql/graphql'
import { GetRunningExercises } from '@inject/graphql/queries'
import type { FC } from 'react'

const wrapper = css`
  display: flex;
  justify-content: space-between;
  align-items: center;
  gap: 0.5rem;
`

interface StaffSelectorInterface {
  enableRefresh?: boolean
}

const StaffSelector: FC<StaffSelectorInterface> = ({ enableRefresh }) => {
  const [{ data }, refetch] = useTypedQuery({
    query: GetRunningExercises,
    requestPolicy: 'network-only',
  })
  const teamStateMap = useTeamStateMap()

  const anyExerciseRunning = (data?.exercises?.length || 0) > 0

  return (
    <div className={wrapper}>
      <ButtonGroup large fill>
        <LinkButton
          link={['/instructor']}
          button={{
            icon: 'intelligence',
            title: anyExerciseRunning
              ? 'Enter Instructor view'
              : 'Please wait for the administrator to start the exercises',
            disabled:
              !anyExerciseRunning && Object.keys(teamStateMap).length === 0,
            text: 'Instructor',
          }}
        />
        <LinkButton
          link={['/analyst']}
          button={{ icon: 'series-search', text: 'Analyst' }}
        />
      </ButtonGroup>
      {enableRefresh && <Reloader minimal onRefetch={refetch} />}
    </div>
  )
}

export default StaffSelector
