import LinkButton from '@/components/LinkButton'
import { type FC } from 'react'
import { matchPath, useLocation } from 'react-router-dom'

interface LearningObjectivesButtonProps {
  exerciseId: string | undefined
  teamId: string | undefined
  hideLabel: boolean
}

const LearningObjectivesButton: FC<LearningObjectivesButtonProps> = ({
  exerciseId,
  teamId,
  hideLabel,
}) => {
  const { pathname } = useLocation()

  return (
    <LinkButton
      link={
        exerciseId === undefined || teamId === undefined
          ? undefined
          : [
              '/instructor/:exerciseId/:teamId/learning-objectives',
              { params: { exerciseId, teamId } },
            ]
      }
      button={{
        icon: 'learning',
        active:
          matchPath(
            {
              path: '/instructor/:exerciseId/:teamId/learning-objectives',
              end: false,
            },
            pathname
          ) !== null,
        alignText: 'left',
        fill: true,
        disabled: !teamId || !exerciseId,
        minimal: true,
        text: !hideLabel && 'Learning objectives',
        title:
          !teamId || !exerciseId
            ? 'A team has to be selected to show learning objectives'
            : 'Learning objectives',
        style: { whiteSpace: 'nowrap' },
      }}
    />
  )
}

export default LearningObjectivesButton
