import Tags from '@/components/Tags'
import { Section, SectionCard } from '@blueprintjs/core'
import { css, cx } from '@emotion/css'
import type { TeamLearningObjective } from '@inject/graphql/fragment-types'
import StyledTag from '@inject/shared/components/StyledTag'
import type { FC } from 'react'
import LearningActivity from './LearningActivity'
import { reached, subtitle, title } from './classes'

const objectiveClass = css`
  flex-shrink: 0;
  margin-bottom: 1px;

  &:first-child:not(:only-child) {
    border-bottom-left-radius: 0;
    border-bottom-right-radius: 0;
  }
  & + & {
    border-top-left-radius: 0;
    border-top-right-radius: 0;
  }
`

const activities = css`
  display: flex;
  flex-direction: column;
  gap: 2rem;
  margin: 1rem;
`

interface LearningObjectiveProps {
  objective: TeamLearningObjective
  teamId: string
  defaultIsOpen?: boolean
}

const LearningObjective: FC<LearningObjectiveProps> = ({
  objective,
  teamId,
  defaultIsOpen,
}) => (
  <Section
    title={<div className={title}>{objective.objective.name}</div>}
    subtitle={
      <div className={subtitle}>
        {objective.objective.description && (
          <div>{objective.objective.description}</div>
        )}
        {objective.objective.tags && <Tags tags={objective.objective.tags} />}
      </div>
    }
    collapsible
    collapseProps={{
      defaultIsOpen,
    }}
    compact
    className={cx({ [objectiveClass]: true, [reached]: objective.reached })}
    rightElement={
      objective.reached ? (
        <StyledTag content='Reached' isAchieved />
      ) : (
        <StyledTag content='Not reached' isAchieved={false} />
      )
    }
  >
    <SectionCard padded className={activities}>
      {objective.activities.map(activity => (
        <LearningActivity
          key={activity.id}
          activity={activity}
          teamId={teamId}
        />
      ))}
    </SectionCard>
  </Section>
)

export default LearningObjective
