import { useTeamStateMap } from '@/clientsettings/vars/teams'
import { useNavigate } from '@/router'
import { Button } from '@blueprintjs/core'
import { useMemo, type FC } from 'react'
import { useLocation } from 'react-router-dom'

interface InstructorTeamSelectorProps {
  hideLabel?: boolean
  teamId: string | undefined
}

const InstructorTeamSelector: FC<InstructorTeamSelectorProps> = ({
  hideLabel,
}) => {
  const nav = useNavigate()
  const loc = useLocation()
  const teamState = useTeamStateMap()
  const selectedTeamsAlready = useMemo(
    () => Object.entries(teamState).some(([, x]) => x.show),
    [teamState]
  )

  return (
    <Button
      active={loc.pathname === '/instructor/selectTeam'}
      icon='team'
      alignText='left'
      fill
      minimal
      intent={!selectedTeamsAlready ? 'warning' : undefined}
      text={!hideLabel && 'Select teams'}
      title='Select teams'
      onClick={() => {
        if (selectedTeamsAlready) {
          if (
            window.confirm(
              'Are you sure you want to switch your teams? This will force re-fetching of data and induce brief performance issues'
            )
          ) {
            nav('/instructor')
          }
        } else {
          nav('/instructor')
        }
      }}
    />
  )
}

export default InstructorTeamSelector
