import { useTeamStateMap } from '@/clientsettings/vars/teams'
import type { FC } from 'react'
import { useEffect, useMemo } from 'react'
import TeamButton from './TeamButton'
import useTeamStateValidator from './useTeamStateValidator'

const TeamListVertical: FC<{
  hideLabel?: boolean
}> = ({ hideLabel }) => {
  const validator = useTeamStateValidator()
  const teamStateMap = useTeamStateMap()

  const teamStates = useMemo(() => Object.values(teamStateMap), [teamStateMap])

  const selectedTeamStates = useMemo(
    () => teamStates.filter(teamState => teamState.show),
    [teamStates]
  )

  useEffect(() => {
    validator()
  }, [])

  return (
    <div className='teamButtons'>
      {selectedTeamStates.map(teamState => (
        <TeamButton
          key={teamState.team.id}
          hideLabel={hideLabel}
          teamState={teamState}
        />
      ))}
    </div>
  )
}

export default TeamListVertical
