import type {
  FreeFormQuestionDetails,
  Question,
} from '@inject/graphql/fragment-types'

export const canBeReviewed = (questions: Question[]) =>
  questions.some(
    question =>
      question.type === 'FREE_FORM' &&
      (question.details as FreeFormQuestionDetails).relatedMilestones.length > 0
  )
