import { Button, Dialog, DialogBody } from '@blueprintjs/core'
import { dialogBody, maximizedDialog } from '@inject/shared/css/dialog'
import type { FC } from 'react'
import { useState } from 'react'
import InjectForm from './InjectForm'

interface InstructorInjectProps {
  hideLabel?: boolean
  exerciseId: string
  teamId: string
}

const InstructorInjectFocused: FC<InstructorInjectProps> = ({
  hideLabel,
  exerciseId,
  teamId,
}) => {
  const [isComposerOpen, setIsComposerOpen] = useState(false)

  return (
    <>
      <Button
        active={isComposerOpen}
        alignText='left'
        title={'Send an inject'}
        minimal
        intent='primary'
        icon='annotation'
        text={!hideLabel && 'Send an inject'}
        onClick={() => setIsComposerOpen(!isComposerOpen)}
      />
      <Dialog
        className={maximizedDialog}
        canOutsideClickClose={false}
        isOpen={isComposerOpen}
        onClose={() => {
          setIsComposerOpen(false)
        }}
        title={`Send an inject`}
        icon='annotation'
      >
        <DialogBody className={dialogBody}>
          <InjectForm
            exerciseId={exerciseId}
            teamId={teamId}
            setIsOpen={setIsComposerOpen}
          />
        </DialogBody>
      </Dialog>
    </>
  )
}

export default InstructorInjectFocused
