import DefinitionList from '@/components/DefinitionList'
import { Button, ButtonGroup, Section, SectionCard } from '@blueprintjs/core'
import Reloader from '@inject/graphql/components/Reloader'
import { ReloadDefinitions } from '@inject/graphql/mutations.client'
import { useState, type FC } from 'react'
import { useClient } from 'urql'
import DefinitionUploader from './DefinitionUploader'

interface DefinitionManagerProps {
  className?: string
}

const DefinitionManager: FC<DefinitionManagerProps> = ({ className }) => {
  const client = useClient()

  const [uploadOpen, setUploadOpen] = useState(false)

  return (
    <>
      <Section
        title='Definitions'
        rightElement={
          <ButtonGroup onClick={e => e.stopPropagation()}>
            <Button
              active={uploadOpen}
              onClick={() => {
                setUploadOpen(true)
              }}
              icon='upload'
            >
              Upload
            </Button>
            <Reloader
              onRefetch={() =>
                client.mutation(ReloadDefinitions, {}).toPromise()
              }
            />
          </ButtonGroup>
        }
      >
        <SectionCard padded>
          <DefinitionList className={className} />
        </SectionCard>
      </Section>

      <DefinitionUploader open={uploadOpen} setOpen={setUploadOpen} />
    </>
  )
}

export default DefinitionManager
