import type { ItemRendererProps } from '@blueprintjs/select'
import type { Email } from '@inject/graphql/fragment-types'

export interface ExtendedItemRendererProps extends ItemRendererProps {
  description?: string
}
export type ExtendedItemRenderer<T> = (
  item: T,
  itemProps: ExtendedItemRendererProps
) => React.JSX.Element | null

export type ExtendedEmail = Email & { to: string; subject: string }
