import { css } from '@emotion/css'
import type { EmailThread } from '@inject/graphql/fragment-types'
import CenteredSpinner from '@inject/shared/components/CenteredSpinner'
import ErrorMessage from '@inject/shared/components/ErrorMessage'
import type { FC } from 'react'
import InstructorEmailForm from '../EmailForm/InstructorEmailForm'
import TraineeEmailForm from '../EmailForm/TraineeEmailForm'
import type { FormState } from '../EmailForm/useFormState'

const emailFormComponent = css`
  overflow-y: auto;
  flex: 1;
  display: flex;
`

interface ContentProps {
  loading?: boolean
  error?: Error
  teamId: string
  exerciseId: string
  emailThread?: EmailThread
  formState: FormState
  handleClose: () => void
  emailForm: 'trainee' | 'instructor'
}

const Content: FC<ContentProps> = ({
  loading,
  error,
  teamId,
  exerciseId,
  emailThread,
  formState,
  handleClose,
  emailForm,
}) => {
  if (loading) return <CenteredSpinner />
  if (error)
    return (
      <ErrorMessage>
        <h1>Error occurred!</h1>
        <p>{error.message}</p>
      </ErrorMessage>
    )

  return (
    <div className={emailFormComponent}>
      {emailForm === 'trainee' ? (
        <TraineeEmailForm
          onSuccess={handleClose}
          teamId={teamId}
          exerciseId={exerciseId}
          emailThread={emailThread}
          formState={formState}
        />
      ) : (
        <InstructorEmailForm
          onSuccess={handleClose}
          teamId={teamId}
          exerciseId={exerciseId}
          emailThread={emailThread}
          formState={formState}
        />
      )}
    </div>
  )
}

export default Content
