import type { LearningActivityType } from '../indexeddb/types'

export type ConfigYaml = {
  exercise_duration: number
  email_between_teams?: boolean
  custom_email_suffix?: string
  show_exercise_time?: boolean
  enable_roles?: boolean
  version: string
}

export type ChannelYaml = {
  name: string
  type: string
}

export type LearningObjectiveYaml = {
  name: string
  tags?: string
  activities: LearningActivityYaml[]
}

export type LearningObjectiveYamlWithTypes = {
  name: string
  tags?: string
  activities: LearningActivityYamlWithType[]
}

export type LearningActivityYaml = {
  name: string
  tags?: string
}

export type LearningActivityYamlWithType = LearningActivityYaml & {
  type: LearningActivityType
}

export type ContentYaml = {
  content?: string
  content_path?: string
  file_name?: string
}

export type ControlYaml = {
  milestone_condition?: string
  activate_milestone?: string
  deactivate_milestone?: string
  roles?: string
}

export type OverlayYaml = {
  duration: number
}

export type ToolYaml = {
  name: string
  tooltip_description?: string
  hint?: string
  default_response: string
  roles?: string
  responses: ToolResponseYaml[]
}

export type ToolResponseYaml = {
  param: string
  regex?: boolean
  time?: number
  content?: ContentYaml
  control?: ControlYaml
}

export type EmailAddressYaml = {
  address: string
  team_visible?: boolean
  description: string
  control?: ControlYaml
  organization?: string
  templates?: EmailTemplateYaml[]
}

export type EmailTemplateYaml = {
  context: string
  content?: ContentYaml
  control?: ControlYaml
}

export type InjectCategoryYaml = {
  name: string
  time?: number
  delay?: number
  organization?: string
  type?: string
  alternatives: InjectAlternativeInfoYaml[] | InjectAlternativeEmailYaml[]
}

export type InjectAlternativeInfoYaml = {
  name: string
  content?: ContentYaml
  control?: ControlYaml
  overlay?: OverlayYaml
}

export type InjectAlternativeEmailYaml = {
  name: string
  sender: string
  subject: string
  content?: ContentYaml
  control?: ControlYaml
  extra_copies?: number
  overlay?: OverlayYaml
}

export type QuestionnaireYaml = {
  title: string
  time?: number
  control?: ControlYaml
  overlay?: OverlayYaml
  questions: QuestionYaml[]
}

export type QuestionYaml = {
  content: ContentYaml
  max: number
  labels?: string
  correct?: number
  control?: ControlYaml
}

export type MilestoneYaml = {
  name: string
  roles?: string
  file_names?: string
  final?: boolean
  activity?: string
  initial_state?: boolean
}

export type MappedActivity = {
  id: number
  milestoneName: string
}

export type MappedMilestone = {
  id: number
  name: string
}

export type MappedInjectControl = {
  id: number
  milestoneId?: number
  milestoneName?: string
  milestoneCondition?: string
  time?: number
  delay?: number
}

export type MappedQuestionnaireControl = {
  id: number
  milestoneId?: number
  milestoneName?: string
  milestoneCondition?: string
  time?: number
}

export type MappedToolResponseControl = {
  id: number
  milestoneId?: number
  milestoneName?: string
  milestoneCondition?: string
}

export type MappedEmailTemplateControl = {
  id: number
  milestoneId?: number
  milestoneName?: string
}
