import { InjectType } from '@/editor/indexeddb/types'
import type { EditorConfig } from '@/editor/useEditorStorage'
import notEmpty from '@inject/shared/utils/notEmpty'
import { db } from '../../indexeddb/db'

export const generateChannels = async (config: EditorConfig) => {
  const emailAddressesCount = await db.emailAddresses.count()
  const toolsCount = await db.tools.count()
  const questionnairesCount = await db.injectInfos
    .where({ type: InjectType.QUESTIONNAIRE })
    .count()

  const generatedChannels = [
    {
      name: config.infoChannelName || 'Exercise information',
      type: 'info',
    },
    emailAddressesCount
      ? {
          name: config.emailChannelName || 'Emails',
          type: 'email',
        }
      : null,
    toolsCount
      ? {
          name: config.toolChannelName || 'Tools',
          type: 'tool',
        }
      : null,
    questionnairesCount
      ? {
          name: config.formChannelName || 'Questions',
          type: 'form',
        }
      : null,
  ]

  return generatedChannels.filter(notEmpty)
}
