import { useLocalStorageState } from 'ahooks'

export interface EditorAccess {
  introductionFilled?: boolean
  exerciseInformationFilled?: boolean
  objectivesFilled?: boolean
  injectsFilled?: boolean
  specificationsFilled?: boolean
  finalInformationFilled?: boolean
  conclusionFilled?: boolean
}

const useEditorAccessStorage = () =>
  useLocalStorageState<EditorAccess>('editor-access', {
    defaultValue: {},
    listenStorageChange: true,
  })

export default useEditorAccessStorage
