export enum PageNames {
  LANDING_PAGE = 'landingPage',
  DEFINITIONS = 'definitions',
  INTRODUCTION = 'introduction',
  EXERCISE_INFORMATION = 'exerciseInformation',
  LEARNING_OBJECTIVES = 'learningObjectives',
  INJECTS = 'injects',
  ACTIVITY_SPECIFICATION_OVERVIEW = 'activitySpecificationOverview',
  ACTIVITY_SPECIFICATION = 'activitySpecification',
  INJECT_SPECIFICATION_OVERVIEW = 'injectSpecificationOverview',
  INJECT_SPECIFICATION = 'injectSpecification',
  OTHER = 'other',
  TOOLS = 'tools',
  EMAILS = 'emails',
  FINAL_INFORMATION = 'finalInformation',
  CONCLUSION = 'conclusion',
  DOWNLOAD = 'download',
  GITLAB = 'gitlab',
}

export type FAQQuestion = {
  question: string
  answer: string
}

export type PageContent = {
  title: string
  description: string
}

type PageContentWithFaq = PageContent & {
  faq?: FAQQuestion[]
}

export type PageInformation = {
  [key in PageNames]: PageContentWithFaq
}

export enum NavigationLinkNames {
  INTRODUCTION = 'introduction',
  EXERCISE_INFORMATION = 'exerciseInformation',
  LEARNING_OBJECTIVES = 'learningObjectives',
  INJECTS = 'injects',
  ACTIVITY_SPECIFICATION_OVERVIEW = 'activitySpecificationOverview',
  INJECT_SPECIFICATION_OVERVIEW = 'injectSpecificationOverview',
  OTHER = 'other',
  FINAL_INFORMATION = 'finalInformation',
  CONCLUSION = 'conclusion',
  DOWNLOAD = 'download',
}

export type NavigationPage = {
  title: string
  links: { [key in NavigationLinkNames]: string }
}

type ChecklistItem = {
  name: string
  description?: string
}

export type Checklist = ChecklistItem[]

export type ExtendedLabel = {
  label: string
  optional?: boolean
  tooltip?: string
}

export type Form = {
  [key: string]: ExtendedLabel
}
