import type { OptionProps } from '@blueprintjs/core'

export enum LearningActivityType {
  TOOL = 'Tool',
  EMAIL = 'Email',
}

export enum InjectType {
  INFORMATION = 'Information',
  EMAIL = 'Email',
  QUESTIONNAIRE = 'Questionnaire',
}

export enum MilestoneEventType {
  LEARNING_ACTIVITY,
  INJECT,
  TOOL,
  EMAIL,
}

export type LearningObjectiveInfo = {
  id: number
  name: string
}

export type LearningActivityInfo = {
  id: number
  name: string
  description?: string
  type: LearningActivityType
  learningObjectiveId: number
}

export type InjectInfo = {
  id: number
  name: string
  description?: string
  type: InjectType
}

export type ToolInfo = {
  id: number
  name: string
  tooltipDescription?: string
  defaultResponse: string
  hint?: string
}

export type ToolResponse = {
  id: number
  learningActivityId?: number
  toolId: number
  parameter: string
  isRegex?: boolean
  content?: string
  fileId?: number
  time?: number
  milestoneCondition?: number[]
}

export type EmailAddressInfo = {
  id: number
  address: string
  description: string
  teamVisible?: boolean
  organization?: string
}

export type EmailTemplate = {
  id: number
  learningActivityId?: number
  emailAddressId: number
  context: string
  content?: string
  fileId?: number
}

export type EmailInject = {
  id: number
  injectInfoId: number
  emailAddressId: number
  subject: string
  content?: string
  extraCopies?: number
  fileId?: number
}

export type InformationInject = {
  id: number
  injectInfoId: number
  content?: string
  fileId?: number
}

export type Questionnaire = {
  id: number
  injectInfoId: number
  title: string
}

export type QuestionnaireQuestion = {
  id: number
  questionnaireId: number
  text: string
  max: number
  correct?: number
  labels?: string
}

export type InjectControl = {
  id: number
  injectInfoId: number
  start?: number
  delay?: number
  milestoneCondition?: number[]
}

export type Overlay = {
  id: number
  injectInfoId: number
  duration: number
}

export type ContentFile = {
  id: number
  name: string
  blob: Blob
}

export type Milestone = {
  id: number
  type: MilestoneEventType
  referenceId: number
}

export type MarkdownContent = {
  id: number
  fileName: string
  content: string
}

// joined types
export type MilestoneName = Milestone & {
  name: string
}

export type JoinedToolResponse = ToolResponse & {
  activateMilestone?: MilestoneName
  milestoneConditionWithNames?: OptionProps[]
  file?: ContentFile
}

export type JoinedTool = ToolInfo & {
  toolResponses: JoinedToolResponse[]
}

export type JoinedEmailTemplate = EmailTemplate & {
  activateMilestone?: MilestoneName
  file?: ContentFile
}

export type JoinedEmailAddress = EmailAddressInfo & {
  emailTemplates: JoinedEmailTemplate[]
}

export type JoinedInformationInject = InformationInject & {
  file?: ContentFile
  overlay?: Overlay
  activateMilestone?: MilestoneName
  milestoneCondition?: OptionProps[]
}

export type JoinedInformationInjectCategory = InjectInfo & {
  info: JoinedInformationInject
  injectControl?: InjectControl
}

export type JoinedEmailInject = EmailInject & {
  sender?: EmailAddressInfo
  file?: ContentFile
  overlay?: Overlay
  activateMilestone?: MilestoneName
  milestoneCondition?: OptionProps[]
}

export type JoinedEmailInjectCategory = InjectInfo & {
  email: JoinedEmailInject
  injectControl?: InjectControl
}

export type JoinedQuestionnaireInject = Questionnaire & {
  questions: QuestionnaireQuestion[]
  injectControl?: InjectControl
  activateMilestone?: MilestoneName
  milestoneCondition?: OptionProps[]
  overlay?: Overlay
}

export type JoinedLearningObjective = LearningObjectiveInfo & {
  activities: LearningActivityInfo[]
}
