import type { PageInformation } from '../types'

export const PAGE_INFORMATION: PageInformation = {
  landingPage: {
    title: 'Editor: cybersecurity exercise design tool',
    description:
      'Exercise Designers, welcome to your guided journey. Through structured phases, you will develop a great cybersecurity exercise.',
  },
  definitions: {
    title: 'Select Definitions',
    description:
      'Use an exercise definition created by someone else. Download it to review, adapt, or refine as needed to fit your objectives.',
  },
  introduction: {
    title: 'Before you start',
    description:
      'A good understanding of the exercise key aspects is essential before starting work in Editor. Use this preparatory checklist to ensure you have gathered all the important information.',
    faq: [
      {
        question: 'How to Think About Exercise Design?',
        answer:
          'We created the INJECT process to assist you. It consists of five interconnected phases inspired by design thinking: Understand, Specify, Prepare, Execute, and Reflect. The main advantage is that it incorporates the platform into the entire process. Complete process is available in our documentation: <a href="https://docs.inject.muni.cz/INJECT_process/intro/overview/" target="_blank">INJECT Process Overview</a> <br> <img src="/src/editor/assets/images/1.svg" alt="INJECT Process Overview" style="height: 100%; width: 100%; object-fit: contain" />',
      },
    ],
  },
  exerciseInformation: {
    title: 'Define Exercise essentials',
    description:
      'Provide the key details of your exercise. This helps others understand its purpose, ensures the information is shared with instructors and analysts, and supports you in refining your concept as you design.',
    faq: [
      {
        question: 'How to Think About Exercise Design?',
        answer:
          'We created the INJECT process to assist you. It consists of five interconnected phases inspired by design thinking: Understand, Specify, Prepare, Execute, and Reflect. The main advantage is that it incorporates the platform into the entire process. Complete process is available in our documentation: <a href="https://docs.inject.muni.cz/INJECT_process/intro/overview/" target="_blank">INJECT Process Overview</a> <br> <img src="/src/editor/assets/images/1.svg" alt="INJECT Process Overview" style="height: 100%; width: 100%; object-fit: contain" />',
      },
      {
        question: 'What is the purpose of the exercise?',
        answer:
          '<strong>The exercise`s purpose</strong> comes from its underlying needs — the reason the client chooses to exercise. This connects the exercise to what the client aims to achieve, often protecting assets like money or reputation. Understanding needs may reveal more specific goals, such as preparing for a rival`s cyber attack or learning from past incidents. Example: "Our organization needs to handle data leaks effectively to avoid penalties and reputational damage." More information at: <a href="https://docs.inject.muni.cz/INJECT_process/understand/overview/" target="_blank">https://docs.inject.muni.cz/INJECT_process/understand/overview/</a>',
      },
      {
        question: 'What are the Learning Objectives?',
        answer:
          '<strong>Learning Objectives (LOs)</strong> define what trainees should learn or practice and give structure to the exercise. Each LO breaks down into specific learning activities (LAs). To specify LOs, identify what skills or actions participants need for the exercise¨s main goal. Aim for a maximum of 7 LOs.  More information at: <a href="https://docs.inject.muni.cz/INJECT_process/specify/learning_objectives/" target="_blank">https://docs.inject.muni.cz/INJECT_process/specify/learning_objectives/</a>.',
      },
      {
        question: 'What are the basic types of exercises?',
        answer:
          '<strong>Basic Types of Exercises</strong>  <br> 1. <strong>Strategic Decision-Making Exercises</strong>: Use forms, questionnaires, scales, or media inputs; ideal for managers or CSIRT teams. <br> 2. <strong>Process-Technical Exercises</strong>: Simulate processes with email injects and end with reflection questions. You can combine both, but start with one type.',
      },
    ],
  },
  learningObjectives: {
    title: 'Specify Learning objectives and Learning Activities',
    description:
      'You have to start with the specification of <strong>Learning Objectives (LOs)</strong> and <strong>Learning Activities (LAs)</strong> becuase they structure your exercise. <strong>LOs</strong> outline what trainees should learn, while <strong>LAs</strong> detail the specific actions trainees perform, tracked on the platform to assess performance. Each <strong>LO</strong> connects to multiple <strong>LAs</strong> (ideally around five), but each <strong>LA</strong> links to only one <strong>LO</strong>. Think of this phase as creating the <strong>exercise concept</strong>. You will prepare the detailed content later in the process.',
  },
  injects: {
    title: 'Specify Injects',
    description:
      'Specify the injects that will be sent to participants. Injects initiate learning activities or provide context. Use the platform to combine various injects for a dynamic and engaging experience.Think of this phase as creating the <strong>exercise concept</strong>. You will prepare the detailed content later in the process.',
  },
  activitySpecificationOverview: {
    title: 'Prepare Learning Activities',
    description:
      'Now is the time to prepare the <strong>detailed content</strong> for the learning activities you specified earlier in this process.',
  },
  activitySpecification: {
    title: 'Design this Learning Activity',
    description:
      'Remember, you specified this learning activity in relation to the learning objective. Make sure it is <strong>truly aligned</strong>.',
  },
  injectSpecificationOverview: {
    title: 'Prepare Injects',
    description:
      'Here you will prepare the <strong>detailed content</strong> for the injects you specified earlier in this process.',
  },
  injectSpecification: {
    title: 'Design this Inject',
    description:
      'Remember, injects should initiate learning activities or provide context for them. Think carefully if the designed content truly guides trainees to the activities you intended.',
  },
  other: {
    title: 'Prepare Tools and Addresses',
    description:
      'You can add additional email addresses and tools that will <strong>enhance</strong> the overall experience.',
  },
  tools: {
    title: 'Define tools',
    description:
      'You can define and add additional tools to enhance the exercise experience.',
  },
  emails: {
    title: 'Define email addresses',
    description:
      'Add email addresses to build a more robust and realistic communication ecosystem for your exercise.',
  },
  finalInformation: {
    title: 'Set Exercise Duration and Channels names',
    description:
      'We are almost at the end of the preparation. But before that, you need to set the <strong>exercise duration</strong> and you can also <strong>customize the names of your channels</strong>.',
  },
  conclusion: {
    title: 'Before you finish',
    description:
      'It is important to understand that preparing the exercise for the platform is <strong>just one part of the overall process</strong>. The following checklist will help you identify and plan the necessary actions for a successful exercise with IXP.',
  },
  download: {
    title: 'Save your exercise',
    description:
      'Now you can download your exercise and run it on the platform. Remember to collect feedback after each session to refine this exercise or inspire new ones. <strong>Enjoy your journey to mastery!</strong> —The INJECT Team.',
  },
  gitlab: {
    title: 'Gitlab setting',
    description: 'Here you can set up a <strong>GitLab connection</strong>.',
  },
}
