## Directory structure

### pageInformation.tsx
This file contains basic information about each page in form of a JavaScript object.\
Each page is represented by a nested object. The whole object follows this structure:
```
{
    pageName: {
        title: 'Title',
        description: 'Description'
        faq: [
            {
                question: 'Question?',
                answer: 'Answer'
            },
        ]
    },
    ...
}
```
- pageName - must not be changed
- title - required, plain string
- description - required, plain sting or use HTML for formatting
- faq - optional, contains a list (array) of question objects; new questions can be added by duplicating the question object structure

Question object:
```
{
    question: 'Question?',
    answer: 'Answer'
},
```
- question - required, plain string
- required - require, plain string or HTML

### navigationContent.tsx
The file contains navigation content that follows this structure:
```
{
  title: 'Steps',
  links: {
    pageName1: 'Page 1',
    pageName2: 'Page 2',
    ...
  },
}
```
- pageName - must not be changed
- title - required, plain string
- links object with page names and corresponding names displayed in navigation
- the names have to be specified and should not be empty

### pageContent
Directory that contains multiple pages corresponding to pages in the app.\
Each file in this directory contains checklist or form object(s) with following structure:

**Checklist**
```
[
  { name: 'Check 1', description: 'Description 1' },
  { name: 'Check 2', description: 'Description 2' },
  ...
]
```
- name - required, plain string
- description - required, plain string
- the array can be extended by duplicating the check object

**Form**
```
{
  inputName: {
    label: 'Final milestone',
    tooltip: '',
    optional: true
  },
  ...
}
```
- inputLabel - must not be changed
- label - required, plain string
- tooltip - optional, plain string
- optional - should not be changed, used as an indicator of whether the input field should be filled out

### dialogContent
- contains plaintext descriptions of dialog actions

## Other

### Pictures in HTML
- the format of some values allows to use HTML string
- if the image is being inserted, the img tag needs to specify the whole path to the picture, e.g.
```<img src="/src/editor/assets/images/pic.jpg" alt="Picture">```
