import type { SwitchProps } from '@blueprintjs/core'
import { Switch } from '@blueprintjs/core'
import { memo, type FC } from 'react'
import type { ExtendedLabel } from '../../types'
import TooltipLabelContent from '../TooltipLabelContent'

interface TooltipSwitchProps {
  label: ExtendedLabel
  switchProps?: SwitchProps
}

const TooltipSwitch: FC<TooltipSwitchProps> = ({ label, switchProps }) => (
  <Switch
    {...switchProps}
    labelElement={<TooltipLabelContent label={label} />}
  />
)

export default memo(TooltipSwitch)
