import { Classes, Icon, Tooltip } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { CSSProperties } from 'react'
import { memo, type FC } from 'react'
import type { ExtendedLabel } from '../../types'

const helpIcon = css`
  margin-left: 0.5rem;
  cursor: pointer;
`

interface TooltipLabelContentProps {
  label: ExtendedLabel
  style?: CSSProperties
}

const TooltipLabelContent: FC<TooltipLabelContentProps> = ({
  label,
  style,
}) => (
  <>
    <span>{label.label}</span>
    {!label.optional && <span style={{ marginLeft: '0.1rem' }}>*</span>}
    {label.tooltip && (
      <Tooltip content={label.tooltip}>
        <Icon
          icon='help'
          className={`${Classes.TEXT_MUTED} ${helpIcon}`}
          style={{ ...style }}
        />
      </Tooltip>
    )}
  </>
)

export default memo(TooltipLabelContent)
